/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.substmodel.codon;

import dr.evolution.datatype.Codons;
import dr.evomodel.substmodel.DefaultEigenSystem;
import dr.evomodel.substmodel.DifferentiableSubstitutionModel;
import dr.evomodel.substmodel.DifferentiableSubstitutionModelUtil;
import dr.evomodel.substmodel.DifferentialMassProvider;
import dr.evomodel.substmodel.EigenSystem;
import dr.evomodel.substmodel.FrequencyModel;
import dr.evomodel.substmodel.ParameterReplaceableSubstitutionModel;
import dr.evomodel.substmodel.codon.AbstractCodonModel;
import dr.evomodel.substmodel.codon.CodonOptions;
import dr.inference.model.Parameter;
import dr.math.matrixAlgebra.WrappedMatrix;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import java.util.Collections;
import java.util.List;

public class MG94HKYCodonModel
extends AbstractCodonModel
implements Citable,
ParameterReplaceableSubstitutionModel,
DifferentiableSubstitutionModel {
    protected Parameter alphaParameter;
    protected Parameter betaParameter;
    protected Parameter kappaParameter;
    private final int numSynTransitions;
    private final int numNonsynTransitions;
    private final CodonOptions options;
    private boolean doNormalization = true;
    public static Citation CITATION = new Citation(new Author[]{new Author("SV", "Muse"), new Author("BS", "Gaut")}, "A likelihood approach for comparing synonymous and non-synonymous nucleotide substitution rates, with application to the chloroplast genome", 1994, "Molecular Biology and Evolution", 11, 715, 724);

    public MG94HKYCodonModel(Codons codons, Parameter parameter, Parameter parameter2, Parameter parameter3, FrequencyModel frequencyModel, CodonOptions codonOptions) {
        this(codons, parameter, parameter2, parameter3, frequencyModel, codonOptions, new DefaultEigenSystem(codons.getStateCount()));
    }

    MG94HKYCodonModel(Codons codons, Parameter parameter, Parameter parameter2, Parameter parameter3, FrequencyModel frequencyModel, CodonOptions codonOptions, EigenSystem eigenSystem) {
        super("MG94", codons, frequencyModel, eigenSystem);
        this.alphaParameter = parameter;
        this.addVariable(parameter);
        parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, parameter.getDimension()));
        this.betaParameter = parameter2;
        this.addVariable(parameter2);
        parameter2.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, parameter2.getDimension()));
        this.kappaParameter = parameter3;
        this.addVariable(parameter3);
        parameter3.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, parameter3.getDimension()));
        this.numSynTransitions = this.getNumSynTransitions();
        this.numNonsynTransitions = this.getNumNonsynTransitions();
        this.options = codonOptions;
    }

    private int countRates(int n, int n2) {
        int n3 = 0;
        for (byte by : this.rateMap) {
            if (by != n && by != n2) continue;
            ++n3;
        }
        return n3;
    }

    private int getNumSynTransitions() {
        return 2 * this.countRates(1, 2);
    }

    private int getNumNonsynTransitions() {
        return 2 * this.countRates(3, 4);
    }

    private double getNormalizationRatioForParameterization() {
        if (this.options.isParameterTotalRate) {
            return this.getTotalS() + this.getTotalN();
        }
        return 1.0;
    }

    @Override
    protected double getNormalizationValue(double[][] dArray, double[] dArray2) {
        double d = 1.0;
        if (this.doNormalization) {
            double d2 = this.getNormalizationRatioForParameterization();
            d = super.getNormalizationValue(dArray, dArray2) / d2;
        }
        return d;
    }

    private double getDS() {
        double d = this.alphaParameter.getParameterValue(0);
        if (this.options.isParameterTotalRate) {
            d /= (double)this.numSynTransitions;
        }
        return d;
    }

    private double getDN() {
        double d = this.betaParameter.getParameterValue(0);
        if (this.options.isParameterTotalRate) {
            d /= (double)this.numNonsynTransitions;
        }
        return d;
    }

    private double getTotalS() {
        double d = this.alphaParameter.getParameterValue(0);
        if (!this.options.isParameterTotalRate) {
            d *= (double)this.numSynTransitions;
        }
        return d;
    }

    private double getTotalN() {
        double d = this.betaParameter.getParameterValue(0);
        if (!this.options.isParameterTotalRate) {
            d *= (double)this.numNonsynTransitions;
        }
        return d;
    }

    public double getKappa() {
        return this.kappaParameter.getParameterValue(0);
    }

    @Override
    protected void setupRelativeRates(double[] dArray) {
        double d = this.getDS();
        double d2 = this.getDN();
        double d3 = this.getKappa();
        block7: for (int i = 0; i < this.rateCount; ++i) {
            switch (this.rateMap[i]) {
                case 0: {
                    dArray[i] = 0.0;
                    continue block7;
                }
                case 1: {
                    dArray[i] = d * d3;
                    continue block7;
                }
                case 2: {
                    dArray[i] = d;
                    continue block7;
                }
                case 3: {
                    dArray[i] = d2 * d3;
                    continue block7;
                }
                case 4: {
                    dArray[i] = d2;
                }
            }
        }
    }

    public void setNormalization(boolean bl) {
        this.doNormalization = bl;
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.SUBSTITUTION_MODELS;
    }

    @Override
    public String getDescription() {
        return "Muse-Gaut codon substitution model";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CITATION);
    }

    @Override
    public ParameterReplaceableSubstitutionModel factory(List<Parameter> list, List<Parameter> list2) {
        Parameter parameter = this.alphaParameter;
        Parameter parameter2 = this.betaParameter;
        Parameter parameter3 = this.kappaParameter;
        FrequencyModel frequencyModel = this.freqModel;
        assert (list.size() == list2.size());
        for (int i = 0; i < list.size(); ++i) {
            Parameter parameter4 = list.get(i);
            Parameter parameter5 = list2.get(i);
            if (parameter4 == this.alphaParameter) {
                parameter = parameter5;
                continue;
            }
            if (parameter4 == this.betaParameter) {
                parameter2 = parameter5;
                continue;
            }
            if (parameter4 == this.kappaParameter) {
                parameter3 = parameter5;
                continue;
            }
            throw new RuntimeException("Unknown parameter");
        }
        return new MG94HKYCodonModel(this.codonDataType, parameter, parameter2, parameter3, frequencyModel, this.options);
    }

    @Override
    public void setupDifferentialRates(DifferentialMassProvider.DifferentialWrapper.WrtParameter wrtParameter, double[] dArray, double d) {
        for (int i = 0; i < this.rateCount; ++i) {
            dArray[i] = wrtParameter.getRate(this.rateMap[i]) / d;
        }
    }

    @Override
    public double getWeightedNormalizationGradient(DifferentialMassProvider.DifferentialWrapper.WrtParameter wrtParameter, double[][] dArray, double[] dArray2) {
        double d = this.getNormalizationRatioForParameterization();
        double d2 = d == 1.0 ? 0.0 : 1.0 / this.getNormalizationRatioForParameterization() * wrtParameter.getNormalizationDifferential();
        return this.getNormalizationValue(dArray, dArray2) - d2;
    }

    @Override
    public WrappedMatrix getInfinitesimalDifferentialMatrix(DifferentialMassProvider.DifferentialWrapper.WrtParameter wrtParameter) {
        return DifferentiableSubstitutionModelUtil.getInfinitesimalDifferentialMatrix(wrtParameter, this);
    }

    @Override
    public DifferentialMassProvider.DifferentialWrapper.WrtParameter factory(Parameter parameter) {
        if (parameter == this.alphaParameter) {
            return new Alpha(this.getNumSynTransitions(), this.options.isParameterTotalRate);
        }
        if (parameter == this.betaParameter) {
            return new Beta(this.getNumNonsynTransitions(), this.options.isParameterTotalRate);
        }
        throw new RuntimeException("Not yet implemented");
    }

    class Beta
    extends WrtMG94ModelParameter {
        Beta(int n, boolean bl) {
            super(n, bl);
        }

        @Override
        public double getRate(int n) {
            double d = MG94HKYCodonModel.this.getKappa();
            switch (n) {
                case 0: {
                    return 0.0;
                }
                case 1: {
                    return 0.0;
                }
                case 2: {
                    return 0.0;
                }
                case 3: {
                    return d * this.perEventRateScalar;
                }
                case 4: {
                    return 1.0 * this.perEventRateScalar;
                }
            }
            throw new IllegalArgumentException("Invalid switch case");
        }
    }

    class Alpha
    extends WrtMG94ModelParameter {
        Alpha(int n, boolean bl) {
            super(n, bl);
        }

        @Override
        public double getRate(int n) {
            double d = MG94HKYCodonModel.this.getKappa();
            switch (n) {
                case 0: {
                    return 0.0;
                }
                case 1: {
                    return d * this.perEventRateScalar;
                }
                case 2: {
                    return 1.0 * this.perEventRateScalar;
                }
                case 3: {
                    return 0.0;
                }
                case 4: {
                    return 0.0;
                }
            }
            throw new IllegalArgumentException("Invalid switch case");
        }
    }

    abstract class WrtMG94ModelParameter
    implements DifferentialMassProvider.DifferentialWrapper.WrtParameter {
        private final double normalizationDifferential;
        final double perEventRateScalar;

        WrtMG94ModelParameter(int n, boolean bl) {
            if (bl) {
                this.normalizationDifferential = 1.0;
                this.perEventRateScalar = 1.0 / (double)n;
            } else {
                this.normalizationDifferential = 1.0;
                this.perEventRateScalar = 1.0;
            }
        }

        @Override
        public double getNormalizationDifferential() {
            return this.normalizationDifferential;
        }
    }
}

