/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.Model;
import dr.inference.model.ModelListener;
import dr.inference.model.Parameter;
import dr.inference.model.Statistic;
import dr.inference.model.StatisticList;
import dr.inference.model.Variable;
import dr.inference.model.VariableListener;
import dr.inference.parallel.MPISerializable;
import dr.util.Keywordable;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractModel
implements Model,
ModelListener,
VariableListener,
StatisticList,
MPISerializable,
Keywordable {
    private String id = null;
    private final List<String> keywords = new ArrayList<String>();
    boolean isValidState = true;
    protected Model.ListenerHelper listenerHelper = new Model.ListenerHelper();
    private final ArrayList<Model> models = new ArrayList();
    private final ArrayList<Variable> variables = new ArrayList();
    private final ArrayList<Statistic> statistics = new ArrayList();
    private final String name;

    public AbstractModel(String string) {
        this.name = string;
    }

    public void addModel(Model model) {
        Model.CONNECTED_MODEL_SET.add(model);
        if (!this.models.contains(model)) {
            this.models.add(model);
            model.addModelListener(this);
        }
    }

    public void removeModel(Model model) {
        this.models.remove(model);
        model.removeModelListener(this);
    }

    @Override
    public int getModelCount() {
        return this.models.size();
    }

    @Override
    public final Model getModel(int n) {
        return this.models.get(n);
    }

    public final void addVariable(Variable variable) {
        if (variable instanceof Parameter) {
            Parameter.CONNECTED_PARAMETER_SET.add((Parameter)variable);
        }
        if (!this.variables.contains(variable)) {
            this.variables.add(variable);
            variable.addVariableListener(this);
        }
        if (variable instanceof Statistic) {
            this.addStatistic((Statistic)((Object)variable));
        }
    }

    public final void removeVariable(Variable variable) {
        this.variables.remove(variable);
        variable.removeVariableListener(this);
        if (variable instanceof Statistic) {
            this.removeStatistic((Statistic)((Object)variable));
        }
    }

    public final boolean hasVariable(Variable variable) {
        return this.variables.contains(variable);
    }

    @Override
    public void addModelListener(ModelListener modelListener) {
        this.listenerHelper.addModelListener(modelListener);
    }

    @Override
    public void removeModelListener(ModelListener modelListener) {
        this.listenerHelper.removeModelListener(modelListener);
    }

    public void addModelRestoreListener(ModelListener modelListener) {
        this.listenerHelper.addModelRestoreListener(modelListener);
    }

    @Override
    public boolean isUsed() {
        return this.listenerHelper.getListenerCount() > 0;
    }

    public boolean isVariable() {
        return true;
    }

    public void fireModelChanged() {
        this.listenerHelper.fireModelChanged(this, this, -1);
    }

    public void fireModelChanged(Object object) {
        this.listenerHelper.fireModelChanged(this, object, -1);
    }

    public void fireModelChanged(Object object, int n) {
        this.listenerHelper.fireModelChanged(this, object, n);
    }

    @Override
    public final int getVariableCount() {
        return this.variables.size();
    }

    @Override
    public final Variable getVariable(int n) {
        return this.variables.get(n);
    }

    @Override
    public void sendState(int n) {
        for (Model identifiable : this.models) {
            ((AbstractModel)identifiable).sendState(n);
        }
        for (Variable variable : this.variables) {
            if (!(variable instanceof Parameter.Abstract)) continue;
            ((Parameter.Abstract)variable).sendState(n);
        }
    }

    public void sendStateNoParameters(int n) {
        for (Model model : this.models) {
            ((AbstractModel)model).sendState(n);
        }
    }

    public void receiveStateNoParameters(int n) {
        for (Model model : this.models) {
            ((AbstractModel)model).receiveState(n);
        }
    }

    @Override
    public void receiveState(int n) {
        for (Model identifiable : this.models) {
            ((AbstractModel)identifiable).receiveState(n);
        }
        for (Variable variable : this.variables) {
            if (!(variable instanceof Parameter.Abstract)) continue;
            ((Parameter.Abstract)variable).receiveState(n);
        }
    }

    @Override
    public final void modelChangedEvent(Model model, Object object, int n) {
        this.handleModelChangedEvent(model, object, n);
    }

    @Override
    public void modelRestored(Model model) {
    }

    protected abstract void handleModelChangedEvent(Model var1, Object var2, int var3);

    @Override
    public final void variableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.handleVariableChangedEvent(variable, n, changeType);
        this.listenerHelper.fireModelChanged(this, variable, n);
    }

    protected abstract void handleVariableChangedEvent(Variable var1, int var2, Variable.ChangeType var3);

    @Override
    public final void storeModelState() {
        if (this.isValidState) {
            for (Model identifiable : this.models) {
                identifiable.storeModelState();
            }
            for (Variable variable : this.variables) {
                variable.storeVariableValues();
            }
            this.storeState();
            this.isValidState = false;
        }
    }

    @Override
    public final void restoreModelState() {
        if (!this.isValidState) {
            for (Variable identifiable : this.variables) {
                identifiable.restoreVariableValues();
            }
            for (Model model : this.models) {
                model.restoreModelState();
            }
            this.restoreState();
            this.isValidState = true;
            this.listenerHelper.fireModelRestored(this);
        }
    }

    @Override
    public final void acceptModelState() {
        if (!this.isValidState) {
            for (Variable identifiable : this.variables) {
                identifiable.acceptVariableValues();
            }
            for (Model model : this.models) {
                model.acceptModelState();
            }
            this.acceptState();
            this.isValidState = true;
        }
    }

    @Override
    public boolean isValidState() {
        return this.isValidState;
    }

    @Override
    public final String getModelName() {
        return this.name;
    }

    protected abstract void storeState();

    protected abstract void restoreState();

    protected abstract void acceptState();

    public final void addStatistic(Statistic statistic) {
        if (!this.statistics.contains(statistic)) {
            this.statistics.add(statistic);
        }
    }

    public final void removeStatistic(Statistic statistic) {
        this.statistics.remove(statistic);
    }

    @Override
    public int getStatisticCount() {
        return this.statistics.size();
    }

    @Override
    public Statistic getStatistic(int n) {
        return this.statistics.get(n);
    }

    @Override
    public final Statistic getStatistic(String string) {
        for (int i = 0; i < this.getStatisticCount(); ++i) {
            Statistic statistic = this.getStatistic(i);
            if (!string.equals(statistic.getStatisticName())) continue;
            return statistic;
        }
        return null;
    }

    @Override
    public void setId(String string) {
        this.id = string;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String toString() {
        if (this.id != null) {
            return this.id;
        }
        if (this.name != null) {
            return this.name;
        }
        return super.toString();
    }

    @Override
    public void addKeyword(String string) {
        this.keywords.add(string);
    }

    @Override
    public List<String> getKeywords() {
        return this.keywords;
    }

    public Element createElement(Document document) {
        throw new RuntimeException("Not implemented!");
    }
}

