/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.menu;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.rosuda.JGR.RController;
import org.rosuda.JGR.layout.AnchorConstraint;
import org.rosuda.JGR.layout.AnchorLayout;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.REngine.REXPLogical;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.toolkit.DJList;
import org.rosuda.deducer.toolkit.HelpButton;
import org.rosuda.deducer.toolkit.IconButton;
import org.rosuda.deducer.toolkit.OkayCancelPanel;

public class FactorDialog
extends JDialog
implements ActionListener {
    private JPanel listPanel;
    private JScrollPane levelScroller;
    private DJList levelList;
    private JCheckBox ordered;
    private OkayCancelPanel okcan;
    private JButton contrast;
    private IconButton add;
    private IconButton remove;
    private IconButton down;
    private IconButton up;
    private JButton help;
    private ContrastDialog cntr;
    private String variable;

    public FactorDialog(JFrame jFrame, String string) {
        super(jFrame);
        this.variable = string;
        this.initGUI();
    }

    private void initGUI() {
        try {
            AnchorLayout anchorLayout = new AnchorLayout();
            this.getContentPane().setLayout((LayoutManager)anchorLayout);
            this.setPreferredSize(new Dimension(280, 331));
            this.setTitle("Edit Factor");
            this.okcan = new OkayCancelPanel(false, false, this);
            this.getContentPane().add((Component)this.okcan, new AnchorConstraint(810, 937, 946, 300, 1, 1, 1, 1));
            this.help = new HelpButton("pmwiki.php?n=Main.EditFactor");
            this.getContentPane().add((Component)this.help, new AnchorConstraint(810, 937, 930, 40, 0, 0, 1, 1));
            this.help.setPreferredSize(new Dimension(36, 36));
            this.ordered = new JCheckBox();
            this.getContentPane().add((Component)this.ordered, new AnchorConstraint(690, 769, 752, 123, 1, 0, 0, 2));
            this.ordered.setText("Ordered");
            this.ordered.setPreferredSize(new Dimension(92, 19));
            this.ordered.addActionListener(this);
            Object object = Deducer.timedEval("is.ordered(" + this.variable + ")");
            this.ordered.setSelected(object.isLogical() && ((REXPLogical)object).isTRUE()[0]);
            this.contrast = new JButton();
            this.getContentPane().add((Component)this.contrast, new AnchorConstraint(674, 373, 771, 12, 1, 0, 0, 2));
            this.contrast.setText("Contrasts");
            this.contrast.setPreferredSize(new Dimension(92, 30));
            this.contrast.addActionListener(this);
            this.add = new IconButton("/icons/edit_add_32.png", "Add", this, "Add");
            this.getContentPane().add((Component)this.add, new AnchorConstraint(110, 937, 412, 769, 2, 0, 0, 1));
            this.add.setPreferredSize(new Dimension(40, 41));
            this.add.setContentAreaFilled(false);
            this.remove = new IconButton("/icons/edit_remove_32.png", "Delete", this, "Delete");
            this.getContentPane().add((Component)this.remove, new AnchorConstraint(152, 937, 655, 769, 2, 0, 0, 1));
            this.remove.setPreferredSize(new Dimension(40, 41));
            this.remove.setContentAreaFilled(false);
            this.down = new IconButton("/icons/1downarrow_32.png", "Down", this, "Down");
            this.getContentPane().add((Component)this.down, new AnchorConstraint(70, 937, 412, 769, 2, 0, 0, 1));
            this.down.setPreferredSize(new Dimension(40, 35));
            this.down.setContentAreaFilled(false);
            this.up = new IconButton("/icons/1uparrow_32.png", "Up", this, "Up");
            this.getContentPane().add((Component)this.up, new AnchorConstraint(35, 937, 260, 769, 2, 0, 0, 1));
            this.up.setPreferredSize(new Dimension(40, 35));
            this.up.setContentAreaFilled(false);
            this.listPanel = new JPanel();
            this.getContentPane().add((Component)this.listPanel, new AnchorConstraint(40, 748, 655, 12, 1, 1, 1, 2));
            object = new BorderLayout();
            this.listPanel.setLayout((LayoutManager)object);
            this.listPanel.setBorder(BorderFactory.createTitledBorder("Levels"));
            this.listPanel.setPreferredSize(new Dimension(197, 190));
            this.levelScroller = new JScrollPane();
            this.listPanel.add((Component)this.levelScroller, "Center");
            DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
            String[] stringArray = Deducer.timedEval("levels(" + this.variable + ")").asStrings();
            for (int i = 0; i < stringArray.length; ++i) {
                defaultListModel.addElement(stringArray[i]);
            }
            this.levelList = new DJList();
            this.levelScroller.setViewportView(this.levelList);
            this.levelList.setModel(defaultListModel);
            this.levelList.setFixedCellHeight(20);
            this.setMinimumSize(new Dimension(280, 331));
            this.setSize(280, 325);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "Up") {
            int[] nArray = this.levelList.getSelectedIndices();
            if (nArray.length > 1) {
                this.levelList.setSelectedIndex(nArray[0]);
            } else if (nArray.length == 1 && nArray[0] > 0) {
                DefaultListModel defaultListModel = (DefaultListModel)this.levelList.getModel();
                Object e = defaultListModel.remove(nArray[0]);
                defaultListModel.add(nArray[0] - 1, e);
                this.levelList.setSelectedIndex(nArray[0] - 1);
            }
        } else if (string == "Down") {
            int[] nArray = this.levelList.getSelectedIndices();
            if (nArray.length > 1) {
                this.levelList.setSelectedIndex(nArray[0]);
            } else if (nArray.length == 1 && nArray[0] < this.levelList.getModel().getSize() - 1) {
                DefaultListModel defaultListModel = (DefaultListModel)this.levelList.getModel();
                Object e = defaultListModel.remove(nArray[0]);
                defaultListModel.add(nArray[0] + 1, e);
                this.levelList.setSelectedIndex(nArray[0] + 1);
            }
        } else if (string == "Add") {
            String string2 = JOptionPane.showInputDialog(this, "Please Enter the new factor Level", "New Factor Level", 1);
            if (string2 != null) {
                if (string2.length() > 0) {
                    ((DefaultListModel)this.levelList.getModel()).add(0, string2);
                } else {
                    int n = JOptionPane.showConfirmDialog(this, "Add an empty character vector to the factor levels?");
                    if (n == 0) {
                        ((DefaultListModel)this.levelList.getModel()).add(0, string2);
                    }
                }
            }
        } else if (string == "Delete") {
            int[] nArray = this.levelList.getSelectedIndices();
            if (nArray.length > 0) {
                DefaultListModel defaultListModel = (DefaultListModel)this.levelList.getModel();
                for (int i = nArray.length - 1; i >= 0; --i) {
                    defaultListModel.remove(nArray[i]);
                }
            }
        } else if (string == "Cancel") {
            this.dispose();
        } else if (string == "OK") {
            ArrayList arrayList = new ArrayList();
            DefaultListModel defaultListModel = (DefaultListModel)this.levelList.getModel();
            for (int i = 0; i < defaultListModel.getSize(); ++i) {
                arrayList.add(defaultListModel.get(i));
            }
            String string3 = RController.makeRStringVector(arrayList);
            String string4 = this.ordered.isSelected() ? "TRUE" : "FALSE";
            String string5 = this.variable + "<-factor(" + this.variable + ",levels=" + string3 + ",ordered=" + string4 + ")";
            if (this.cntr != null) {
                string5 = string5 + "\n" + this.cntr.getCall(this.variable);
            }
            Deducer.execute(string5);
            this.dispose();
        } else if (string == "Contrasts") {
            this.cntr = new ContrastDialog(null);
            this.cntr.setLocation(this.contrast.getLocationOnScreen());
            this.cntr.setTitle("Set Contrast Codes");
            this.cntr.setVisible(true);
        }
    }

    public class ContrastDialog
    extends JDialog
    implements ActionListener {
        private ButtonGroup buttonGroup1;
        private JPanel groupPanel;
        private JCheckBox helmert;
        private OkayCancelPanel okcan;
        private JCheckBox custom;
        private JCheckBox polynomial;
        private JCheckBox sum;
        private JCheckBox treatment;
        private String contrast;

        public ContrastDialog(JFrame jFrame) {
            super((Frame)jFrame, true);
            this.contrast = null;
            this.initGUI();
        }

        private void initGUI() {
            try {
                AnchorLayout anchorLayout = new AnchorLayout();
                this.getContentPane().setLayout((LayoutManager)anchorLayout);
                this.okcan = new OkayCancelPanel(false, false, this);
                this.getContentPane().add((Component)this.okcan, new AnchorConstraint(833, 944, 957, 59, 1, 1, 1, 1));
                this.groupPanel = new JPanel();
                AnchorLayout anchorLayout2 = new AnchorLayout();
                this.getContentPane().add((Component)this.groupPanel, new AnchorConstraint(50, 944, 785, 59, 1, 1, 1, 1));
                this.groupPanel.setPreferredSize(new Dimension(185, 183));
                this.groupPanel.setLayout((LayoutManager)anchorLayout2);
                this.groupPanel.setBorder(BorderFactory.createTitledBorder("Contrast Type"));
                this.custom = new JCheckBox();
                this.groupPanel.add((Component)this.custom, new AnchorConstraint(751, 916, 849, 218, 1, 1, 1, 1));
                this.custom.setText("Custom");
                this.custom.setPreferredSize(new Dimension(129, 18));
                this.polynomial = new JCheckBox();
                this.groupPanel.add((Component)this.polynomial, new AnchorConstraint(614, 916, 713, 218, 1, 1, 1, 1));
                this.polynomial.setText("Polynomial");
                this.polynomial.setPreferredSize(new Dimension(129, 18));
                this.helmert = new JCheckBox();
                this.groupPanel.add((Component)this.helmert, new AnchorConstraint(483, 916, 576, 218, 1, 1, 1, 1));
                this.helmert.setText("Helment");
                this.helmert.setPreferredSize(new Dimension(129, 17));
                this.sum = new JCheckBox();
                this.groupPanel.add((Component)this.sum, new AnchorConstraint(346, 916, 445, 218, 1, 1, 1, 1));
                this.sum.setText("Sum (Deviation)");
                this.sum.setPreferredSize(new Dimension(129, 18));
                this.treatment = new JCheckBox();
                this.groupPanel.add((Component)this.treatment, new AnchorConstraint(210, 916, 308, 218, 1, 1, 1, 1));
                this.treatment.setText("Treatment");
                this.treatment.setPreferredSize(new Dimension(129, 18));
                this.buttonGroup1 = new ButtonGroup();
                this.buttonGroup1.add(this.treatment);
                this.buttonGroup1.add(this.helmert);
                this.buttonGroup1.add(this.sum);
                this.buttonGroup1.add(this.polynomial);
                this.buttonGroup1.add(this.custom);
                this.treatment.addActionListener(this);
                this.helmert.addActionListener(this);
                this.sum.addActionListener(this);
                this.polynomial.addActionListener(this);
                this.custom.addActionListener(this);
                this.custom.setVisible(false);
                this.setSize(217, 283);
            }
            catch (Exception exception) {
                new ErrorMsg(exception);
            }
        }

        private ButtonGroup getButtonGroup1() {
            if (this.buttonGroup1 == null) {
                this.buttonGroup1 = new ButtonGroup();
            }
            return this.buttonGroup1;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string == "Treatment") {
                this.contrast = "\"contr.treatment\"";
            } else if (string == "Sum (Deviation)") {
                this.contrast = "\"contr.sum\"";
            } else if (string == "Helmert") {
                this.contrast = "\"contr.helmert\"";
            } else if (string == "Polynomial") {
                this.contrast = "\"contr.poly\"";
            } else if (string == "custom") {
                this.contrast = "Error: undefined contrast";
            } else if (string == "Cancel") {
                this.contrast = null;
                this.dispose();
            } else if (string == "OK") {
                this.dispose();
            }
        }

        public String getCall(String string) {
            if (this.contrast != null) {
                return "contrasts(" + string + ") <-" + this.contrast;
            }
            return "";
        }
    }
}

