/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.seeding;

import java.util.Iterator;
import uk.ac.rhul.cs.cl1.MutableNodeSet;
import uk.ac.rhul.cs.cl1.seeding.SeedGenerator;
import uk.ac.rhul.cs.cl1.seeding.SeedIterator;
import uk.ac.rhul.cs.graph.Edge;
import uk.ac.rhul.cs.graph.Graph;

public class EveryEdgeSeedGenerator
extends SeedGenerator {
    public EveryEdgeSeedGenerator() {
    }

    public EveryEdgeSeedGenerator(Graph graph) {
        super(graph);
    }

    public SeedIterator iterator() {
        return new IteratorImpl();
    }

    public int size() {
        return this.graph.getEdgeCount();
    }

    protected class IteratorImpl
    extends SeedIterator {
        Iterator<Edge> edgeIt;
        private double totalSteps;
        private int steps;

        IteratorImpl() {
            this.edgeIt = EveryEdgeSeedGenerator.this.graph.iterator();
            this.steps = 0;
            this.totalSteps = EveryEdgeSeedGenerator.this.graph.getEdgeCount();
        }

        public double getPercentCompleted() {
            return 100.0 * (double)this.steps / this.totalSteps;
        }

        public boolean hasNext() {
            return this.edgeIt.hasNext();
        }

        public MutableNodeSet next() {
            MutableNodeSet result = new MutableNodeSet(EveryEdgeSeedGenerator.this.graph);
            Edge edge = this.edgeIt.next();
            result.add(edge.source);
            result.add(edge.target);
            ++this.steps;
            return result;
        }
    }
}

