/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.ui.cytoscape;

import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.view.cytopanels.CytoPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import uk.ac.rhul.cs.cl1.ClusterONE;
import uk.ac.rhul.cs.cl1.ClusterONEAlgorithmParameters;
import uk.ac.rhul.cs.cl1.ui.ClusterONEAlgorithmParametersPanel;
import uk.ac.rhul.cs.cl1.ui.CollapsiblePanel;
import uk.ac.rhul.cs.cl1.ui.cytoscape.CloseControlPanelAction;
import uk.ac.rhul.cs.cl1.ui.cytoscape.HelpAction;
import uk.ac.rhul.cs.cl1.ui.cytoscape.SelectionPropertiesPanel;
import uk.ac.rhul.cs.cl1.ui.cytoscape.StartAction;

public class ControlPanel
extends JPanel
implements PropertyChangeListener {
    protected ClusterONEAlgorithmParametersPanel algorithmParametersPanel;
    protected SelectionPropertiesPanel selectionInfoPanel;
    protected JComboBox weightAttributeCombo;
    protected JButton weightAttributeRefreshButton;

    public ControlPanel() {
        this.setLayout(new BoxLayout(this, 3));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel algorithmParametersPanel = this.constructAlgorithmParametersPanel();
        Dimension d = algorithmParametersPanel.getPreferredSize();
        d.width = Integer.MAX_VALUE;
        algorithmParametersPanel.setMaximumSize(d);
        this.add(algorithmParametersPanel);
        this.add(this.constructSelectionInfoPanel());
        this.add(this.constructButtonPanel());
        this.add(Box.createVerticalGlue());
    }

    protected JPanel constructAlgorithmParametersPanel() {
        this.algorithmParametersPanel = new ClusterONEAlgorithmParametersPanel();
        JPanel weightPanel = new JPanel();
        weightPanel.setLayout(new FlowLayout(0, 0, 0));
        this.weightAttributeCombo = new JComboBox();
        this.updateWeightAttributeCombo();
        this.weightAttributeRefreshButton = new JButton(new ImageIcon(this.getClass().getResource("../../resources/refresh.png")));
        this.weightAttributeRefreshButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ControlPanel.this.updateWeightAttributeCombo();
            }
        });
        if (ClusterONE.isRunningOnMac()) {
            this.weightAttributeRefreshButton.putClientProperty("JButton.buttonType", "square");
        }
        weightPanel.add(this.weightAttributeCombo);
        weightPanel.add(Box.createHorizontalStrut(3));
        weightPanel.add(this.weightAttributeRefreshButton);
        this.algorithmParametersPanel.addComponent(ClusterONEAlgorithmParametersPanel.Section.BASIC, "Edge weights:", weightPanel);
        try {
            this.algorithmParametersPanel.monitorComponent(this.weightAttributeCombo);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.algorithmParametersPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.algorithmParametersPanel.addPropertyChangeListener("parameters", this);
        return this.algorithmParametersPanel;
    }

    protected JPanel constructSelectionInfoPanel() {
        this.selectionInfoPanel = new SelectionPropertiesPanel(this);
        return new CollapsiblePanel(this.selectionInfoPanel, "Selection info");
    }

    protected JPanel constructButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        JButton startButton = new JButton("Start");
        startButton.addActionListener((ActionListener)((Object)new StartAction()));
        buttonPanel.add(startButton);
        JButton closeButton = new JButton("Close panel");
        closeButton.addActionListener(new CloseControlPanelAction());
        buttonPanel.add(closeButton);
        JButton helpButton = new JButton((Action)((Object)new HelpAction("control-panel")));
        if (ClusterONE.isRunningOnMac()) {
            helpButton.putClientProperty("JButton.buttonType", "help");
            helpButton.setText("");
        }
        buttonPanel.add(helpButton);
        return buttonPanel;
    }

    ClusterONEAlgorithmParameters getParameters() {
        return this.algorithmParametersPanel.getParameters();
    }

    public static ControlPanel getShownInstance() {
        CytoPanel panel = Cytoscape.getDesktop().getCytoPanel(7);
        for (int i = 0; i < panel.getCytoPanelComponentCount(); ++i) {
            Component c = panel.getComponentAt(i);
            if (!(c instanceof ControlPanel)) continue;
            return (ControlPanel)c;
        }
        return null;
    }

    public String getWeightAttributeName() {
        if (this.weightAttributeCombo.getSelectedIndex() == 0) {
            return null;
        }
        if (this.weightAttributeCombo.getSelectedItem() == null) {
            return null;
        }
        return this.weightAttributeCombo.getSelectedItem().toString();
    }

    public void updateWeightAttributeCombo() {
        Object currentItem = this.weightAttributeCombo.getSelectedItem();
        this.weightAttributeCombo.removeAllItems();
        this.weightAttributeCombo.addItem("[unweighted]");
        CyAttributes attributes = Cytoscape.getEdgeAttributes();
        ArrayList<String> names = new ArrayList<String>();
        for (String attributeName : attributes.getAttributeNames()) {
            byte type;
            if (!attributes.getUserVisible(attributeName) || (type = attributes.getType(attributeName)) != 2 && type != 3) continue;
            names.add(attributeName);
        }
        Collections.sort(names);
        for (String name : names) {
            this.weightAttributeCombo.addItem(name);
        }
        if (currentItem != null) {
            this.weightAttributeCombo.setSelectedItem(currentItem);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.algorithmParametersPanel) {
            this.selectionInfoPanel.setQualityFunction(this.getParameters().getQualityFunction());
            this.selectionInfoPanel.updateNodeSetFromSelection();
        }
    }
}

