/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.linearfilters;

import ec.tstoolkit.maths.Complex;
import ec.tstoolkit.maths.Simplifying;
import ec.tstoolkit.maths.linearfilters.AbstractFiniteFilter;
import ec.tstoolkit.maths.linearfilters.ForeFilter;
import ec.tstoolkit.maths.polynomials.IRootsSolver;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.maths.polynomials.UnitRootSelector;
import ec.tstoolkit.maths.polynomials.UnitRoots;
import ec.tstoolkit.maths.polynomials.UnitRootsSolver;
import ec.tstoolkit.utilities.Arrays2;

public class BackFilter
extends AbstractFiniteFilter {
    public static final BackFilter ZERO = new BackFilter(Polynomial.ZERO);
    public static final BackFilter ONE = new BackFilter(Polynomial.ONE);
    public static final BackFilter D1 = new BackFilter(UnitRoots.D1);
    private final Polynomial m_p;

    public static BackFilter add(double d, BackFilter l) {
        Polynomial p = l.m_p.plus(d);
        return new BackFilter(p);
    }

    public static BackFilter multiply(double d, BackFilter l) {
        Polynomial p = l.m_p.times(d);
        return new BackFilter(p);
    }

    public static BackFilter of(double[] coefficients) {
        if (coefficients.length == 1) {
            if (coefficients[0] == 1.0) {
                return ONE;
            }
            if (coefficients[0] == 0.0) {
                return ZERO;
            }
        }
        return new BackFilter(Polynomial.of(coefficients));
    }

    public BackFilter(Polynomial p) {
        this.m_p = p.adjustDegree();
    }

    public BackFilter divide(BackFilter r) {
        Polynomial.Division div = Polynomial.divide(this.m_p, r.m_p);
        return new BackFilter(div.getQuotient());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BackFilter other = (BackFilter)obj;
        return this.m_p.equals(other.m_p);
    }

    public double get(int idx) {
        return this.m_p.get(idx);
    }

    public double[] getCoefficients() {
        return this.m_p.getCoefficients();
    }

    public Polynomial getPolynomial() {
        return this.m_p;
    }

    public int getDegree() {
        return this.m_p.getDegree();
    }

    @Override
    public int getLength() {
        return this.m_p.getDegree() + 1;
    }

    @Override
    public int getLowerBound() {
        return -this.m_p.getDegree();
    }

    @Override
    public int getUpperBound() {
        return 0;
    }

    @Override
    public double getWeight(int pos) {
        return this.m_p.get(-pos);
    }

    @Override
    public double[] getWeights() {
        double[] w = this.m_p.getCoefficients();
        Arrays2.reverse(w);
        return w;
    }

    public int hashCode() {
        return this.m_p.hashCode();
    }

    public boolean isIdentity() {
        return this.m_p.isIdentity();
    }

    public boolean isNull() {
        return this.m_p.isZero();
    }

    public BackFilter minus(BackFilter r) {
        Polynomial p = this.m_p.minus(r.m_p);
        return new BackFilter(p);
    }

    public BackFilter minus(double d) {
        Polynomial p = this.m_p.minus(d);
        return new BackFilter(p);
    }

    @Override
    public ForeFilter mirror() {
        return new ForeFilter(this.m_p);
    }

    public BackFilter negate() {
        Polynomial p = this.m_p.negate();
        return new BackFilter(p);
    }

    public BackFilter normalize() {
        double r = this.m_p.get(0);
        if (r == 0.0 || r == 1.0) {
            return this;
        }
        return new BackFilter(this.m_p.times(1.0 / r));
    }

    public BackFilter plus(BackFilter r) {
        Polynomial p = this.m_p.plus(r.m_p);
        return new BackFilter(p);
    }

    public BackFilter plus(double d) {
        Polynomial p = this.m_p.plus(d);
        return new BackFilter(p);
    }

    public Complex[] roots() {
        return this.m_p.roots();
    }

    public Complex[] roots(IRootsSolver solver) {
        return this.m_p.roots(solver);
    }

    public BackFilter times(BackFilter r) {
        Polynomial p = this.m_p.times(r.m_p);
        return new BackFilter(p);
    }

    public BackFilter times(double d) {
        Polynomial p = this.m_p.times(d);
        return new BackFilter(p);
    }

    public String toString() {
        return this.m_p.toString('B', true);
    }

    public static class StationaryTransformation {
        public BackFilter unitRoots;
        public BackFilter stationaryFilter;
        private int freq;

        public StationaryTransformation() {
            this.freq = 0;
        }

        public StationaryTransformation(int freq) {
            this.freq = freq;
        }

        public boolean transform(BackFilter f) {
            UnitRootsSolver urs = this.freq == 0 ? new UnitRootsSolver() : new UnitRootsSolver(this.freq);
            urs.factorize(f.m_p);
            this.unitRoots = new BackFilter(urs.getUnitRoots().toPolynomial());
            if (this.unitRoots.getDegree() == 0) {
                this.stationaryFilter = f;
                return false;
            }
            this.stationaryFilter = new BackFilter(urs.remainder());
            return true;
        }
    }

    public static class SimplifyingTool
    extends Simplifying<BackFilter> {
        private final boolean m_sur;

        public SimplifyingTool(boolean simplifyUR) {
            this.m_sur = simplifyUR;
        }

        @Override
        public boolean simplify(BackFilter left, BackFilter right) {
            this.clear();
            if (left.getLength() == 1 || right.getLength() == 1) {
                return false;
            }
            Polynomial lp = left.m_p;
            Polynomial rp = right.m_p;
            double l0 = lp.get(0);
            double r0 = rp.get(0);
            Polynomial.SimplifyingTool psimp = new Polynomial.SimplifyingTool();
            if (psimp.simplify(lp, rp)) {
                lp = (Polynomial)psimp.getLeft();
                rp = (Polynomial)psimp.getRight();
                lp = lp.times(l0 / lp.get(0));
                rp = rp.times(r0 / rp.get(0));
                Polynomial p = (Polynomial)psimp.getCommon();
                p = p.divide(p.get(0));
                if (this.m_sur || p.getDegree() == 0) {
                    this.m_common = new BackFilter(p);
                    this.m_left = new BackFilter(lp);
                    this.m_right = new BackFilter(rp);
                    return true;
                }
                UnitRootSelector ursel = new UnitRootSelector();
                if (ursel.select(p)) {
                    Polynomial pnur = ursel.getOutofSelection();
                    Polynomial pur = ursel.getSelection();
                    pur = pur.divide(pur.get(0));
                    pnur = pnur.divide(pnur.get(0));
                    this.m_common = new BackFilter(pnur);
                    this.m_left = new BackFilter(lp.times(pur));
                    this.m_right = new BackFilter(rp.times(pur));
                    return true;
                }
                this.m_common = new BackFilter(p);
                this.m_left = new BackFilter(lp);
                this.m_right = new BackFilter(rp);
                return true;
            }
            return false;
        }
    }
}

