## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = NA
)

## -----------------------------------------------------------------------------
library(autoReg)
library(dplyr) # for use of pipe operator `%>%`

## -----------------------------------------------------------------------------
data(acs, package="moonBook")
gaze(sex~.,data=acs)

## -----------------------------------------------------------------------------
gaze(sex~.,data=acs) %>% myft()

## -----------------------------------------------------------------------------
gaze(sex~EF,data=acs)  # default: method=1 

## -----------------------------------------------------------------------------
var.test(EF~sex,data=acs)  # F Test to Compare Two Variances

## -----------------------------------------------------------------------------
t.test(EF~sex,data=acs,var.equal=TRUE)

## -----------------------------------------------------------------------------
t.test(EF~sex,data=acs) # default value: var.equal=FALSE

## -----------------------------------------------------------------------------
gaze(sex~EF,data=acs, method=2)  # method=2 forces analysis as continuous non-normal 

## -----------------------------------------------------------------------------
wilcox.test(EF~sex,data=acs)

## -----------------------------------------------------------------------------
gaze(sex~EF,data=acs, method=3) 

## -----------------------------------------------------------------------------
nrow(acs)
out=lm(age~sex,data=acs)
shapiro.test(resid(out))

## -----------------------------------------------------------------------------
gaze(Dx~.,data=acs) %>% myft()

## -----------------------------------------------------------------------------
gaze(Dx~age,data=acs)  # default : method=1

## -----------------------------------------------------------------------------
out=lm(age~Dx,data=acs)
anova(out)

## -----------------------------------------------------------------------------
gaze(Dx~age,data=acs, method=2) %>% myft()

## -----------------------------------------------------------------------------
kruskal.test(age~Dx,data=acs)

## -----------------------------------------------------------------------------
gaze(Dx~age,data=acs, method=3) %>% myft()

## -----------------------------------------------------------------------------
out=lm(age~Dx,data=acs)
shapiro.test(resid(out))

## -----------------------------------------------------------------------------
gaze(sex~Dx,data=acs) # default : catMethod=2

## -----------------------------------------------------------------------------
result=table(acs$Dx,acs$sex)
chisq.test(result)  # default: correct = TRUE

## -----------------------------------------------------------------------------
gaze(sex~Dx,data=acs, catMethod=1) # Perform chisq.test without continuity correction

## -----------------------------------------------------------------------------
result=table(acs$Dx,acs$sex)
chisq.test(result, correct=FALSE)  # without continuity correction

## -----------------------------------------------------------------------------
gaze(sex~Dx,data=acs, catMethod=3) # Perform Fisher's exact test

## -----------------------------------------------------------------------------
result=table(acs$Dx,acs$sex)
fisher.test(result)  

## -----------------------------------------------------------------------------
gaze(sex~Dx,data=acs, catMethod=4) # Perform test for trend in proportions

## -----------------------------------------------------------------------------
result=table(acs$Dx,acs$sex)
result
prop.trend.test(result[,2],rowSums(result)) 

## -----------------------------------------------------------------------------
gaze(sex+Dx~.,data=acs) %>% myft()

## -----------------------------------------------------------------------------
gaze(sex+Dx~.,data=acs,show.total=TRUE) %>% myft()

## -----------------------------------------------------------------------------
gaze(EF~.,data=acs, missing=TRUE) %>% myft()

## -----------------------------------------------------------------------------
gaze(sex~.,data=acs,missing=TRUE) %>% myft()

