/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.data.discretization;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.vikamine.kernel.data.DerivedAttributeBuilder;
import org.vikamine.kernel.data.DerivedNominalAttribute;
import org.vikamine.kernel.data.DerivedNominalValue;
import org.vikamine.kernel.data.NumericAttribute;
import org.vikamine.kernel.data.Value;
import org.vikamine.kernel.formula.FormulaNumber;
import org.vikamine.kernel.formula.constants.FormulaAttributePrimitive;
import org.vikamine.kernel.formula.operators.And;
import org.vikamine.kernel.formula.operators.Greater;
import org.vikamine.kernel.formula.operators.GreaterEquals;

public class DiscretizationAttributeBuilder
extends DerivedAttributeBuilder {
    private final List<Double> cutpoints;
    private final NumericAttribute na;
    private final DecimalFormat formatter = new DecimalFormat("#.#");

    public DiscretizationAttributeBuilder(List<Double> cutpoints, NumericAttribute na) {
        this.cutpoints = cutpoints;
        this.na = na;
    }

    public void buildNominalCustomAttribute(String attributeID) {
        List<Value> values = this.buildValues();
        this.attribute = new DerivedNominalAttribute(attributeID, values);
        for (Value v : values) {
            ((DerivedNominalValue)v).setAttribute(this.attribute);
        }
    }

    private List<Value> buildValues() {
        ArrayList<Value> result = new ArrayList<Value>();
        int i = 0;
        while (i <= this.cutpoints.size()) {
            double minOfInterval = i == 0 ? Double.NEGATIVE_INFINITY : this.cutpoints.get(i - 1);
            double maxOfInterval = i == this.cutpoints.size() ? Double.POSITIVE_INFINITY : this.cutpoints.get(i);
            String description = "[" + this.formatter.format(minOfInterval) + "; " + this.formatter.format(maxOfInterval) + "]";
            DerivedNominalValue value = new DerivedNominalValue(description, description);
            GreaterEquals left = new GreaterEquals();
            left.setArg1(new FormulaAttributePrimitive(this.na));
            left.setArg2(new FormulaNumber(minOfInterval));
            Greater right = new Greater();
            right.setArg1(new FormulaNumber(maxOfInterval));
            right.setArg2(new FormulaAttributePrimitive(this.na));
            And formula = new And(left, right);
            value.setCondition(formula);
            result.add(value);
            ++i;
        }
        return result;
    }
}

