/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.arg.coalescent;

import dr.evolution.tree.NodeRef;
import dr.evomodel.arg.ARGModel;
import dr.evomodel.arg.coalescent.VeryOldCoalescentLikelihood;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.util.HeapSort;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;
import java.util.logging.Logger;

public class ARGCoalescentLikelihood
extends VeryOldCoalescentLikelihood {
    public static final String ARG_COALESCENT_MODEL = "argCoalescentLikelihood";
    public static final String RECOMBINATION_RATE = "recombinationRate";
    public static final String POPULATION_SIZE = "populationSize";
    public static final String ARG_MODEL = "argModel";
    public static final String MAX_REASSORTMENTS = "maxReassortments";
    public static final String ANCESTRAL_RESTRICTION = "ancestralRestriction";
    public static final int RECOMBINATION = 3;
    private Parameter popSize;
    private Parameter recomRate;
    protected ARGModel arg;
    private int taxaNumber;
    protected int maxReassortments;
    private boolean ancestralRestriction = false;
    private ArrayList<CoalescentInterval> intervals;
    private ArrayList<CoalescentInterval> storedIntervals;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule("populationSize", new XMLSyntaxRule[]{new ElementRule(Parameter.class)}), new ElementRule("recombinationRate", new XMLSyntaxRule[]{new ElementRule(Parameter.class)}), new ElementRule("argModel", new XMLSyntaxRule[]{new ElementRule(ARGModel.class)}), AttributeRule.newBooleanRule("ancestralRestriction", true)};

        @Override
        public String getParserDescription() {
            return "A coalescent likelihood for an ARG model";
        }

        @Override
        public Class getReturnType() {
            return ARGCoalescentLikelihood.class;
        }

        @Override
        public String getParserName() {
            return ARGCoalescentLikelihood.ARG_COALESCENT_MODEL;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            XMLObject xMLObject2 = xMLObject.getChild(ARGCoalescentLikelihood.RECOMBINATION_RATE);
            Parameter parameter = (Parameter)xMLObject2.getChild(Parameter.class);
            xMLObject2 = xMLObject.getChild(ARGCoalescentLikelihood.POPULATION_SIZE);
            Parameter parameter2 = (Parameter)xMLObject2.getChild(Parameter.class);
            xMLObject2 = xMLObject.getChild(ARGCoalescentLikelihood.ARG_MODEL);
            ARGModel aRGModel = (ARGModel)xMLObject2.getChild(ARGModel.class);
            int n = Integer.MAX_VALUE;
            if (xMLObject.hasAttribute(ARGCoalescentLikelihood.MAX_REASSORTMENTS)) {
                n = xMLObject.getIntegerAttribute(ARGCoalescentLikelihood.MAX_REASSORTMENTS);
            }
            boolean bl = false;
            if (xMLObject.hasAttribute(ARGCoalescentLikelihood.ANCESTRAL_RESTRICTION)) {
                bl = xMLObject.getBooleanAttribute(ARGCoalescentLikelihood.ANCESTRAL_RESTRICTION);
            }
            return new ARGCoalescentLikelihood(parameter2, parameter, aRGModel, false, n, bl);
        }
    };

    public ARGCoalescentLikelihood(String string, ARGModel aRGModel, int n) {
        super(string);
        this.arg = aRGModel;
        this.intervals = new ArrayList();
        this.taxaNumber = aRGModel.getExternalNodeCount();
        this.maxReassortments = n;
    }

    public ARGCoalescentLikelihood(Parameter parameter, Parameter parameter2, ARGModel aRGModel, boolean bl, int n, boolean bl2) {
        super(ARG_COALESCENT_MODEL);
        this.popSize = parameter;
        this.recomRate = parameter2;
        this.arg = aRGModel;
        this.ancestralRestriction = bl2;
        this.addVariable(parameter);
        this.addVariable(parameter2);
        this.addModel(aRGModel);
        this.intervals = new ArrayList(aRGModel.getNodeCount());
        this.intervalsKnown = false;
        this.likelihoodKnown = false;
        if (bl) {
            this.intervalsKnown = true;
            this.calculateIntervals();
        }
        this.taxaNumber = aRGModel.getExternalNodeCount();
        this.maxReassortments = n;
    }

    public void calculateIntervals() {
        NodeRef nodeRef;
        int n;
        this.intervals.clear();
        this.intervals.ensureCapacity(this.arg.getNodeCount());
        for (n = 0; n < this.arg.getInternalNodeCount(); ++n) {
            nodeRef = this.arg.getInternalNode(n);
            if (this.arg.isReassortment(nodeRef)) {
                this.intervals.add(new CoalescentInterval(this.arg.getNodeHeight(nodeRef), 3));
                continue;
            }
            this.intervals.add(new CoalescentInterval(this.arg.getNodeHeight(nodeRef), 0));
        }
        for (n = 0; n < this.arg.getExternalNodeCount(); ++n) {
            nodeRef = this.arg.getExternalNode(n);
            if (!(this.arg.getNodeHeight(nodeRef) > 0.0)) continue;
            this.intervals.add(new CoalescentInterval(this.arg.getNodeHeight(nodeRef), 1));
        }
        HeapSort.sort(this.intervals);
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.intervals.size(); ++i) {
            d2 = this.intervals.get((int)i).length;
            this.intervals.get((int)i).length -= d;
            d = d2;
        }
        this.intervalsKnown = true;
    }

    @Override
    public void handleModelChangedEvent(Model model, Object object, int n) {
        if (model == this.arg) {
            this.intervalsKnown = false;
        }
        this.likelihoodKnown = false;
    }

    public void handleParameterChangedEvent(Parameter parameter, int n) {
        this.likelihoodKnown = false;
    }

    @Override
    public void storeState() {
        this.storedIntervals = new ArrayList(this.intervals.size());
        for (CoalescentInterval coalescentInterval : this.intervals) {
            this.storedIntervals.add(coalescentInterval.clone());
        }
        this.likelihoodKnown = false;
        this.storedIntervalsKnown = this.intervalsKnown = false;
        this.storedLikelihoodKnown = this.likelihoodKnown;
        this.storedLogLikelihood = this.logLikelihood;
    }

    @Override
    public void restoreState() {
        this.intervals = this.storedIntervals;
        this.storedIntervals.clear();
        this.intervalsKnown = this.storedIntervalsKnown;
        this.likelihoodKnown = this.storedLikelihoodKnown;
        this.logLikelihood = this.storedLogLikelihood;
        this.likelihoodKnown = false;
        this.intervalsKnown = false;
    }

    public boolean currentARGValid(boolean bl) {
        if (!this.intervalsKnown) {
            this.calculateIntervals();
        }
        int n = this.taxaNumber;
        for (CoalescentInterval coalescentInterval : this.intervals) {
            if (n == 1) {
                return false;
            }
            if (coalescentInterval.type == 0) {
                --n;
                continue;
            }
            if (coalescentInterval.type == 3) {
                ++n;
                continue;
            }
            throw new RuntimeException("Not implemented yet");
        }
        if (!bl) {
            int n2 = this.arg.getNodeCount();
            for (int i = 0; i < n2; ++i) {
                NodeRef nodeRef = this.arg.getNode(i);
                if (!this.arg.isReassortment(nodeRef) || this.arg.getParent(nodeRef, 0) != this.arg.getParent(nodeRef, 1)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public double getLogLikelihood() {
        if (this.likelihoodKnown) {
            return this.logLikelihood;
        }
        if (!this.intervalsKnown) {
            this.calculateIntervals();
        }
        this.likelihoodKnown = true;
        this.logLikelihood = this.arg.getReassortmentNodeCount() > this.maxReassortments ? Double.NEGATIVE_INFINITY : (this.ancestralRestriction && !this.arg.isAncestral() ? Double.NEGATIVE_INFINITY : this.calculateLogLikelihood(this.popSize.getParameterValue(0), this.recomRate.getParameterValue(0)));
        return this.logLikelihood;
    }

    private double chooseTwo(int n) {
        return (double)(n * (n - 1)) / 2.0;
    }

    private double calculateLogLikelihood(double d, double d2) {
        double d3 = 0.0;
        int n = this.taxaNumber;
        for (CoalescentInterval coalescentInterval : this.intervals) {
            if (n == 1) {
                return Double.NEGATIVE_INFINITY;
            }
            double d4 = (double)n * ((double)(n - 1) + d2) / (2.0 * d);
            d3 += Math.log(d4) - d4 * coalescentInterval.length;
            if (coalescentInterval.type == 0) {
                d3 += Math.log((double)(n - 1) / ((double)(n - 1) + d2)) - Math.log(this.chooseTwo(n));
                --n;
                continue;
            }
            if (coalescentInterval.type == 3) {
                d3 += Math.log(d2 / ((double)(n - 1) + d2)) - Math.log(n);
                ++n;
                continue;
            }
            throw new RuntimeException("Not implemented yet");
        }
        assert (n == 1);
        return d3;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " " + super.toString();
    }

    private class CoalescentInterval
    implements Comparable<CoalescentInterval>,
    Cloneable {
        public int type;
        public double length;

        public CoalescentInterval(double d, int n) {
            this.length = d;
            this.type = n;
        }

        @Override
        public int compareTo(CoalescentInterval coalescentInterval) {
            if (coalescentInterval.length > this.length) {
                return -1;
            }
            if (coalescentInterval.length == this.length) {
                Logger.getLogger("dr.evomodel.coalescent").severe("The current ARG Model has 2 internal nodes at the same height");
                return 0;
            }
            return 1;
        }

        public String toString() {
            if (this.type == 0) {
                return "(" + this.length + ", Coalescent)";
            }
            return "(" + this.length + ", Recombination)";
        }

        public CoalescentInterval clone() {
            return new CoalescentInterval(this.length, this.type);
        }
    }
}

