/*
 * Decompiled with CFR 0.152.
 */
package dr.math.matrixAlgebra;

import dr.math.matrixAlgebra.IllegalDimension;
import dr.math.matrixAlgebra.Matrix;

public class CholeskyDecomposition {
    private int n;
    private boolean isspd;
    private double[][] L;
    static final double tol = 1.0E-8;

    public boolean isSPD() {
        return this.isspd;
    }

    public double[][] getL() {
        return this.L;
    }

    public CholeskyDecomposition(Matrix matrix) throws IllegalDimension {
        this(matrix.components);
    }

    public CholeskyDecomposition(double[][] dArray) throws IllegalDimension {
        this.n = dArray.length;
        this.L = new double[this.n][this.n];
        boolean bl = this.isspd = dArray[0].length == this.n;
        if (!this.isspd) {
            throw new IllegalDimension("Cholesky decomposition is only defined for square matrices");
        }
        for (int i = 0; i < this.n; ++i) {
            double[] dArray2 = this.L[i];
            double d = 0.0;
            for (int j = 0; j < i; ++j) {
                double[] dArray3 = this.L[j];
                double d2 = 0.0;
                for (int k = 0; k < j; ++k) {
                    d2 += dArray3[k] * dArray2[k];
                }
                dArray2[j] = d2 = (dArray[i][j] - d2) / this.L[j][j];
                d += d2 * d2;
                this.isspd &= Math.abs(dArray[j][i] - dArray[i][j]) < 1.0E-8;
            }
            this.isspd &= (d = dArray[i][i] - d) > 0.0;
            this.L[i][i] = Math.sqrt(Math.max(d, 0.0));
        }
    }

    public static double[][] execute(double[] dArray, int n, int n2) {
        double[][] dArray2 = new double[n2][n2];
        for (int i = 0; i < n2; ++i) {
            double[] dArray3 = dArray2[i];
            double d = 0.0;
            for (int j = 0; j < i; ++j) {
                double[] dArray4 = dArray2[j];
                double d2 = 0.0;
                for (int k = 0; k < j; ++k) {
                    d2 += dArray4[k] * dArray3[k];
                }
                dArray3[j] = d2 = (dArray[n + i * n2 + j] - d2) / dArray2[j][j];
                d += d2 * d2;
            }
            d = dArray[n + i * n2 + i] - d;
            dArray2[i][i] = Math.sqrt(Math.max(d, 0.0));
        }
        return dArray2;
    }

    public double[] getUpperTriangular() {
        double[] dArray = new double[this.n * (this.n + 1) / 2];
        int n = 0;
        for (int i = 0; i < this.n; ++i) {
            for (int j = i; j < this.n; ++j) {
                dArray[n] = this.L[j][i];
                ++n;
            }
        }
        return dArray;
    }

    public double[] getStrictlyUpperTriangular() {
        double[] dArray = new double[this.n * (this.n - 1) / 2];
        int n = 0;
        for (int i = 0; i < this.n - 1; ++i) {
            for (int j = i + 1; j < this.n; ++j) {
                dArray[n] = this.L[j][i];
                ++n;
            }
        }
        return dArray;
    }
}

