/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.trees;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import jebl.evolution.graphs.Node;
import jebl.evolution.taxa.Taxon;
import jebl.evolution.trees.RootedTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CladeSystem {
    private Set<Taxon> taxa = null;
    private final List<Clade> clades = new ArrayList<Clade>();

    public CladeSystem() {
    }

    public CladeSystem(RootedTree tree) {
        this.taxa = new TreeSet<Taxon>(tree.getTaxa());
        this.add(tree);
    }

    public int getCladeCount() {
        return this.clades.size();
    }

    public Set<Taxon> getClade(int index) {
        return this.clades.get(index).getTaxa();
    }

    public String getCladeString(int index) {
        StringBuffer buffer = new StringBuffer("{");
        boolean first = true;
        for (Taxon taxon : this.getClade(index)) {
            if (!first) {
                buffer.append(", ");
            } else {
                first = false;
            }
            buffer.append(taxon.getName());
        }
        buffer.append("}");
        return buffer.toString();
    }

    public double getCladeFrequency(int index) {
        return this.clades.get(index).getFrequency();
    }

    public void add(RootedTree tree) {
        if (this.taxa == null) {
            this.taxa = new TreeSet<Taxon>(tree.getTaxa());
        }
        this.addClades(tree, tree.getRootNode(), new LinkedHashSet<Taxon>());
    }

    private void addClades(RootedTree tree, Node node, Set<Taxon> cladeTaxa) {
        if (tree.isExternal(node)) {
            cladeTaxa.add(tree.getTaxon(node));
        } else {
            LinkedHashSet<Taxon> childCladeTaxa = new LinkedHashSet<Taxon>();
            for (Node child : tree.getChildren(node)) {
                this.addClades(tree, child, childCladeTaxa);
            }
            this.clades.add(new Clade(childCladeTaxa));
            cladeTaxa.addAll(childCladeTaxa);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Clade {
        private double frequency;
        private final Set<Taxon> taxa;

        public Clade(Set<Taxon> taxa) {
            this.taxa = taxa;
            this.frequency = 1.0;
        }

        public double getFrequency() {
            return this.frequency;
        }

        public void setFrequency(double frequency) {
            this.frequency = frequency;
        }

        public Set<Taxon> getTaxa() {
            return this.taxa;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Clade clade = (Clade)o;
            return ((Object)this.taxa).equals(clade.taxa);
        }

        public int hashCode() {
            return ((Object)this.taxa).hashCode();
        }
    }
}

