/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.ui;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;

public class PopupMenuTrigger
extends MouseAdapter {
    private JPopupMenu menu;

    public PopupMenuTrigger(JPopupMenu menu) {
        this.menu = menu;
    }

    public void mousePressed(MouseEvent event) {
        this.maybePopup(event);
    }

    public void mouseReleased(MouseEvent event) {
        this.maybePopup(event);
    }

    protected boolean maybePopup(MouseEvent event) {
        if (!event.isPopupTrigger()) {
            return false;
        }
        Component c = event.getComponent();
        if (c instanceof JTable) {
            Point p = event.getPoint();
            JTable table = (JTable)c;
            int row = table.rowAtPoint(p);
            ListSelectionModel model = table.getSelectionModel();
            if (!model.isSelectedIndex(row)) {
                model.setSelectionInterval(row, row);
            }
        }
        this.menu.show(c, event.getX(), event.getY());
        return true;
    }
}

