## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(jti)
library(igraph)

## -----------------------------------------------------------------------------
el <- matrix(c(
  "A", "T",
  "T", "E",
  "S", "L",
  "S", "B",
  "L", "E",
  "E", "X",
  "E", "D",
  "B", "D"),
  nc = 2,
  byrow = TRUE
)

g <- igraph::graph_from_edgelist(el)
plot(g)

## -----------------------------------------------------------------------------
cl <- cpt_list(asia, g)
cl

## -----------------------------------------------------------------------------
cp <- compile(cl)
cp
# plot(get_graph(cp)) # Should give the same as plot(g)

## -----------------------------------------------------------------------------
jt1 <- jt(cp)
jt1
plot(jt1)

## -----------------------------------------------------------------------------
query_belief(jt1, c("E", "L", "T"))
query_belief(jt1, c("B", "D", "E"), type = "joint")

## ---- eval = FALSE------------------------------------------------------------
#  jt1 <- jt(cp, propagate = "no")
#  jt1 <- propagate(jt1, prop = "full")

## -----------------------------------------------------------------------------
e2  <- c(A = "y", X = "n")
jt2 <- jt(cp, e2) 
query_belief(jt2, c("B", "D", "E"), type = "joint")

## -----------------------------------------------------------------------------
query_evidence(jt2)

## -----------------------------------------------------------------------------
jt3 <- jt(cp, flow = "max")
mpe(jt3)

## -----------------------------------------------------------------------------
e4  <- c(T = "y", X = "y", D = "y")
jt4 <- jt(cp, e4, flow = "max")
mpe(jt4)


## -----------------------------------------------------------------------------
cp5 <- compile(cpt_list(asia, g) , root_node = "X")
jt5 <- jt(cp5, propagate = "collect")

## -----------------------------------------------------------------------------
query_belief(jt5, get_clique_root(jt5), "joint")

## -----------------------------------------------------------------------------
cl  <- cpt_list(asia2)
cp6 <- compile(cl)

## -----------------------------------------------------------------------------
plot(get_graph(cp6)) 

## -----------------------------------------------------------------------------
jt6 <- jt(cp6, propagate = "no")

## -----------------------------------------------------------------------------
plot(jt6)
get_cliques(jt6)
get_clique_root(jt6)
leaves(jt6)
unlist(parents(jt6))

## -----------------------------------------------------------------------------
jt6 <- send_messages(jt6)

## -----------------------------------------------------------------------------
plot(jt6)

## -----------------------------------------------------------------------------
jt6 <- send_messages(jt6)
plot(jt6)

## -----------------------------------------------------------------------------
leaves(jt6)
parents(jt6)

## -----------------------------------------------------------------------------
jt6 <- send_messages(jt6)
jt6 <- send_messages(jt6)

## -----------------------------------------------------------------------------
query_belief(jt6, c("either", "tub"), "joint")

## -----------------------------------------------------------------------------
library(ess)

g7  <- ess::fit_graph(asia, trace = FALSE)
ig7 <- ess::as_igraph(g7)
cp7 <- compile(pot_list(asia, ig7))
jt7 <- jt(cp7)

query_belief(jt7, get_cliques(jt7)[[4]], type = "joint")

