/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.branchratemodel;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.SimpleTree;
import dr.evolution.tree.Tree;
import dr.evomodel.branchratemodel.AbstractBranchRateModel;
import dr.evomodel.tree.TreeModel;
import dr.evomodel.tree.TreeParameterModel;
import dr.inference.distribution.ParametricDistributionModel;
import dr.inference.model.Model;
import dr.inference.model.ModelListener;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;

public class MixtureModelBranchRates
extends AbstractBranchRateModel {
    private final ParametricDistributionModel[] distributionModels;
    final TreeParameterModel rateCategoryQuantiles;
    private Parameter distributionIndexParameter;
    private final double[] rates;
    private boolean useQuantilesForRates = true;
    private boolean normalize = false;
    private double normalizeBranchRateTo = Double.NaN;
    private double scaleFactor = 1.0;
    private TreeModel treeModel;
    private Tree tree;

    public MixtureModelBranchRates(TreeModel treeModel, Parameter parameter, ParametricDistributionModel[] parametricDistributionModelArray, Parameter parameter2) {
        this(treeModel, parameter, parametricDistributionModelArray, parameter2, true, false, Double.NaN);
    }

    public MixtureModelBranchRates(TreeModel treeModel, Parameter parameter, ParametricDistributionModel[] parametricDistributionModelArray, Parameter parameter2, boolean bl, double d) {
        this(treeModel, parameter, parametricDistributionModelArray, parameter2, true, bl, d);
    }

    public MixtureModelBranchRates(TreeModel treeModel, Parameter parameter, ParametricDistributionModel[] parametricDistributionModelArray, Parameter parameter2, boolean bl) {
        this(treeModel, parameter, parametricDistributionModelArray, parameter2, bl, false, Double.NaN);
    }

    public MixtureModelBranchRates(TreeModel treeModel, Parameter parameter, ParametricDistributionModel[] parametricDistributionModelArray, Parameter parameter2, boolean bl, boolean bl2, double d) {
        super("mixtureModelBranchRates");
        this.useQuantilesForRates = bl;
        this.rateCategoryQuantiles = new TreeParameterModel(treeModel, parameter, false);
        this.rates = new double[treeModel.getNodeCount()];
        this.normalize = bl2;
        this.treeModel = treeModel;
        this.distributionModels = parametricDistributionModelArray;
        this.normalizeBranchRateTo = d;
        this.tree = new SimpleTree(treeModel);
        this.distributionIndexParameter = parameter2;
        this.addVariable(this.distributionIndexParameter);
        Parameter.DefaultBounds defaultBounds = new Parameter.DefaultBounds(1.0, 0.0, parameter.getDimension());
        parameter.addBounds(defaultBounds);
        Parameter.DefaultBounds defaultBounds2 = new Parameter.DefaultBounds(parametricDistributionModelArray.length - 1, 0.0, 1);
        parameter2.addBounds(defaultBounds2);
        parameter2.setParameterValue(0, 0.0);
        for (ParametricDistributionModel parametricDistributionModel : this.distributionModels) {
            this.addModel(parametricDistributionModel);
        }
        this.addModel(this.rateCategoryQuantiles);
        if (bl2) {
            treeModel.addModelListener(new ModelListener(){

                @Override
                public void modelChangedEvent(Model model, Object object, int n) {
                    MixtureModelBranchRates.this.computeFactor();
                }

                @Override
                public void modelRestored(Model model) {
                    MixtureModelBranchRates.this.computeFactor();
                }
            });
        }
        this.setupRates();
    }

    private void computeFactor() {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.treeModel.getNodeCount(); ++i) {
            NodeRef nodeRef = this.treeModel.getNode(i);
            if (this.treeModel.isRoot(nodeRef)) continue;
            d2 += this.treeModel.getBranchLength(nodeRef);
        }
        this.scaleFactor = this.normalizeBranchRateTo / (d / d2);
        System.out.println("scaleFactor\t\t\t\t\t" + this.scaleFactor);
    }

    @Override
    public void handleModelChangedEvent(Model model, Object object, int n) {
        for (ParametricDistributionModel parametricDistributionModel : this.distributionModels) {
            if (model != parametricDistributionModel) continue;
            this.setupRates();
            this.fireModelChanged();
        }
        if (model == this.rateCategoryQuantiles) {
            this.setupRates();
            this.fireModelChanged(null, n);
        }
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (variable == this.distributionIndexParameter) {
            this.setupRates();
            this.fireModelChanged();
        }
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
        this.setupRates();
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public double getBranchRate(Tree tree, NodeRef nodeRef) {
        assert (!tree.isRoot(nodeRef)) : "root node doesn't have a rate!";
        return this.rates[nodeRef.getNumber()] * this.scaleFactor;
    }

    protected void setupRates() {
        for (int i = 0; i < this.tree.getNodeCount(); ++i) {
            if (this.tree.isRoot(this.tree.getNode(i))) continue;
            this.rates[this.tree.getNode((int)i).getNumber()] = this.useQuantilesForRates ? this.distributionModels[(int)Math.round((Double)this.distributionIndexParameter.getValue(0))].quantile(this.rateCategoryQuantiles.getNodeValue(this.tree, this.tree.getNode(i))) : this.rateCategoryQuantiles.getNodeValue(this.tree, this.tree.getNode(i));
        }
        if (this.normalize) {
            this.computeFactor();
        }
    }
}

