/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint.impl;

import cern.colt.function.tint.IntIntFunction;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.impl.DelegateIntMatrix1D;
import cern.colt.matrix.tint.impl.DenseIntMatrix1D;
import cern.colt.matrix.tint.impl.DiagonalIntMatrix2D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class WrapperIntMatrix2D
extends IntMatrix2D {
    private static final long serialVersionUID = 1L;
    protected IntMatrix2D content;

    public WrapperIntMatrix2D(IntMatrix2D intMatrix2D) {
        block3: {
            if (intMatrix2D != null) {
                try {
                    this.setUp(intMatrix2D.rows(), intMatrix2D.columns());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if ("matrix too large".equals(illegalArgumentException.getMessage())) break block3;
                    throw illegalArgumentException;
                }
            }
        }
        this.content = intMatrix2D;
    }

    public IntMatrix2D assign(IntMatrix2D intMatrix2D, IntIntFunction intIntFunction) {
        this.checkShape(intMatrix2D);
        if (intMatrix2D instanceof WrapperIntMatrix2D) {
            IntArrayList intArrayList = new IntArrayList();
            IntArrayList intArrayList2 = new IntArrayList();
            IntArrayList intArrayList3 = new IntArrayList();
            intMatrix2D.getNonZeros(intArrayList, intArrayList2, intArrayList3);
            this.assign(intMatrix2D, intIntFunction, intArrayList, intArrayList2);
        } else {
            super.assign(intMatrix2D, intIntFunction);
        }
        return this;
    }

    public IntMatrix2D assign(final int[] nArray) {
        if (this.content instanceof DiagonalIntMatrix2D) {
            int n = ((DiagonalIntMatrix2D)this.content).dlength;
            final int[] nArray2 = ((DiagonalIntMatrix2D)this.content).elements;
            if (nArray.length != n) {
                throw new IllegalArgumentException("Must have same length: length=" + nArray.length + " dlength=" + n);
            }
            int n2 = ConcurrencyUtils.getNumberOfThreads();
            if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                n2 = Math.min(n2, n);
                Future[] futureArray = new Future[n2];
                int n3 = n / n2;
                for (int i = 0; i < n2; ++i) {
                    final int n4 = i * n3;
                    final int n5 = i == n2 - 1 ? n : n4 + n3;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            for (int i = n4; i < n5; ++i) {
                                nArray2[i] = nArray[i];
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                for (int i = 0; i < n; ++i) {
                    nArray2[i] = nArray[i];
                }
            }
            return this;
        }
        return super.assign(nArray);
    }

    public Object elements() {
        return this.content.elements();
    }

    public synchronized int getQuick(int n, int n2) {
        return this.content.getQuick(n, n2);
    }

    public boolean equals(int n) {
        if (this.content instanceof DiagonalIntMatrix2D) {
            int[] nArray = (int[])this.content.elements();
            for (int i = 0; i < nArray.length; ++i) {
                int n2 = nArray[i];
                int n3 = n - n2;
                if (n3 == 0) continue;
                return false;
            }
            return true;
        }
        return super.equals(n);
    }

    public boolean equals(Object object) {
        if (this.content instanceof DiagonalIntMatrix2D && object instanceof DiagonalIntMatrix2D) {
            if (this == object) {
                return true;
            }
            if (this == null || object == null) {
                return false;
            }
            DiagonalIntMatrix2D diagonalIntMatrix2D = (DiagonalIntMatrix2D)this.content;
            DiagonalIntMatrix2D diagonalIntMatrix2D2 = (DiagonalIntMatrix2D)object;
            if (diagonalIntMatrix2D.columns() != diagonalIntMatrix2D2.columns() || diagonalIntMatrix2D.rows() != diagonalIntMatrix2D2.rows() || diagonalIntMatrix2D.diagonalIndex() != diagonalIntMatrix2D2.diagonalIndex() || diagonalIntMatrix2D.diagonalLength() != diagonalIntMatrix2D2.diagonalLength()) {
                return false;
            }
            int[] nArray = diagonalIntMatrix2D.elements();
            int[] nArray2 = diagonalIntMatrix2D2.elements();
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray2[i];
                int n2 = nArray[i];
                int n3 = n - n2;
                if (n3 == 0) continue;
                return false;
            }
            return true;
        }
        return super.equals(object);
    }

    public IntMatrix2D like(int n, int n2) {
        return this.content.like(n, n2);
    }

    public IntMatrix1D like1D(int n) {
        return this.content.like1D(n);
    }

    public synchronized void setQuick(int n, int n2, int n3) {
        this.content.setQuick(n, n2, n3);
    }

    public IntMatrix1D vectorize() {
        final DenseIntMatrix1D denseIntMatrix1D = new DenseIntMatrix1D((int)this.size());
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n2 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.columns : n3 + n2;
                final int n5 = i * n2 * this.rows;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n5;
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < WrapperIntMatrix2D.this.rows; ++j) {
                                denseIntMatrix1D.setQuick(n++, WrapperIntMatrix2D.this.getQuick(j, i));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = 0;
            for (int i = 0; i < this.columns; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    denseIntMatrix1D.setQuick(n6++, this.getQuick(j, i));
                }
            }
        }
        return denseIntMatrix1D;
    }

    public IntMatrix1D viewColumn(int n) {
        return this.viewDice().viewRow(n);
    }

    public IntMatrix2D viewColumnFlip() {
        if (this.columns == 0) {
            return this;
        }
        WrapperIntMatrix2D wrapperIntMatrix2D = new WrapperIntMatrix2D(this){
            private static final long serialVersionUID = 1L;

            public synchronized int getQuick(int n, int n2) {
                return this.content.getQuick(n, this.columns - 1 - n2);
            }

            public synchronized void setQuick(int n, int n2, int n3) {
                this.content.setQuick(n, this.columns - 1 - n2, n3);
            }

            public synchronized int get(int n, int n2) {
                return this.content.get(n, this.columns - 1 - n2);
            }

            public synchronized void set(int n, int n2, int n3) {
                this.content.set(n, this.columns - 1 - n2, n3);
            }
        };
        wrapperIntMatrix2D.isNoView = false;
        return wrapperIntMatrix2D;
    }

    public IntMatrix2D viewDice() {
        WrapperIntMatrix2D wrapperIntMatrix2D = new WrapperIntMatrix2D(this){
            private static final long serialVersionUID = 1L;

            public synchronized int getQuick(int n, int n2) {
                return this.content.getQuick(n2, n);
            }

            public synchronized void setQuick(int n, int n2, int n3) {
                this.content.setQuick(n2, n, n3);
            }

            public synchronized int get(int n, int n2) {
                return this.content.get(n2, n);
            }

            public synchronized void set(int n, int n2, int n3) {
                this.content.set(n2, n, n3);
            }
        };
        wrapperIntMatrix2D.rows = this.columns;
        wrapperIntMatrix2D.columns = this.rows;
        wrapperIntMatrix2D.isNoView = false;
        return wrapperIntMatrix2D;
    }

    public IntMatrix2D viewPart(final int n, final int n2, int n3, int n4) {
        this.checkBox(n, n2, n3, n4);
        WrapperIntMatrix2D wrapperIntMatrix2D = new WrapperIntMatrix2D(this){
            private static final long serialVersionUID = 1L;

            public synchronized int getQuick(int n3, int n22) {
                return this.content.getQuick(n + n3, n2 + n22);
            }

            public synchronized void setQuick(int n4, int n22, int n3) {
                this.content.setQuick(n + n4, n2 + n22, n3);
            }

            public synchronized int get(int n3, int n22) {
                return this.content.get(n + n3, n2 + n22);
            }

            public synchronized void set(int n4, int n22, int n3) {
                this.content.set(n + n4, n2 + n22, n3);
            }
        };
        wrapperIntMatrix2D.rows = n3;
        wrapperIntMatrix2D.columns = n4;
        wrapperIntMatrix2D.isNoView = false;
        return wrapperIntMatrix2D;
    }

    public IntMatrix1D viewRow(int n) {
        this.checkRow(n);
        return new DelegateIntMatrix1D(this, n);
    }

    public IntMatrix2D viewRowFlip() {
        if (this.rows == 0) {
            return this;
        }
        WrapperIntMatrix2D wrapperIntMatrix2D = new WrapperIntMatrix2D(this){
            private static final long serialVersionUID = 1L;

            public synchronized int getQuick(int n, int n2) {
                return this.content.getQuick(this.rows - 1 - n, n2);
            }

            public synchronized void setQuick(int n, int n2, int n3) {
                this.content.setQuick(this.rows - 1 - n, n2, n3);
            }

            public synchronized int get(int n, int n2) {
                return this.content.get(this.rows - 1 - n, n2);
            }

            public synchronized void set(int n, int n2, int n3) {
                this.content.set(this.rows - 1 - n, n2, n3);
            }
        };
        wrapperIntMatrix2D.isNoView = false;
        return wrapperIntMatrix2D;
    }

    public IntMatrix2D viewSelection(int[] nArray, int[] nArray2) {
        int n;
        if (nArray == null) {
            nArray = new int[this.rows];
            n = this.rows;
            while (--n >= 0) {
                nArray[n] = n;
            }
        }
        if (nArray2 == null) {
            nArray2 = new int[this.columns];
            n = this.columns;
            while (--n >= 0) {
                nArray2[n] = n;
            }
        }
        this.checkRowIndexes(nArray);
        this.checkColumnIndexes(nArray2);
        final int[] nArray3 = nArray;
        final int[] nArray4 = nArray2;
        WrapperIntMatrix2D wrapperIntMatrix2D = new WrapperIntMatrix2D(this){
            private static final long serialVersionUID = 1L;

            public synchronized int getQuick(int n, int n2) {
                return this.content.getQuick(nArray3[n], nArray4[n2]);
            }

            public synchronized void setQuick(int n, int n2, int n3) {
                this.content.setQuick(nArray3[n], nArray4[n2], n3);
            }

            public synchronized int get(int n, int n2) {
                return this.content.get(nArray3[n], nArray4[n2]);
            }

            public synchronized void set(int n, int n2, int n3) {
                this.content.set(nArray3[n], nArray4[n2], n3);
            }
        };
        wrapperIntMatrix2D.rows = nArray.length;
        wrapperIntMatrix2D.columns = nArray2.length;
        wrapperIntMatrix2D.isNoView = false;
        return wrapperIntMatrix2D;
    }

    public IntMatrix2D viewStrides(final int n, final int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new IndexOutOfBoundsException("illegal stride");
        }
        WrapperIntMatrix2D wrapperIntMatrix2D = new WrapperIntMatrix2D(this){
            private static final long serialVersionUID = 1L;

            public synchronized int getQuick(int n3, int n22) {
                return this.content.getQuick(n * n3, n2 * n22);
            }

            public synchronized void setQuick(int n4, int n22, int n3) {
                this.content.setQuick(n * n4, n2 * n22, n3);
            }

            public synchronized int get(int n3, int n22) {
                return this.content.get(n * n3, n2 * n22);
            }

            public synchronized void set(int n4, int n22, int n3) {
                this.content.set(n * n4, n2 * n22, n3);
            }
        };
        if (this.rows != 0) {
            wrapperIntMatrix2D.rows = (this.rows - 1) / n + 1;
        }
        if (this.columns != 0) {
            wrapperIntMatrix2D.columns = (this.columns - 1) / n2 + 1;
        }
        wrapperIntMatrix2D.isNoView = false;
        return wrapperIntMatrix2D;
    }

    protected IntMatrix2D getContent() {
        return this.content;
    }

    protected IntMatrix1D like1D(int n, int n2, int n3) {
        throw new InternalError();
    }

    protected IntMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        throw new InternalError();
    }
}

