/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.regression;

import com.hp.hpl.jena.rdf.model.Alt;
import com.hp.hpl.jena.rdf.model.Bag;
import com.hp.hpl.jena.rdf.model.Container;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Seq;
import com.hp.hpl.jena.rdf.model.SeqIndexBoundsException;
import com.hp.hpl.jena.regression.NewRegressionContainerMethods;
import com.hp.hpl.jena.regression.Regression;
import com.hp.hpl.jena.vocabulary.RDF;
import junit.framework.TestSuite;

public class NewRegressionSeqMethods
extends NewRegressionContainerMethods {
    protected Regression.LitTestObj tvObject;
    protected Literal tvLiteral;
    protected Resource tvResource;
    protected Resource tvResObj;
    protected Object tvLitObj;
    protected Bag tvBag;
    protected Alt tvAlt;
    protected Seq tvSeq;
    protected static final String lang = "fr";
    protected static final int num = 10;

    public NewRegressionSeqMethods(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(NewRegressionSeqMethods.class);
    }

    protected Container createContainer() {
        return this.m.createSeq();
    }

    protected Resource getContainerType() {
        return RDF.Seq;
    }

    public void error(String test, int n) {
        NewRegressionSeqMethods.fail((String)(test + " -- " + n));
    }

    public void setUp() {
        super.setUp();
        this.tvObject = new Regression.LitTestObj(12345L);
        this.tvLiteral = this.m.createLiteral("test 12 string 2");
        this.tvResource = this.m.createResource();
        this.tvResObj = this.m.createResource(new Regression.ResTestObjF());
        this.tvLitObj = new Regression.LitTestObj(1234L);
        this.tvBag = this.m.createBag();
        this.tvAlt = this.m.createAlt();
        this.tvSeq = this.m.createSeq();
    }

    public void testSeq7() {
        Seq seq7 = this.m.createSeq();
        String test = "seq7";
        int n = 0;
        n = n / 100 * 100 + 100;
        for (int i = 0; i < 10; ++i) {
            seq7.add(i);
        }
        n = n / 100 * 100 + 100;
        seq7.set(5, true);
        ++n;
        if (!seq7.getBoolean(5)) {
            this.error(test, n);
        }
        ++n;
        if (seq7.getInt(4) != 3) {
            this.error(test, n);
        }
        ++n;
        if (seq7.getInt(6) != 5) {
            this.error(test, n);
        }
        ++n;
        if (seq7.size() != 10) {
            this.error(test, n);
        }
        n = n / 100 * 100 + 100;
        seq7.set(5, 1L);
        ++n;
        if (seq7.getByte(5) != 1) {
            this.error(test, n);
        }
        ++n;
        if (seq7.getInt(4) != 3) {
            this.error(test, n);
        }
        ++n;
        if (seq7.getInt(6) != 5) {
            this.error(test, n);
        }
        ++n;
        if (seq7.size() != 10) {
            this.error(test, n);
        }
        n = n / 100 * 100 + 100;
        seq7.set(5, 2L);
        ++n;
        if (seq7.getShort(5) != 2) {
            this.error(test, n);
        }
        ++n;
        if (seq7.getInt(4) != 3) {
            this.error(test, n);
        }
        ++n;
        if (seq7.getInt(6) != 5) {
            this.error(test, n);
        }
        ++n;
        if (seq7.size() != 10) {
            this.error(test, n);
        }
        n = n / 100 * 100 + 100;
        seq7.set(5, -1L);
        ++n;
        if (seq7.getInt(5) != -1) {
            this.error(test, n);
        }
        ++n;
        if (seq7.getInt(4) != 3) {
            this.error(test, n);
        }
        ++n;
        if (seq7.getInt(6) != 5) {
            this.error(test, n);
        }
        ++n;
        if (seq7.size() != 10) {
            this.error(test, n);
        }
        n = n / 100 * 100 + 100;
        seq7.set(5, -2L);
        ++n;
        if (seq7.getLong(5) != -2L) {
            this.error(test, n);
        }
        ++n;
        if (seq7.getInt(4) != 3) {
            this.error(test, n);
        }
        ++n;
        if (seq7.getInt(6) != 5) {
            this.error(test, n);
        }
        ++n;
        if (seq7.size() != 10) {
            this.error(test, n);
        }
        n = n / 100 * 100 + 100;
        seq7.set(5, '!');
        ++n;
        if (seq7.getChar(5) != '!') {
            this.error(test, n);
        }
        ++n;
        if (seq7.getInt(4) != 3) {
            this.error(test, n);
        }
        ++n;
        if (seq7.getInt(6) != 5) {
            this.error(test, n);
        }
        ++n;
        if (seq7.size() != 10) {
            this.error(test, n);
        }
        n = n / 100 * 100 + 100;
        seq7.set(5, 123.456f);
        ++n;
        if (seq7.getFloat(5) != 123.456f) {
            this.error(test, n);
        }
        ++n;
        if (seq7.getInt(4) != 3) {
            this.error(test, n);
        }
        ++n;
        if (seq7.getInt(6) != 5) {
            this.error(test, n);
        }
        ++n;
        if (seq7.size() != 10) {
            this.error(test, n);
        }
        n = n / 100 * 100 + 100;
        seq7.set(5, -123.456);
        ++n;
        if (seq7.getDouble(5) != -123.456) {
            this.error(test, n);
        }
        ++n;
        if (seq7.getInt(4) != 3) {
            this.error(test, n);
        }
        ++n;
        if (seq7.getInt(6) != 5) {
            this.error(test, n);
        }
        ++n;
        if (seq7.size() != 10) {
            this.error(test, n);
        }
        n = n / 100 * 100 + 100;
        seq7.set(5, "test 12 string");
        ++n;
        if (!seq7.getString(5).equals("test 12 string")) {
            this.error(test, n);
        }
        ++n;
        if (!seq7.getLanguage(5).equals("")) {
            this.error(test, n);
        }
        ++n;
        if (seq7.getInt(4) != 3) {
            this.error(test, n);
        }
        ++n;
        if (seq7.getInt(6) != 5) {
            this.error(test, n);
        }
        ++n;
        if (seq7.size() != 10) {
            this.error(test, n);
        }
        seq7.set(5, "test 12 string", lang);
        ++n;
        if (!seq7.getString(5).equals("test 12 string")) {
            this.error(test, n);
        }
        ++n;
        if (!seq7.getLanguage(5).equals(lang)) {
            this.error(test, n);
        }
        ++n;
        if (seq7.getInt(4) != 3) {
            this.error(test, n);
        }
        ++n;
        if (seq7.getInt(6) != 5) {
            this.error(test, n);
        }
        ++n;
        if (seq7.size() != 10) {
            this.error(test, n);
        }
        n = n / 100 * 100 + 100;
        seq7.set(5, this.tvLiteral);
        ++n;
        if (!((Object)seq7.getLiteral(5)).equals(this.tvLiteral)) {
            this.error(test, n);
        }
        ++n;
        if (seq7.getInt(4) != 3) {
            this.error(test, n);
        }
        ++n;
        if (seq7.getInt(6) != 5) {
            this.error(test, n);
        }
        ++n;
        if (seq7.size() != 10) {
            this.error(test, n);
        }
        n = n / 100 * 100 + 100;
        seq7.set(5, this.tvResource);
        ++n;
        if (!((Object)seq7.getResource(5)).equals(this.tvResource)) {
            this.error(test, n);
        }
        ++n;
        if (seq7.getInt(4) != 3) {
            this.error(test, n);
        }
        ++n;
        if (seq7.getInt(6) != 5) {
            this.error(test, n);
        }
        ++n;
        if (seq7.size() != 10) {
            this.error(test, n);
        }
        n = n / 100 * 100 + 100;
        seq7.set(5, this.tvLitObj);
        ++n;
        if (!seq7.getObject(5, new Regression.LitTestObjF()).equals(this.tvLitObj)) {
            this.error(test, n);
        }
        ++n;
        if (seq7.getInt(4) != 3) {
            this.error(test, n);
        }
        ++n;
        if (seq7.getInt(6) != 5) {
            this.error(test, n);
        }
        ++n;
        if (seq7.size() != 10) {
            this.error(test, n);
        }
        n = n / 100 * 100 + 100;
        seq7.set(5, this.tvResObj);
        ++n;
        if (!((Object)seq7.getResource(5, new Regression.ResTestObjF())).equals(this.tvResObj)) {
            this.error(test, n);
        }
        ++n;
        if (seq7.getInt(4) != 3) {
            this.error(test, n);
        }
        ++n;
        if (seq7.getInt(6) != 5) {
            this.error(test, n);
        }
        ++n;
        if (seq7.size() != 10) {
            this.error(test, n);
        }
    }

    public void testSeq6() {
        String test = "seq6";
        int n = 0;
        Seq seq6 = this.m.createSeq();
        seq6.add(this.m.createResource());
        seq6.add(1, true);
        ++n;
        if (!seq6.getBoolean(1)) {
            this.error(test, n);
        }
        seq6.add(1, 1L);
        ++n;
        if (seq6.getByte(1) != 1) {
            this.error(test, n);
        }
        seq6.add(1, 2L);
        ++n;
        if (seq6.getShort(1) != 2) {
            this.error(test, n);
        }
        seq6.add(1, -1L);
        ++n;
        if (seq6.getInt(1) != -1) {
            this.error(test, n);
        }
        seq6.add(1, -2L);
        ++n;
        if (seq6.getLong(1) != -2L) {
            this.error(test, n);
        }
        seq6.add(1, '!');
        ++n;
        if (seq6.getChar(1) != '!') {
            this.error(test, n);
        }
        seq6.add(1, 123.456f);
        ++n;
        if (seq6.getFloat(1) != 123.456f) {
            this.error(test, n);
        }
        seq6.add(1, -123.456);
        ++n;
        if (seq6.getDouble(1) != -123.456) {
            this.error(test, n);
        }
        seq6.add(1, "test 12 string");
        ++n;
        if (!seq6.getString(1).equals("test 12 string")) {
            this.error(test, n);
        }
        seq6.add(1, "test 12 string", lang);
        ++n;
        if (!seq6.getString(1).equals("test 12 string")) {
            this.error(test, n);
        }
        seq6.add(1, this.tvResource);
        ++n;
        if (!((Object)seq6.getResource(1)).equals(this.tvResource)) {
            this.error(test, n);
        }
        seq6.add(1, this.tvLiteral);
        ++n;
        if (!((Object)seq6.getLiteral(1)).equals(this.tvLiteral)) {
            this.error(test, n);
        }
        seq6.add(1, this.tvLitObj);
        ++n;
        if (!seq6.getObject(1, new Regression.LitTestObjF()).equals(this.tvLitObj)) {
            this.error(test, n);
        }
        n = n / 100 * 100 + 100;
        ++n;
        if (seq6.indexOf(this.tvLitObj) != 1) {
            this.error(test, n);
        }
        ++n;
        if (seq6.indexOf(this.tvLiteral) != 2) {
            this.error(test, n);
        }
        ++n;
        if (seq6.indexOf(this.tvResource) != 3) {
            this.error(test, n);
        }
        ++n;
        if (seq6.indexOf("test 12 string", lang) != 4) {
            this.error(test, n);
        }
        ++n;
        if (seq6.indexOf("test 12 string") != 5) {
            this.error(test, n);
        }
        ++n;
        if (seq6.indexOf(-123.456) != 6) {
            this.error(test, n);
        }
        ++n;
        if (seq6.indexOf(123.456f) != 7) {
            this.error(test, n);
        }
        ++n;
        if (seq6.indexOf('!') != 8) {
            this.error(test, n);
        }
        ++n;
        if (seq6.indexOf(-2L) != 9) {
            this.error(test, n);
        }
        ++n;
        if (seq6.indexOf(-1L) != 10) {
            this.error(test, n);
        }
        ++n;
        if (seq6.indexOf(2L) != 11) {
            this.error(test, n);
        }
        ++n;
        if (seq6.indexOf(1L) != 12) {
            this.error(test, n);
        }
        ++n;
        if (seq6.indexOf(true) != 13) {
            this.error(test, n);
        }
        ++n;
        if (seq6.indexOf(1234543L) != 0) {
            this.error(test, n);
        }
    }

    public void testSeq5() {
        Seq seq5 = this.m.createSeq();
        String test = "seq5";
        int n = 0;
        for (int i = 0; i < 10; ++i) {
            seq5.add(i);
        }
        try {
            seq5.add(0, false);
            this.error(test, ++n);
        }
        catch (SeqIndexBoundsException e) {
            // empty catch block
        }
        seq5.add(11, false);
        if (seq5.size() != 11) {
            this.error(test, n);
        }
        seq5.remove(11);
        try {
            seq5.add(12, false);
            this.error(test, ++n);
        }
        catch (SeqIndexBoundsException e) {
            // empty catch block
        }
        n = n / 100 * 100 + 100;
        int size = seq5.size();
        for (int i = 1; i <= 9; ++i) {
            ++n;
            seq5.add(i, 1000 + i);
            ++n;
            if (seq5.getInt(i) != 1000 + i) {
                this.error(test, n);
            }
            ++n;
            if (seq5.getInt(i + 1) != 0) {
                this.error(test, n);
            }
            ++n;
            if (seq5.size() != size + i) {
                this.error(test, n);
            }
            ++n;
            if (seq5.getInt(size) == 10 - i - 1) continue;
            this.error(test, n);
        }
    }

    public void testSeq4() {
        String test = "temp";
        int n = 58305;
        Seq seq4 = this.m.createSeq();
        n = n / 100 * 100 + 100;
        ++n;
        seq4.add(true);
        ++n;
        if (!seq4.getBoolean(1)) {
            this.error(test, n);
        }
        ++n;
        seq4.add(1L);
        ++n;
        if (seq4.getByte(2) != 1) {
            this.error(test, n);
        }
        ++n;
        seq4.add(2L);
        ++n;
        if (seq4.getShort(3) != 2) {
            this.error(test, n);
        }
        ++n;
        seq4.add(-1L);
        ++n;
        if (seq4.getInt(4) != -1) {
            this.error(test, n);
        }
        ++n;
        seq4.add(-2L);
        ++n;
        if (seq4.getLong(5) != -2L) {
            this.error(test, n);
        }
        ++n;
        seq4.add('!');
        ++n;
        if (seq4.getChar(6) != '!') {
            this.error(test, n);
        }
        ++n;
        seq4.add(123.456f);
        ++n;
        if (seq4.getFloat(7) != 123.456f) {
            this.error(test, n);
        }
        ++n;
        seq4.add(-123.456);
        ++n;
        if (seq4.getDouble(8) != -123.456) {
            this.error(test, n);
        }
        ++n;
        seq4.add("test 12 string");
        ++n;
        if (!seq4.getString(9).equals("test 12 string")) {
            this.error(test, n);
        }
        ++n;
        if (!seq4.getLanguage(9).equals("")) {
            this.error(test, n);
        }
        ++n;
        seq4.add("test 12 string", lang);
        ++n;
        if (!seq4.getString(10).equals("test 12 string")) {
            this.error(test, n);
        }
        ++n;
        if (!seq4.getLanguage(10).equals(lang)) {
            this.error(test, n);
        }
        ++n;
        seq4.add(this.tvLitObj);
        ++n;
        if (!seq4.getObject(11, new Regression.LitTestObjF()).equals(this.tvLitObj)) {
            this.error(test, n);
        }
        ++n;
        seq4.add(this.tvResource);
        ++n;
        if (!((Object)seq4.getResource(12)).equals(this.tvResource)) {
            this.error(test, n);
        }
        ++n;
        seq4.add(this.tvLiteral);
        ++n;
        if (!((Object)seq4.getLiteral(13)).equals(this.tvLiteral)) {
            this.error(test, n);
        }
        ++n;
        seq4.add(this.tvResObj);
        ++n;
        if (!((Object)seq4.getResource(14, new Regression.ResTestObjF())).equals(this.tvResObj)) {
            this.error(test, n);
        }
        ++n;
        seq4.add(this.tvBag);
        ++n;
        if (!seq4.getBag(15).equals(this.tvBag)) {
            this.error(test, n);
        }
        ++n;
        seq4.add(this.tvAlt);
        ++n;
        if (!seq4.getAlt(16).equals(this.tvAlt)) {
            this.error(test, n);
        }
        ++n;
        seq4.add(this.tvSeq);
        ++n;
        if (!seq4.getSeq(17).equals(this.tvSeq)) {
            this.error(test, n);
        }
        ++n;
        try {
            seq4.getInt(18);
            this.error(test, n);
        }
        catch (SeqIndexBoundsException e) {
            // empty catch block
        }
        ++n;
        try {
            seq4.getInt(0);
            this.error(test, n);
        }
        catch (SeqIndexBoundsException e) {
            // empty catch block
        }
    }
}

