/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.NICGAR;

import java.util.ArrayList;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.NICGAR.Chromosome;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.NICGAR.Gene;

public class AssociationRule {
    public ArrayList<Gene> antecedent;
    public ArrayList<Gene> consequent;
    public double antSupport;
    public double consSupport;
    public double support;
    public double confidence;
    public double lift;
    public int nAnts;
    public double sumInterval;
    public double percentInterval;
    public int rank;
    public double conv;
    public double CF;
    public double netConf;
    public double yulesQ;
    public double fitness;

    public double getPercentInterval() {
        return this.percentInterval;
    }

    public void setPercentInterval(double percentInterval) {
        this.percentInterval = percentInterval;
    }

    public double getFitness() {
        return this.fitness;
    }

    public void setFitness(double fitness) {
        this.fitness = fitness;
    }

    public double getYulesQ() {
        return this.yulesQ;
    }

    public double getCF() {
        return this.CF;
    }

    public void setCF(double cf) {
        this.CF = cf;
    }

    public double getConv() {
        return this.conv;
    }

    public void setConv(double conv) {
        this.conv = conv;
    }

    public double getNetConf() {
        return this.netConf;
    }

    public void setNetConf(double netConf) {
        this.netConf = netConf;
    }

    public AssociationRule() {
    }

    public AssociationRule(Chromosome chr) {
        this.antecedent = new ArrayList();
        this.consequent = new ArrayList();
        for (int i = 0; i < chr.genes.length; ++i) {
            Gene gen = chr.getGene(i);
            if (gen.getActAs() == 0) {
                this.antecedent.add(gen.copy());
            }
            if (gen.getActAs() != 1) continue;
            this.consequent.add(gen.copy());
        }
        this.support = chr.getSupport();
        this.consSupport = chr.getConsSupport();
        this.antSupport = chr.getAntsSupport();
        this.confidence = chr.getConfidence();
        this.lift = chr.getLift();
        this.nAnts = chr.getnAnts();
        this.conv = chr.getConv();
        this.CF = chr.getCF();
        this.netConf = chr.getNetConf();
        this.yulesQ = chr.getYulesQ();
        this.percentInterval = chr.getPercentInterval();
        this.fitness = chr.getFitness();
    }

    public AssociationRule copy() {
        int i;
        AssociationRule rule = new AssociationRule();
        rule.antecedent = new ArrayList();
        rule.consequent = new ArrayList();
        for (i = 0; i < this.antecedent.size(); ++i) {
            rule.antecedent.add(this.antecedent.get(i).copy());
        }
        for (i = 0; i < this.consequent.size(); ++i) {
            rule.consequent.add(this.consequent.get(i).copy());
        }
        rule.antSupport = this.antSupport;
        rule.consSupport = this.consSupport;
        rule.support = this.support;
        rule.confidence = this.confidence;
        rule.lift = this.lift;
        rule.CF = this.CF;
        rule.conv = this.conv;
        rule.netConf = this.netConf;
        rule.yulesQ = this.yulesQ;
        rule.nAnts = this.nAnts;
        rule.sumInterval = this.sumInterval;
        rule.percentInterval = this.percentInterval;
        rule.rank = this.rank;
        rule.fitness = this.fitness;
        return rule;
    }

    public ArrayList<Gene> getAntecedents() {
        return this.antecedent;
    }

    public ArrayList<Gene> getConsequents() {
        return this.consequent;
    }

    public double getSupport() {
        return this.support;
    }

    public double getAntSupport() {
        return this.antSupport;
    }

    public double getConsSupport() {
        return this.consSupport;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public double getLift() {
        return this.lift;
    }

    public int getnAnts() {
        return this.nAnts;
    }

    public double getSumInterval() {
        return this.sumInterval;
    }

    public int getRank() {
        return this.rank;
    }

    public boolean isCovered(double[] example) {
        Gene gen;
        int i;
        boolean covered = true;
        for (i = 0; i < this.antecedent.size() && covered; ++i) {
            gen = this.antecedent.get(i);
            if (gen.isCover(gen.getAttr(), example[gen.getAttr()])) continue;
            covered = false;
        }
        for (i = 0; i < this.consequent.size() && covered; ++i) {
            gen = this.consequent.get(i);
            if (gen.isCover(gen.getAttr(), example[gen.getAttr()])) continue;
            covered = false;
        }
        return covered;
    }

    public String toString() {
        return this.antecedent.toString() + "-> " + this.consequent.toString() + ": " + this.antSupport + "; " + this.support + "; " + this.confidence + "; " + this.lift + "; " + this.nAnts + "; " + this.sumInterval + "; " + this.rank;
    }
}

