/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.muc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import opennlp.tools.chunker.Chunker;
import opennlp.tools.formats.muc.FullParseCorefEnhancerStream;
import opennlp.tools.formats.muc.RawCorefSample;
import opennlp.tools.parser.Parse;
import opennlp.tools.postag.POSTagger;
import opennlp.tools.util.FilterObjectStream;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.Span;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShallowParseCorefEnhancerStream
extends FilterObjectStream<RawCorefSample, RawCorefSample> {
    private final POSTagger posTagger;
    private final Chunker chunker;

    public ShallowParseCorefEnhancerStream(POSTagger posTagger, Chunker chunker, ObjectStream<RawCorefSample> samples) {
        super(samples);
        this.posTagger = posTagger;
        this.chunker = chunker;
    }

    @Override
    public RawCorefSample read() throws IOException {
        RawCorefSample sample = (RawCorefSample)this.samples.read();
        if (sample != null) {
            ArrayList<Parse> enhancedParses = new ArrayList<Parse>();
            List<String[]> sentences = sample.getTexts();
            for (String[] sentence : sentences) {
                Span[] chunks;
                Parse p = FullParseCorefEnhancerStream.createIncompleteParse(sentence);
                p.setType("TOP");
                Parse[] parseTokens = p.getChildren();
                String[] tags = this.posTagger.tag(sentence);
                for (int i = 0; i < parseTokens.length; ++i) {
                    p.insert(new Parse(p.getText(), parseTokens[i].getSpan(), tags[i], 1.0, parseTokens[i].getHeadIndex()));
                }
                for (Span chunk : chunks = this.chunker.chunkAsSpans(sentence, tags)) {
                    if (!"NP".equals(chunk.getType())) continue;
                    p.insert(new Parse(p.getText(), new Span(0, 0), chunk.getType(), 1.0, p.getHeadIndex()));
                }
                enhancedParses.add(p);
            }
            sample.setParses(enhancedParses);
            return sample;
        }
        return null;
    }
}

