/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.Vector;
import org.freehep.graphicsio.swf.DefinitionTag;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;
import org.freehep.graphicsio.swf.SWFTag;
import org.freehep.util.io.BitOutputStream;

public class DefineText
extends DefinitionTag {
    protected int character;
    protected Rectangle2D bounds;
    protected AffineTransform matrix;
    protected Vector<Record> text;

    public DefineText(int id, Rectangle2D bounds, AffineTransform matrix, Vector<Record> text) {
        this();
        this.character = id;
        this.bounds = bounds;
        this.matrix = matrix;
        this.text = text;
    }

    public DefineText() {
        super(11, 1);
    }

    protected DefineText(int tagID, int version) {
        super(tagID, version);
    }

    @Override
    public SWFTag read(int tagID, SWFInputStream swf, int len) throws IOException {
        DefineText tag = new DefineText();
        tag.read(tagID, swf, len, false);
        return tag;
    }

    protected void read(int tagID, SWFInputStream swf, int len, boolean hasAlpha) throws IOException {
        Record record;
        this.character = swf.readUnsignedShort();
        swf.getDictionary().put(this.character, this);
        this.bounds = swf.readRect();
        this.matrix = swf.readMatrix();
        int glyphBits = swf.readUnsignedByte();
        int advanceBits = swf.readUnsignedByte();
        this.text = new Vector();
        boolean type1 = swf.readBitFlag();
        Record record2 = record = type1 ? new RecordType1(swf, glyphBits, advanceBits, hasAlpha) : new RecordType0(swf, glyphBits, advanceBits);
        while (!record.isEndRecord()) {
            this.text.add(record);
            type1 = swf.readBitFlag();
            record = type1 ? new RecordType1(swf, glyphBits, advanceBits, hasAlpha) : new RecordType0(swf, glyphBits, advanceBits);
        }
    }

    @Override
    public void write(int tagID, SWFOutputStream swf) throws IOException {
        this.write(swf, false);
    }

    protected void write(SWFOutputStream swf, boolean hasAlpha) throws IOException {
        Record t;
        int i;
        swf.writeUnsignedShort(this.character);
        swf.writeRect(this.bounds);
        swf.writeMatrix(this.matrix);
        int glyphBits = 0;
        int advanceBits = 0;
        for (i = 0; i < this.text.size(); ++i) {
            t = this.text.get(i);
            if (!(t instanceof RecordType0)) continue;
            RecordType0 t0 = (RecordType0)t;
            glyphBits = Math.max(glyphBits, t0.getGlyphBits());
            advanceBits = Math.max(advanceBits, t0.getAdvanceBits());
        }
        swf.writeUnsignedByte(glyphBits);
        swf.writeUnsignedByte(advanceBits);
        for (i = 0; i < this.text.size(); ++i) {
            t = this.text.get(i);
            t.write(swf, glyphBits, advanceBits, hasAlpha);
        }
        swf.writeUnsignedByte(0);
    }

    @Override
    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(super.toString() + "\n");
        s.append("  character:  " + this.character + "\n");
        s.append("  bounds:     " + this.bounds + "\n");
        s.append("  matrix:     " + this.matrix + "\n");
        s.append("  texts:      " + this.text.size() + "\n");
        for (int i = 0; i < this.text.size(); ++i) {
            s.append(this.text.get(i) + "\n");
        }
        return s.toString();
    }

    public static class GlyphEntry {
        private int index;
        private int advance;

        public GlyphEntry(int index, int advance) {
            this.index = index;
            this.advance = advance;
        }

        public GlyphEntry(SWFInputStream input, int glyphBits, int advanceBits) throws IOException {
            this.index = (int)input.readUBits(glyphBits);
            this.advance = (int)input.readSBits(advanceBits);
        }

        public void write(SWFOutputStream swf, int glyphBits, int advanceBits) throws IOException {
            swf.writeUBits(this.index, glyphBits);
            swf.writeSBits(this.advance, advanceBits);
        }

        public int getGlyphBits() {
            return BitOutputStream.minBits((long)this.index, (boolean)false);
        }

        public int getAdvanceBits() {
            return BitOutputStream.minBits((long)this.advance, (boolean)true);
        }

        public String toString() {
            return "GlyphEntry[" + this.index + "," + this.advance + "]";
        }
    }

    public static class RecordType1
    extends Record {
        private int fontID = -1;
        private Color color;
        private int xOffset;
        private int yOffset;
        private int height;
        private Vector<GlyphEntry> glyphs = null;

        public RecordType1(int fontID, Color color, int xOffset, int yOffset, int height) {
            this.fontID = fontID;
            this.color = color;
            this.xOffset = xOffset;
            this.yOffset = yOffset;
            this.height = height;
            this.glyphs = new Vector();
        }

        public void add(GlyphEntry glyph) {
            this.glyphs.add(glyph);
        }

        RecordType1(SWFInputStream input, int glyphBits, int advanceBits, boolean hasAlpha) throws IOException {
            input.readUBits(3);
            boolean hasFont = input.readBitFlag();
            boolean hasColor = input.readBitFlag();
            boolean hasYOffset = input.readBitFlag();
            boolean hasXOffset = input.readBitFlag();
            if (hasFont) {
                this.fontID = input.readUnsignedShort();
            }
            if (hasColor) {
                this.color = input.readColor(hasAlpha);
            }
            if (hasXOffset) {
                this.xOffset = input.readShort();
            }
            if (hasYOffset) {
                this.yOffset = input.readShort();
            }
            if (hasFont) {
                this.height = input.readUnsignedShort();
            }
            this.glyphs = new Vector();
            if (input.getVersion() >= 7) {
                int glyphCount = input.readUnsignedByte();
                for (int i = 0; i < glyphCount; ++i) {
                    this.glyphs.add(new GlyphEntry(input, glyphBits, advanceBits));
                }
            }
        }

        @Override
        public void write(SWFOutputStream swf, int glyphBits, int advanceBits, boolean hasAlpha) throws IOException {
            swf.writeBitFlag(true);
            swf.writeUBits(0L, 3);
            swf.writeBitFlag(this.fontID >= 0);
            swf.writeBitFlag(this.color != null);
            swf.writeBitFlag(this.yOffset != 0);
            swf.writeBitFlag(this.xOffset != 0);
            if (this.fontID >= 0) {
                swf.writeUnsignedShort(this.fontID);
            }
            if (this.color != null) {
                swf.writeColor(this.color, hasAlpha);
            }
            if (this.xOffset != 0) {
                swf.writeShort(this.xOffset);
            }
            if (this.yOffset != 0) {
                swf.writeShort(this.yOffset);
            }
            if (this.fontID >= 0) {
                swf.writeUnsignedShort(this.height);
            }
            if (swf.getVersion() >= 7) {
                swf.writeUnsignedByte(this.glyphs.size());
                for (int i = 0; i < this.glyphs.size(); ++i) {
                    this.glyphs.get(i).write(swf, glyphBits, advanceBits);
                }
            }
        }

        public int getGlyphBits() {
            int glyphBits = 0;
            for (int i = 0; i < this.glyphs.size(); ++i) {
                glyphBits = Math.max(glyphBits, this.glyphs.get(i).getGlyphBits());
            }
            return glyphBits;
        }

        public int getAdvanceBits() {
            int advanceBits = 0;
            for (int i = 0; i < this.glyphs.size(); ++i) {
                advanceBits = Math.max(advanceBits, this.glyphs.get(i).getAdvanceBits());
            }
            return advanceBits;
        }

        @Override
        public boolean isEndRecord() {
            return false;
        }

        public String toString() {
            StringBuffer s = new StringBuffer();
            s.append("    FontID:  " + this.fontID + "\n");
            s.append("    Color:   " + this.color + "\n");
            s.append("    xOffset: " + this.xOffset + "\n");
            s.append("    yOffset: " + this.yOffset + "\n");
            s.append("    height:  " + this.height + "\n");
            s.append("    glyphCount (swf >= 7): " + this.glyphs.size() + "\n");
            s.append("    ");
            for (int i = 0; i < this.glyphs.size(); ++i) {
                s.append(this.glyphs.get(i) + " ");
            }
            s.append("\n");
            return s.toString();
        }
    }

    public static class RecordType0
    extends Record {
        private Vector<GlyphEntry> glyphs = null;

        public RecordType0() {
            this.glyphs = new Vector();
        }

        public void add(GlyphEntry glyph) {
            this.glyphs.add(glyph);
        }

        RecordType0(SWFInputStream swf, int glyphBits, int advanceBits) throws IOException {
            int glyphCount = (int)swf.readUBits(7);
            if (glyphCount == 0) {
                return;
            }
            this.glyphs = new Vector();
            for (int i = 0; i < glyphCount; ++i) {
                GlyphEntry entry = new GlyphEntry(swf, glyphBits, advanceBits);
                this.glyphs.add(entry);
            }
            swf.byteAlign();
        }

        @Override
        public void write(SWFOutputStream swf, int glyphBits, int advanceBits, boolean hasAlpha) throws IOException {
            swf.writeUBits(0L, 1);
            swf.writeUBits(this.glyphs.size(), 7);
            for (int i = 0; i < this.glyphs.size(); ++i) {
                this.glyphs.get(i).write(swf, glyphBits, advanceBits);
            }
            swf.byteAlign();
        }

        @Override
        public boolean isEndRecord() {
            return this.glyphs == null;
        }

        public int getGlyphBits() {
            int glyphBits = 0;
            for (int i = 0; i < this.glyphs.size(); ++i) {
                glyphBits = Math.max(glyphBits, this.glyphs.get(i).getGlyphBits());
            }
            return glyphBits;
        }

        public int getAdvanceBits() {
            int advanceBits = 0;
            for (int i = 0; i < this.glyphs.size(); ++i) {
                advanceBits = Math.max(advanceBits, this.glyphs.get(i).getAdvanceBits());
            }
            return advanceBits;
        }

        public String toString() {
            StringBuffer s = new StringBuffer();
            s.append("    glyphCount: " + this.glyphs.size() + "\n");
            s.append("    ");
            for (int i = 0; i < this.glyphs.size(); ++i) {
                s.append(this.glyphs.get(i) + " ");
            }
            s.append("\n");
            return s.toString();
        }
    }

    public static abstract class Record {
        public abstract void write(SWFOutputStream var1, int var2, int var3, boolean var4) throws IOException;

        public abstract boolean isEndRecord();
    }
}

