/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.Array;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasArrays;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Interval;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.NumberAdapter;
import org.jpmml.model.annotations.Property;

@XmlRootElement(name="ContStats", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions", "intervals", "arrays"})
@JsonRootName(value="ContStats")
@JsonPropertyOrder(value={"totalValuesSum", "totalSquaresSum", "extensions", "intervals", "arrays"})
public class ContStats
extends PMMLObject
implements HasArrays<ContStats>,
HasExtensions<ContStats> {
    @XmlAttribute(name="totalValuesSum")
    @XmlJavaTypeAdapter(value=NumberAdapter.class)
    @JsonProperty(value="totalValuesSum")
    private Number totalValuesSum;
    @XmlAttribute(name="totalSquaresSum")
    @XmlJavaTypeAdapter(value=NumberAdapter.class)
    @JsonProperty(value="totalSquaresSum")
    private Number totalSquaresSum;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    private List<Extension> extensions;
    @XmlElement(name="Interval", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Interval")
    private List<Interval> intervals;
    @XmlElement(name="Array", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Array")
    private List<Array> arrays;
    private static final long serialVersionUID = 67371272L;

    public Number getTotalValuesSum() {
        return this.totalValuesSum;
    }

    public ContStats setTotalValuesSum(@Property(value="totalValuesSum") Number totalValuesSum) {
        this.totalValuesSum = totalValuesSum;
        return this;
    }

    public Number getTotalSquaresSum() {
        return this.totalSquaresSum;
    }

    public ContStats setTotalSquaresSum(@Property(value="totalSquaresSum") Number totalSquaresSum) {
        this.totalSquaresSum = totalSquaresSum;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public ContStats addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasIntervals() {
        return this.intervals != null && !this.intervals.isEmpty();
    }

    public List<Interval> getIntervals() {
        if (this.intervals == null) {
            this.intervals = new ArrayList<Interval>();
        }
        return this.intervals;
    }

    public ContStats addIntervals(Interval ... intervals) {
        this.getIntervals().addAll(Arrays.asList(intervals));
        return this;
    }

    @Override
    public boolean hasArrays() {
        return this.arrays != null && !this.arrays.isEmpty();
    }

    @Override
    public List<Array> getArrays() {
        if (this.arrays == null) {
            this.arrays = new ArrayList<Array>();
        }
        return this.arrays;
    }

    @Override
    public ContStats addArrays(Array ... arrays) {
        this.getArrays().addAll(Arrays.asList(arrays));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE && this.hasIntervals()) {
                status = PMMLObject.traverse(visitor, this.getIntervals());
            }
            if (status == VisitorAction.CONTINUE && this.hasArrays()) {
                status = PMMLObject.traverse(visitor, this.getArrays());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

