/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui.swing;

import com.qarks.util.ui.DialogUtilities;
import com.qarks.util.ui.swing.file_chooser.DefaultFileView;
import com.qarks.util.ui.swing.file_chooser.FileChooserDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileView;

public class FileChooserUtilities {
    private static JFileChooser fileChooser = null;

    public static synchronized JFileChooser getFileChooser() {
        if (fileChooser == null) {
            fileChooser = new JFileChooser();
        }
        return fileChooser;
    }

    public static FileView getDefaultFileView() {
        DefaultFileView defaultFileView = new DefaultFileView();
        return defaultFileView;
    }

    public static JFileChooser getFileChooser(File file) {
        fileChooser = FileChooserUtilities.getFileChooser();
        if (file != null) {
            fileChooser.setCurrentDirectory(file);
        }
        return fileChooser;
    }

    public static void updateUI() {
        if (fileChooser != null) {
            fileChooser.updateUI();
        }
    }

    public static File selectFile(Component component, String string, boolean bl, File file, File file2) {
        File file3 = null;
        File[] fileArray = FileChooserUtilities.selectFiles(component, string, bl, file, file2);
        if (fileArray != null && fileArray.length > 0) {
            file3 = fileArray[0];
        }
        return file3;
    }

    public static File[] selectFiles(Component component, String string, boolean bl, File file, File file2) {
        return FileChooserUtilities.selectFiles(component, string, bl, file, file2, false);
    }

    public static File[] selectFiles(Component component, String string, boolean bl, File file, File file2, boolean bl2) {
        File[] fileArray = new File[]{};
        String string2 = System.getProperty("spamworks.filechooser.default", "custom");
        if ("swing".equals(string2)) {
            JFileChooser jFileChooser = FileChooserUtilities.getFileChooser();
            jFileChooser.setMultiSelectionEnabled(bl2);
            if (file != null) {
                jFileChooser.setCurrentDirectory(file);
            }
            if (file2 != null) {
                jFileChooser.setSelectedFile(file2);
            }
            jFileChooser.setDialogTitle(string);
            int n = bl ? jFileChooser.showSaveDialog(component) : jFileChooser.showOpenDialog(component);
            if (n == 0) {
                fileArray = bl2 ? jFileChooser.getSelectedFiles() : new File[]{jFileChooser.getSelectedFile()};
            }
        } else if ("awt".equals(string2)) {
            Window window;
            Window window2 = window = component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component);
            FileDialog fileDialog = window instanceof Frame ? new FileDialog((Frame)window, string, bl ? 1 : 0) : new FileDialog((Dialog)window, string, bl ? 1 : 0);
            if (file != null) {
                try {
                    fileDialog.setDirectory(file.getCanonicalPath());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (file2 != null) {
                fileDialog.setFile(file2.getName());
            }
            DialogUtilities.centerOnScreen(fileDialog);
            if (fileDialog.getFile() != null) {
                File file3 = new File(fileDialog.getDirectory() + File.separator + fileDialog.getFile());
                fileArray = new File[]{file3};
            }
        } else {
            Window window = component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component);
            FileChooserDialog fileChooserDialog = new FileChooserDialog(window, string, file, file2, bl);
            fileChooserDialog.enabledMultipleSelection(bl2);
            DialogUtilities.centerWindow(fileChooserDialog, component);
            fileArray = fileChooserDialog.getSelectedFiles();
        }
        return fileArray;
    }
}

