/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.iterator.event;

import java.util.Hashtable;
import java.util.Map;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.io.cml.CMLHandler;
import org.openscience.cdk.io.iterator.event.DefaultEventChemObjectReader;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class EventCMLHandler
extends CMLHandler {
    private final IChemObjectBuilder builder;
    private IAtomContainer currentMolecule;
    private IAtom currentAtom;
    private Map<String, Integer> atomEnumeration;
    private int numberOfAtoms = 0;
    private int bond_a1;
    private int bond_a2;
    private IBond.Order bond_order;
    private IBond.Stereo bond_stereo;
    private String bond_id;
    protected static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(EventCMLHandler.class);
    private final DefaultEventChemObjectReader eventReader;

    public EventCMLHandler(DefaultEventChemObjectReader eventReader, IChemObjectBuilder builder) {
        super((IChemFile)builder.newInstance(IChemFile.class, new Object[0]));
        this.eventReader = eventReader;
        this.builder = builder;
        this.clearData();
    }

    private void clearData() {
        this.currentMolecule = null;
        this.atomEnumeration = null;
        this.currentAtom = null;
    }

    public IAtomContainer getAtomContainer() {
        return this.currentMolecule;
    }

    @Override
    public void startDocument() {
        logger.info((Object)"New CDO Object");
    }

    @Override
    public void endDocument() {
        logger.debug((Object)"Closing document");
        logger.info((Object)"End CDO Object");
    }

    public void setDocumentProperty(String type, String value) {
    }

    public void startObject(String objectType) {
        logger.debug((Object)("START:" + objectType));
        if (objectType.equals("Molecule")) {
            this.currentMolecule = (IAtomContainer)this.builder.newInstance(IAtomContainer.class, new Object[0]);
            this.atomEnumeration = new Hashtable<String, Integer>();
        } else if (objectType.equals("Atom")) {
            this.currentAtom = (IAtom)this.builder.newInstance(IAtom.class, new Object[]{"H"});
            logger.debug((Object)("Atom # " + this.numberOfAtoms));
            ++this.numberOfAtoms;
        } else if (objectType.equals("Bond")) {
            this.bond_id = null;
            this.bond_stereo = (IBond.Stereo)CDKConstants.UNSET;
        }
    }

    public void endObject(String objectType) {
        logger.debug((Object)("END: " + objectType));
        if (objectType.equals("Molecule")) {
            this.eventReader.fireFrameRead();
            this.clearData();
        } else if (objectType.equals("Atom")) {
            this.currentMolecule.addAtom(this.currentAtom);
        } else if (objectType.equals("Bond")) {
            logger.debug((Object)("Bond(" + this.bond_id + "): " + this.bond_a1 + ", " + this.bond_a2 + ", " + this.bond_order));
            if (this.bond_a1 > this.currentMolecule.getAtomCount() || this.bond_a2 > this.currentMolecule.getAtomCount()) {
                logger.error((Object)("Cannot add bond between at least one non-existant atom: " + this.bond_a1 + " and " + this.bond_a2));
            } else {
                IAtom a1 = this.currentMolecule.getAtom(this.bond_a1);
                IAtom a2 = this.currentMolecule.getAtom(this.bond_a2);
                IBond b = (IBond)this.builder.newInstance(IBond.class, new Object[]{a1, a2, this.bond_order});
                if (this.bond_id != null) {
                    b.setID(this.bond_id);
                }
                if (this.bond_stereo != CDKConstants.UNSET) {
                    b.setStereo(this.bond_stereo);
                }
                this.currentMolecule.addBond(b);
            }
        }
    }

    public void setObjectProperty(String objectType, String propertyType, String propertyValue) {
        block73: {
            logger.debug((Object)("objectType: " + objectType));
            logger.debug((Object)("propType: " + propertyType));
            logger.debug((Object)("property: " + propertyValue));
            if (objectType == null) {
                logger.error((Object)"Cannot add property for null object");
                return;
            }
            if (propertyType == null) {
                logger.error((Object)"Cannot add property for null property type");
                return;
            }
            if (propertyValue == null) {
                logger.warn((Object)"Will not add null property");
                return;
            }
            if (objectType.equals("Molecule")) {
                if (propertyType.equals("id")) {
                    this.currentMolecule.setID(propertyValue);
                } else if (propertyType.equals("inchi")) {
                    this.currentMolecule.setProperty((Object)"iupac.nist.chemical.identifier", (Object)propertyValue);
                }
            } else if (objectType.equals("PseudoAtom")) {
                if (propertyType.equals("label")) {
                    if (!(this.currentAtom instanceof IPseudoAtom)) {
                        this.currentAtom = (IAtom)this.builder.newInstance(IPseudoAtom.class, new Object[]{this.currentAtom});
                    }
                    ((IPseudoAtom)this.currentAtom).setLabel(propertyValue);
                }
            } else if (objectType.equals("Atom")) {
                if (propertyType.equals("type")) {
                    if (propertyValue.equals("R") && !(this.currentAtom instanceof IPseudoAtom)) {
                        this.currentAtom = (IAtom)this.builder.newInstance(IPseudoAtom.class, new Object[]{this.currentAtom});
                    }
                    this.currentAtom.setSymbol(propertyValue);
                } else if (propertyType.equals("x2")) {
                    Point2d coord = this.currentAtom.getPoint2d();
                    if (coord == null) {
                        coord = new Point2d();
                    }
                    coord.x = Double.parseDouble(propertyValue);
                    this.currentAtom.setPoint2d(coord);
                } else if (propertyType.equals("y2")) {
                    Point2d coord = this.currentAtom.getPoint2d();
                    if (coord == null) {
                        coord = new Point2d();
                    }
                    coord.y = Double.parseDouble(propertyValue);
                    this.currentAtom.setPoint2d(coord);
                } else if (propertyType.equals("x3")) {
                    Point3d coord = this.currentAtom.getPoint3d();
                    if (coord == null) {
                        coord = new Point3d();
                    }
                    coord.x = Double.parseDouble(propertyValue);
                    this.currentAtom.setPoint3d(coord);
                } else if (propertyType.equals("y3")) {
                    Point3d coord = this.currentAtom.getPoint3d();
                    if (coord == null) {
                        coord = new Point3d();
                    }
                    coord.y = Double.parseDouble(propertyValue);
                    this.currentAtom.setPoint3d(coord);
                } else if (propertyType.equals("z3")) {
                    Point3d coord = this.currentAtom.getPoint3d();
                    if (coord == null) {
                        coord = new Point3d();
                    }
                    coord.z = Double.parseDouble(propertyValue);
                    this.currentAtom.setPoint3d(coord);
                } else if (propertyType.equals("xFract")) {
                    Point3d coord = this.currentAtom.getFractionalPoint3d();
                    if (coord == null) {
                        coord = new Point3d();
                    }
                    coord.x = Double.parseDouble(propertyValue);
                    this.currentAtom.setFractionalPoint3d(coord);
                } else if (propertyType.equals("yFract")) {
                    Point3d coord = this.currentAtom.getFractionalPoint3d();
                    if (coord == null) {
                        coord = new Point3d();
                    }
                    coord.y = Double.parseDouble(propertyValue);
                    this.currentAtom.setFractionalPoint3d(coord);
                } else if (propertyType.equals("zFract")) {
                    Point3d coord = this.currentAtom.getFractionalPoint3d();
                    if (coord == null) {
                        coord = new Point3d();
                    }
                    coord.z = Double.parseDouble(propertyValue);
                    this.currentAtom.setFractionalPoint3d(coord);
                } else if (propertyType.equals("formalCharge")) {
                    this.currentAtom.setFormalCharge(Integer.valueOf(Integer.parseInt(propertyValue)));
                } else if (propertyType.equals("charge") || propertyType.equals("partialCharge")) {
                    this.currentAtom.setCharge(Double.valueOf(Double.parseDouble(propertyValue)));
                } else if (propertyType.equals("hydrogenCount")) {
                    this.currentAtom.setImplicitHydrogenCount(Integer.valueOf(Integer.parseInt(propertyValue)));
                } else if (propertyType.equals("dictRef")) {
                    this.currentAtom.setProperty((Object)"org.openscience.cdk.dict", (Object)propertyValue);
                } else if (propertyType.equals("atomicNumber")) {
                    this.currentAtom.setAtomicNumber(Integer.valueOf(Integer.parseInt(propertyValue)));
                } else if (propertyType.equals("massNumber")) {
                    this.currentAtom.setMassNumber(Integer.valueOf((int)Double.parseDouble(propertyValue)));
                } else if (propertyType.equals("id")) {
                    logger.debug((Object)"id: ", new Object[]{propertyValue});
                    this.currentAtom.setID(propertyValue);
                    this.atomEnumeration.put(propertyValue, this.numberOfAtoms);
                }
            } else if (objectType.equals("Bond")) {
                if (propertyType.equals("atom1")) {
                    this.bond_a1 = Integer.parseInt(propertyValue);
                } else if (propertyType.equals("atom2")) {
                    this.bond_a2 = Integer.parseInt(propertyValue);
                } else if (propertyType.equals("id")) {
                    logger.debug((Object)("id: " + propertyValue));
                    this.bond_id = propertyValue;
                } else if (propertyType.equals("order")) {
                    try {
                        Double order = Double.parseDouble(propertyValue);
                        if (order == 1.0) {
                            this.bond_order = IBond.Order.SINGLE;
                            break block73;
                        }
                        if (order == 2.0) {
                            this.bond_order = IBond.Order.DOUBLE;
                            break block73;
                        }
                        if (order == 3.0) {
                            this.bond_order = IBond.Order.TRIPLE;
                            break block73;
                        }
                        if (order == 4.0) {
                            this.bond_order = IBond.Order.QUADRUPLE;
                            break block73;
                        }
                        this.bond_order = IBond.Order.SINGLE;
                    }
                    catch (Exception e) {
                        logger.error((Object)("Cannot convert to double: " + propertyValue));
                        this.bond_order = IBond.Order.SINGLE;
                    }
                } else if (propertyType.equals("stereo")) {
                    if (propertyValue.equals("H")) {
                        this.bond_stereo = IBond.Stereo.DOWN;
                    } else if (propertyValue.equals("W")) {
                        this.bond_stereo = IBond.Stereo.UP;
                    }
                }
            }
        }
        logger.debug((Object)"Object property set...");
    }
}

