/*****************************************************************************
* (c) Copyright 2012-2013 F.Hoffmann-La Roche AG                             *
* Contact: bioinfoc@bioinfoc.ch, Detlef.Wolf@Roche.com.                      *
*                                                                            *
* This file is part of BIOINFO-C. BIOINFO-C is free software: you can        *
* redistribute it and/or modify it under the terms of the GNU Lesser         *
* General Public License as published by the Free Software Foundation,       *
* either version 3 of the License, or (at your option) any later version.    *
*                                                                            *
* BIOINFO-C is distributed in the hope that it will be useful, but           *
* WITHOUT ANY WARRANTY; without even the implied warranty of                 *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          *
* Lesser General Public License for more details. You should have            *
* received a copy of the GNU Lesser General Public License along with        *
* BIOINFO-C. If not, see <http://www.gnu.org/licenses/>.                     *
*****************************************************************************/
/** @file sequtil.h
    @brief Module containing sequence utilities.
    Module prefix su_
*/
#ifndef SEQUTIL_H
#define SEQUTIL_H

#ifdef __cplusplus
extern "C" {
#endif

#include "format.h"

/*
  In the following three macros, be sure not to use an expression
  with side effect for 'c'!
  (e.g. *cp++ would be disastrous)
*/
/**
   Determine whether input character is a valid gap character of a sequence
*/
#define su_isGapChar(c)  (c == '.' || c == '~' || c == '-')

/**
   Determine whether input character is a valid character of an EMBL sequence
*/
#define su_isSeqCharEmbl(c) ((c>='A' && c<='Z') || (c>='a' && c<='z') || c == '*')

/**
   Determine whether input character is a valid gap character or a valid
   character of an EMBL sequence
*/
#define su_isSeqOrGapChar(c) (su_isSeqCharEmbl(c) || su_isGapChar(c))

extern char su_complement (char b);
extern void su_revcomp (char *s);
extern char *su_iupac2alleles (char c);
extern void su_printSeq (FILE *strm,char *s);
extern char *su_seqBufferFasta (char *desc,char *s);
extern void su_printSeqFasta (FILE *strm,char *desc,char *s);
extern void su_printSeqGCG (FILE *stream,char *name,char *seq,int isNuc);

extern double su_calcMW (char *seq);

extern double su_getGEShydrophobicity (char aa);
extern double su_getKDhydrophobicity (char aa);
extern double su_calcAvgKDhydrophobicity (char *seq);

extern char su_translateCodon (char *cod);
extern char *su_translateCodonAmbig (char *cod);
extern char *su_translateSeq (char *nuc);

extern char *su_threeLetterAA (char oneLetterAA);

extern char *su_GCGtimeStamp (void);
extern int su_GCGcheckSum (char *seq);

extern char su_getSeqType (char *seq);

extern char *su_fileName2userseqName (char *nonDBname);

extern Texta su_ecExtract (char *de_line);

extern int su_blosum62 (char aa1,char aa2);

extern int su_isSwissprotID (char *n);

extern int su_rangeAc_set (char *rangeAc);
extern char *su_rangeAc_next (void);

#ifdef __cplusplus
}
#endif

#endif
