/*
 * Decompiled with CFR 0.152.
 */
package partition;

import partition.Cluster;
import partition.Location;

public class Cell {
    private int _id;
    private Location _center;
    private Cluster _cluster;

    public Cell(int id, Location center) {
        this._id = id;
        this._center = center;
    }

    public final int getId() {
        return this._id;
    }

    public final Cluster getCluster() {
        return this._cluster;
    }

    public void setCluster(Cluster cluster) {
        this._cluster = cluster;
    }

    public final Location getCenter() {
        return this._center;
    }

    public final double getSquaredDistanceTo(Cluster cluster) {
        return this._center.getSquaredDistanceTo(cluster.getCenter());
    }

    public Cluster findNearest(Cluster[] clusters) {
        Cluster nearestCluster = null;
        double minimumDistance = Double.POSITIVE_INFINITY;
        for (Cluster cluster : clusters) {
            double distance = this.getSquaredDistanceTo(cluster);
            if (!(distance < minimumDistance)) continue;
            minimumDistance = distance;
            nearestCluster = cluster;
        }
        return nearestCluster;
    }

    public String toString() {
        return this.getClass().getName() + "[id=" + this.getId() + ", " + this.getCenter().toString() + "]";
    }
}

