/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.dialogs;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.af.gMCP.config.Configuration;
import org.af.gMCP.gui.graph.NetList;

public class AlternativesDialog
extends JDialog
implements ActionListener {
    JButton ok = new JButton("Ok");
    JTextArea jta;
    JPanel panel = new JPanel();
    List<JComboBox> altBoxes = new Vector<JComboBox>();
    public static final String[] alternatives = new String[]{"less", "greater", "two.sided"};

    public AlternativesDialog(JFrame parent, NetList nl) {
        super(parent, "Number of Hypotheses", true);
        this.setLocationRelativeTo(parent);
        String cols = "5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu, fill:pref:grow, 5dlu, pref, 5dlu";
        FormLayout layout = new FormLayout(cols, rows);
        this.getContentPane().setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        this.jta = new JTextArea("This test is appropriate if the p-values\nbelong to test-statistics with a joint\nmultivariate normal null distribution.\nPlease specify below for each test whether\nit is a one-sided or a two-sided test.");
        this.jta.setLineWrap(false);
        this.jta.setMargin(new Insets(4, 4, 4, 4));
        this.getContentPane().add((Component)this.jta, cc.xy(2, 2));
        rows = "5dlu, fill:pref:grow, 5dlu";
        cols = "5dlu, pref, 5dlu, fill:pref:grow, 5dlu";
        for (int i = 0; i < nl.getNodes().size(); ++i) {
            rows = rows + ", pref, 5dlu";
        }
        layout = new FormLayout(cols, rows);
        this.panel.setLayout((LayoutManager)layout);
        int row = 2;
        CellConstraints cc2 = new CellConstraints();
        this.panel.add((Component)new JLabel("Alternatives:"), cc2.xyw(4, row, 2));
        row += 2;
        for (int i = 0; i < nl.getNodes().size(); ++i) {
            this.altBoxes.add(new JComboBox<String>(alternatives));
            this.altBoxes.get(i).setSelectedIndex(this.getIndex(Configuration.getInstance().getClassProperty(this.getClass(), "altBox" + i)));
            this.panel.add((Component)new JLabel(nl.getNodes().get(i).getName()), cc2.xy(2, row));
            this.panel.add((Component)this.altBoxes.get(i), cc2.xy(4, row));
            row += 2;
        }
        JScrollPane sp = new JScrollPane(this.panel);
        this.getContentPane().add((Component)sp, cc.xy(2, 4));
        row += 2;
        this.getContentPane().add((Component)this.ok, cc.xy(2, 6));
        this.ok.addActionListener(this);
        this.pack();
        this.setSize(this.getSize().width, Math.min(this.getSize().height, 600));
        this.setVisible(true);
    }

    private int getIndex(String alt) {
        if (alt.equals(alternatives[0])) {
            return 0;
        }
        if (alt.equals(alternatives[1])) {
            return 1;
        }
        return 2;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        for (int i = 0; i < this.altBoxes.size(); ++i) {
            Configuration.getInstance().setClassProperty(this.getClass(), "altBox" + i, this.altBoxes.get(i).getSelectedItem().toString());
        }
        this.dispose();
    }

    public String getAlternatives() {
        String s = "c(";
        for (int i = 0; i < this.altBoxes.size(); ++i) {
            s = s + "\"" + this.altBoxes.get(i).getSelectedItem() + "\"";
            if (i == this.altBoxes.size() - 1) continue;
            s = s + ", ";
        }
        return s + ")";
    }
}

