/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.reaction.mechanism;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.atomtype.CDKAtomTypeMatcher;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.ILonePair;
import org.openscience.cdk.interfaces.IMapping;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.reaction.IReactionMechanism;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class AdductionLPMechanism
implements IReactionMechanism {
    @Override
    public IReaction initiate(IAtomContainerSet atomContainerSet, ArrayList<IAtom> atomList, ArrayList<IBond> bondList) throws CDKException {
        IMapping mapping;
        IAtomContainer reactantCloned;
        CDKAtomTypeMatcher atMatcher = CDKAtomTypeMatcher.getInstance((IChemObjectBuilder)atomContainerSet.getBuilder());
        if (atomContainerSet.getAtomContainerCount() != 2) {
            throw new CDKException("AdductionLPMechanism expects two IAtomContainer's");
        }
        if (atomList.size() != 2) {
            throw new CDKException("AdductionLPMechanism expects two atoms in the ArrayList");
        }
        if (bondList != null) {
            throw new CDKException("AdductionLPMechanism don't expect bonds in the ArrayList");
        }
        IAtomContainer molecule1 = atomContainerSet.getAtomContainer(0);
        IAtomContainer molecule2 = atomContainerSet.getAtomContainer(1);
        try {
            reactantCloned = atomContainerSet.getAtomContainer(0).clone();
            reactantCloned.add(atomContainerSet.getAtomContainer(1).clone());
        }
        catch (CloneNotSupportedException e) {
            throw new CDKException("Could not clone IAtomContainer!", (Throwable)e);
        }
        IAtom atom1 = atomList.get(0);
        IAtom atom1C = reactantCloned.getAtom(molecule1.indexOf(atom1));
        IAtom atom2 = atomList.get(1);
        IAtom atom2C = reactantCloned.getAtom(molecule1.getAtomCount() + molecule2.indexOf(atom2));
        IBond newBond = (IBond)molecule1.getBuilder().newInstance(IBond.class, new Object[]{atom1C, atom2C, IBond.Order.SINGLE});
        reactantCloned.addBond(newBond);
        int charge = atom1C.getFormalCharge();
        atom1C.setFormalCharge(Integer.valueOf(charge + 1));
        List lps = reactantCloned.getConnectedLonePairsList(atom1C);
        reactantCloned.removeLonePair((ILonePair)lps.get(lps.size() - 1));
        atom1C.setHybridization(null);
        AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms((IAtomContainer)reactantCloned);
        IAtomType type = atMatcher.findMatchingAtomType(reactantCloned, atom1C);
        if (type == null || type.getAtomTypeName().equals("X")) {
            return null;
        }
        charge = atom2C.getFormalCharge();
        atom2C.setFormalCharge(Integer.valueOf(charge - 1));
        atom2C.setHybridization(null);
        AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms((IAtomContainer)reactantCloned);
        type = atMatcher.findMatchingAtomType(reactantCloned, atom2C);
        if (type == null || type.getAtomTypeName().equals("X")) {
            return null;
        }
        IReaction reaction = (IReaction)atom1C.getBuilder().newInstance(IReaction.class, new Object[0]);
        reaction.addReactant(molecule1);
        for (IAtom atom : molecule1.atoms()) {
            mapping = (IMapping)atom1C.getBuilder().newInstance(IMapping.class, new Object[]{atom, reactantCloned.getAtom(molecule1.indexOf(atom))});
            reaction.addMapping(mapping);
        }
        for (IAtom atom : molecule2.atoms()) {
            mapping = (IMapping)atom1C.getBuilder().newInstance(IMapping.class, new Object[]{atom, reactantCloned.getAtom(molecule2.indexOf(atom))});
            reaction.addMapping(mapping);
        }
        reaction.addProduct(reactantCloned);
        return reaction;
    }
}

