/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.graph.channeling.edges;

import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.GraphVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.IGraphDeltaMonitor;
import org.chocosolver.solver.variables.events.GraphEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.procedure.PairProcedure;

public class PropNeighBoolsChannel1
extends Propagator<GraphVar<?>> {
    private final int n;
    private final BoolVar[][] matrix;
    private final IGraphDeltaMonitor gdm;
    private final GraphVar<?> g;
    private final PairProcedure arcForced;
    private final PairProcedure arcRemoved;

    public PropNeighBoolsChannel1(BoolVar[][] adjacencyMatrix, GraphVar<?> gV) {
        super((Variable[])new GraphVar[]{gV}, (Priority)PropagatorPriority.LINEAR, true);
        this.matrix = adjacencyMatrix;
        this.n = this.matrix.length;
        assert (this.n == this.matrix[0].length);
        this.g = gV;
        assert (this.n == this.g.getNbMaxNodes());
        this.gdm = this.g.monitorDelta(this);
        this.arcForced = (i, j) -> {
            this.matrix[i][j].setToTrue(this);
            if (!this.g.isDirected()) {
                this.matrix[j][i].setToTrue(this);
            }
        };
        this.arcRemoved = (i, j) -> {
            this.matrix[i][j].setToFalse(this);
            if (!this.g.isDirected()) {
                this.matrix[j][i].setToFalse(this);
            }
        };
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                if (this.g.getMandatorySuccessorsOf(i).contains(j)) {
                    this.matrix[i][j].setToTrue(this);
                    continue;
                }
                if (this.g.getPotentialSuccessorsOf(i).contains(j)) continue;
                this.matrix[i][j].setToFalse(this);
            }
        }
        this.gdm.startMonitoring();
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        this.gdm.forEachEdge(this.arcForced, GraphEventType.ADD_EDGE);
        this.gdm.forEachEdge(this.arcRemoved, GraphEventType.REMOVE_EDGE);
    }

    @Override
    public ESat isEntailed() {
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                if (this.matrix[i][j].getLB() == 1 && !this.g.getPotentialSuccessorsOf(i).contains(j)) {
                    return ESat.FALSE;
                }
                if (this.matrix[i][j].getUB() != 0 || !this.g.getMandatorySuccessorsOf(i).contains(j)) continue;
                return ESat.FALSE;
            }
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

