/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.core.modelling;

import jdplus.sa.base.api.ComponentType;
import jdplus.sa.base.api.DecompositionMode;
import jdplus.sa.base.api.SeriesDecomposition;
import jdplus.sa.base.core.modelling.RegArimaDecomposer;
import jdplus.toolkit.base.api.modelling.ComponentInformation;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.core.modelling.GeneralLinearModel;
import lombok.Generated;

public final class TwoStepsDecomposition {
    private static TsData op(boolean mul, TsData l, TsData ... r) {
        if (mul) {
            return TsData.multiply((TsData)l, (TsData[])r);
        }
        return TsData.add((TsData)l, (TsData[])r);
    }

    private static TsData inv_op(boolean mul, TsData l, TsData r) {
        if (mul) {
            return TsData.divide((TsData)l, (TsData)r);
        }
        return TsData.subtract((TsData)l, (TsData)r);
    }

    public static <M> SeriesDecomposition merge(GeneralLinearModel<M> model, SeriesDecomposition sadecomp) {
        TsData all;
        TsData sa;
        TsData i;
        TsData s;
        boolean mul = model.getDescription().isLogTransformation();
        SeriesDecomposition.Builder builder = SeriesDecomposition.builder((DecompositionMode)(mul ? DecompositionMode.Multiplicative : DecompositionMode.Additive));
        TsData orig = model.getDescription().getSeries();
        TsDomain domain = orig.getDomain();
        TsData f = sadecomp.getSeries(ComponentType.Series, ComponentInformation.Forecast);
        TsData b = sadecomp.getSeries(ComponentType.Series, ComponentInformation.Backcast);
        int nf = f == null ? 0 : f.length();
        int nb = b == null ? 0 : b.length();
        int n0 = 0;
        int n1 = nb;
        int n2 = nb + domain.getLength();
        int n3 = n2 + nf;
        TsDomain cdomain = domain.extend(nb, nf);
        TsData detT = RegArimaDecomposer.deterministicEffect(model, cdomain, ComponentType.Trend, false);
        TsData detS = RegArimaDecomposer.deterministicEffect(model, cdomain, ComponentType.Seasonal, false);
        TsData detC = RegArimaDecomposer.deterministicEffect(model, cdomain, ComponentType.CalendarEffect, false);
        detS = TwoStepsDecomposition.op(mul, detS, detC);
        TsData detI = RegArimaDecomposer.deterministicEffect(model, cdomain, ComponentType.Irregular, false);
        TsData detY = RegArimaDecomposer.deterministicEffect(model, cdomain, ComponentType.Series, false);
        TsData detSA = RegArimaDecomposer.deterministicEffect(model, cdomain, ComponentType.SeasonallyAdjusted, false);
        TsData y = TwoStepsDecomposition.inv_op(mul, orig, detY.range(n1, n2));
        builder.add(y, ComponentType.Series);
        TsData t = TwoStepsDecomposition.op(mul, detT.range(n1, n2), sadecomp.getSeries(ComponentType.Trend, ComponentInformation.Value));
        if (t != null) {
            builder.add(t, ComponentType.Trend);
        }
        if ((s = TwoStepsDecomposition.op(mul, detS.range(n1, n2), sadecomp.getSeries(ComponentType.Seasonal, ComponentInformation.Value))) != null) {
            builder.add(s, ComponentType.Seasonal);
        }
        if ((i = TwoStepsDecomposition.op(mul, detI.range(n1, n2), sadecomp.getSeries(ComponentType.Irregular, ComponentInformation.Value))) != null) {
            builder.add(i, ComponentType.Irregular);
        }
        if ((sa = TwoStepsDecomposition.op(mul, detSA.range(n1, n2), detT.range(n1, n2), detI.range(n1, n2), sadecomp.getSeries(ComponentType.SeasonallyAdjusted, ComponentInformation.Value))) != null) {
            builder.add(sa, ComponentType.SeasonallyAdjusted);
        }
        if (nb > 0) {
            TsData bsa;
            TsData bi;
            TsData bs;
            all = TwoStepsDecomposition.op(mul, detT.range(n0, n1), detS.range(n0, n1), detI.range(n0, n1), b);
            builder.add(all, ComponentType.Series, ComponentInformation.Backcast);
            TsData bt = TwoStepsDecomposition.op(mul, detT.range(n0, n1), sadecomp.getSeries(ComponentType.Trend, ComponentInformation.Backcast));
            if (bt != null) {
                builder.add(bt, ComponentType.Trend, ComponentInformation.Backcast);
            }
            if ((bs = TwoStepsDecomposition.op(mul, detS.range(n0, n1), sadecomp.getSeries(ComponentType.Seasonal, ComponentInformation.Backcast))) != null) {
                builder.add(bs, ComponentType.Seasonal, ComponentInformation.Backcast);
            }
            if ((bi = TwoStepsDecomposition.op(mul, detI.range(n0, n1), sadecomp.getSeries(ComponentType.Irregular, ComponentInformation.Backcast))) != null) {
                builder.add(bi, ComponentType.Irregular, ComponentInformation.Backcast);
            }
            if ((bsa = TwoStepsDecomposition.op(mul, detSA.range(n0, n1), detT.range(n0, n1), detI.range(n0, n1), sadecomp.getSeries(ComponentType.SeasonallyAdjusted, ComponentInformation.Backcast))) != null) {
                builder.add(bsa, ComponentType.SeasonallyAdjusted, ComponentInformation.Backcast);
            }
        }
        if (nf > 0) {
            TsData fsa;
            TsData fi;
            TsData fs;
            all = TwoStepsDecomposition.op(mul, detT.range(n2, n3), detS.range(n2, n3), detI.range(n2, n3), f);
            builder.add(all, ComponentType.Series, ComponentInformation.Forecast);
            TsData ft = TwoStepsDecomposition.op(mul, detT.range(n2, n3), sadecomp.getSeries(ComponentType.Trend, ComponentInformation.Forecast));
            if (ft != null) {
                builder.add(ft, ComponentType.Trend, ComponentInformation.Forecast);
            }
            if ((fs = TwoStepsDecomposition.op(mul, detS.range(n2, n3), sadecomp.getSeries(ComponentType.Seasonal, ComponentInformation.Forecast))) != null) {
                builder.add(fs, ComponentType.Seasonal, ComponentInformation.Forecast);
            }
            if ((fi = TwoStepsDecomposition.op(mul, detI.range(n2, n3), sadecomp.getSeries(ComponentType.Irregular, ComponentInformation.Forecast))) != null) {
                builder.add(fi, ComponentType.Irregular, ComponentInformation.Forecast);
            }
            if ((fsa = TwoStepsDecomposition.op(mul, detSA.range(n2, n3), detT.range(n2, n3), detI.range(n2, n3), sadecomp.getSeries(ComponentType.SeasonallyAdjusted, ComponentInformation.Forecast))) != null) {
                builder.add(fsa, ComponentType.SeasonallyAdjusted, ComponentInformation.Forecast);
            }
        }
        return builder.build();
    }

    @Generated
    private TwoStepsDecomposition() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

