/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.regsarima;

import java.util.function.Function;
import jdplus.toolkit.base.core.arima.estimation.IArimaMapping;
import jdplus.toolkit.base.core.math.functions.levmar.LevenbergMarquardtMinimizer;
import jdplus.toolkit.base.core.math.functions.ssq.SsqFunctionMinimizer;
import jdplus.toolkit.base.core.regarima.IRegArimaComputer;
import jdplus.toolkit.base.core.regarima.RegArimaEstimation;
import jdplus.toolkit.base.core.regarima.RegArimaMapping;
import jdplus.toolkit.base.core.regarima.RegArimaModel;
import jdplus.toolkit.base.core.regarima.RegArmaModel;
import jdplus.toolkit.base.core.regarima.estimation.ConcentratedLikelihoodComputer;
import jdplus.toolkit.base.core.regarima.estimation.RegArmaEstimation;
import jdplus.toolkit.base.core.regarima.estimation.RegArmaProcessor;
import jdplus.toolkit.base.core.regsarima.IArmaInitializer;
import jdplus.toolkit.base.core.sarima.SarimaModel;
import jdplus.toolkit.base.core.sarima.estimation.SarimaMapping;
import jdplus.toolkit.base.core.stats.likelihood.ConcentratedLikelihoodWithMissing;
import jdplus.toolkit.base.core.stats.likelihood.LogLikelihoodFunction;

public class GlsSarimaComputer
implements IRegArimaComputer<SarimaModel> {
    public static final GlsSarimaComputer PROCESSOR = new Builder().precision(1.0E-7).build();
    public static final double DEF_EPS = 1.0E-7;
    private final IArmaInitializer initializer;
    private final SsqFunctionMinimizer min;
    private final boolean ml;
    private final boolean mt;
    private final boolean fast;

    public static Builder builder() {
        return new Builder();
    }

    private GlsSarimaComputer(IArmaInitializer initializer, SsqFunctionMinimizer min, boolean ml, boolean mt, boolean fast) {
        this.initializer = initializer;
        this.min = min;
        this.ml = ml;
        this.mt = mt;
        this.fast = fast;
    }

    @Override
    public RegArimaEstimation<SarimaModel> process(RegArimaModel<SarimaModel> regs, IArimaMapping<SarimaModel> mapping) {
        RegArmaModel<SarimaModel> dmodel = regs.differencedModel();
        SarimaModel start = this.initializer.initialize(dmodel);
        return this.optimize(regs, start, mapping);
    }

    @Override
    public RegArimaEstimation<SarimaModel> optimize(RegArimaModel<SarimaModel> regs, IArimaMapping<SarimaModel> mapping) {
        return this.optimize(regs, null, mapping);
    }

    public LogLikelihoodFunction<RegArimaModel<SarimaModel>, ConcentratedLikelihoodWithMissing> llFunction(RegArimaModel<SarimaModel> regs, IArimaMapping<SarimaModel> mapping) {
        RegArimaMapping<SarimaModel> rmapping = mapping == null ? new RegArimaMapping<SarimaModel>(SarimaMapping.of(regs.arima().orders()), regs) : new RegArimaMapping<SarimaModel>(mapping, regs);
        Function<RegArimaModel, ConcentratedLikelihoodWithMissing> fn = model -> ConcentratedLikelihoodComputer.DEFAULT_COMPUTER.compute(model);
        return new LogLikelihoodFunction<RegArimaModel<SarimaModel>, ConcentratedLikelihoodWithMissing>(rmapping, fn);
    }

    private RegArimaEstimation<SarimaModel> optimize(RegArimaModel<SarimaModel> regs, SarimaModel ststart, IArimaMapping<SarimaModel> mapping) {
        RegArmaModel<SarimaModel> dmodel = regs.differencedModel();
        if (ststart == null) {
            ststart = dmodel.getArma();
        }
        RegArmaProcessor processor = new RegArmaProcessor(this.ml, this.mt, this.fast);
        int ndf = dmodel.getY().length() - dmodel.getX().getColumnsCount();
        SarimaMapping stationaryMapping = mapping == null ? SarimaMapping.of(ststart.orders()) : mapping.stationaryMapping();
        RegArmaEstimation<SarimaModel> rslt = processor.compute(dmodel, stationaryMapping.parametersOf(ststart), stationaryMapping, this.min, ndf);
        SarimaModel arima = mapping == null ? SarimaModel.builder(regs.arima().orders()).parameters(rslt.getParameters()).build() : (SarimaModel)mapping.map(rslt.getParameters());
        RegArimaModel nmodel = RegArimaModel.of(regs, arima);
        return RegArimaEstimation.builder().model(nmodel).concentratedLikelihood(ConcentratedLikelihoodComputer.DEFAULT_COMPUTER.compute(nmodel)).max(new LogLikelihoodFunction.Point(this.llFunction(regs, mapping), rslt.getParameters(), rslt.getScore(), rslt.getInformation())).build();
    }

    public static class Builder {
        private IArmaInitializer initializer;
        private double eps = 1.0E-7;
        private SsqFunctionMinimizer.Builder min;
        private boolean ml = true;
        private boolean mt = false;
        private boolean fast = true;

        public Builder initializer(IArmaInitializer initializer) {
            this.initializer = initializer;
            return this;
        }

        public Builder minimizer(SsqFunctionMinimizer.Builder min) {
            this.min = min;
            return this;
        }

        public Builder precision(double eps) {
            this.eps = eps;
            return this;
        }

        public Builder useMaximumLikelihood(boolean ml) {
            this.ml = ml;
            return this;
        }

        public Builder useParallelProcessing(boolean mt) {
            this.mt = mt;
            return this;
        }

        public Builder computeExactFinalDerivatives(boolean exact) {
            this.fast = !exact;
            return this;
        }

        public GlsSarimaComputer build() {
            SsqFunctionMinimizer.Builder builder = this.min == null ? LevenbergMarquardtMinimizer.builder() : this.min;
            return new GlsSarimaComputer(this.initializer == null ? IArmaInitializer.defaultInitializer() : this.initializer, builder.functionPrecision(this.eps).build(), this.ml, this.mt, this.fast);
        }
    }
}

