/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.stats.linearmodel;

import java.util.function.IntToDoubleFunction;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.analysis.WindowFunction;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;
import jdplus.toolkit.base.core.stats.RobustCovarianceComputer;
import jdplus.toolkit.base.core.stats.linearmodel.LinearModel;
import lombok.Generated;

public final class RobustCovarianceEstimators {
    public static FastMatrix hac(LinearModel model, DoubleSeq olsCoefficients, WindowFunction w, int truncationLag) {
        FastMatrix x = model.variables();
        DataBlock u = model.calcResiduals(olsCoefficients);
        FastMatrix xx = SymmetricMatrix.XtX(x);
        int n = x.getRowsCount();
        xx.div(n);
        FastMatrix ixx = SymmetricMatrix.inverse(xx);
        x.applyByColumns(arg_0 -> RobustCovarianceEstimators.lambda$hac$1((DoubleSeq)u, arg_0));
        FastMatrix phi = RobustCovarianceComputer.covariance(x, w, truncationLag);
        return RobustCovarianceEstimators.sandwich(phi, ixx, n);
    }

    public static FastMatrix sandwich(FastMatrix meat, FastMatrix bread, int n) {
        FastMatrix omega = SymmetricMatrix.XtSX(meat, bread);
        omega.div(n);
        return omega;
    }

    public static IntToDoubleFunction HC0(LinearModel model, DoubleSeq olsCoefficients) {
        DataBlock u = model.calcResiduals(olsCoefficients);
        return arg_0 -> RobustCovarianceEstimators.lambda$HC0$2((DoubleSeq)u, arg_0);
    }

    public static IntToDoubleFunction HC1(LinearModel model, DoubleSeq olsCoefficients) {
        DataBlock u = model.calcResiduals(olsCoefficients);
        double n = u.length();
        double k = olsCoefficients.length();
        double c = n / (n - k);
        return arg_0 -> RobustCovarianceEstimators.lambda$HC1$3(c, (DoubleSeq)u, arg_0);
    }

    public static IntToDoubleFunction HC2(LinearModel model, DoubleSeq olsCoefficients) {
        DataBlock u = model.calcResiduals(olsCoefficients);
        double n = u.length();
        double k = olsCoefficients.length();
        double c = n / (n - k);
        return arg_0 -> RobustCovarianceEstimators.lambda$HC2$4(c, (DoubleSeq)u, arg_0);
    }

    public static FastMatrix hc(LinearModel model, DoubleSeq olsCoefficients, IntToDoubleFunction w) {
        FastMatrix x = model.variables();
        FastMatrix xx = SymmetricMatrix.XtX(x);
        int n = x.getRowsCount();
        xx.div(n);
        FastMatrix ixx = SymmetricMatrix.inverse(xx);
        FastMatrix phi = FastMatrix.square(x.getColumnsCount());
        for (int i = 0; i < n; ++i) {
            double z = w.applyAsDouble(i);
            phi.addXaXt(z * z, x.row(i));
        }
        phi.div(n);
        return RobustCovarianceEstimators.sandwich(phi, ixx, n);
    }

    @Generated
    private RobustCovarianceEstimators() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static /* synthetic */ double lambda$HC2$4(double c, DoubleSeq u, int i) {
        return c * u.get(i);
    }

    private static /* synthetic */ double lambda$HC1$3(double c, DoubleSeq u, int i) {
        return c * u.get(i);
    }

    private static /* synthetic */ double lambda$HC0$2(DoubleSeq u, int i) {
        return u.get(i);
    }

    private static /* synthetic */ void lambda$hac$1(DoubleSeq u, DataBlock c) {
        c.apply(u, (a, b) -> a * b);
    }
}

