
<!-- README.md is generated from README.Rmd. Please edit that file -->

# neuroUp <a href="https://eduardklap.github.io/neuroUp/"><img src="man/figures/logo.png" align="right" height="139" alt="neuroUp website" /></a>

<!-- badges: start -->

[![R-CMD-check](https://github.com/eduardklap/neuroUp/actions/workflows/R-CMD-check.yaml/badge.svg)](https://github.com/eduardklap/neuroUp/actions/workflows/R-CMD-check.yaml)
[![Codecov test
coverage](https://codecov.io/gh/eduardklap/neuroUp/branch/main/graph/badge.svg)](https://app.codecov.io/gh/eduardklap/neuroUp?branch=main)
[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.11526169.svg)](https://doi.org/10.5281/zenodo.11526169)
<!-- badges: end -->

## Overview

The goal of neuroUp is to perform empirical sample size determination
and Bayesian updating for region of interest based task-related fMRI
studies. For a more elaborate introduction to the method, see our
preprint:

Klapwijk, E. T., Jongerling, J., Hoijtink, H., & Crone, E. (2024, July
9). Sample size estimation for task-related functional MRI studies using
Bayesian updating. <https://doi.org/10.31234/osf.io/cz32t>

## Installation

Run the following in R:

``` r
install.packages("neuroUp")
```

Or you can install the latest development version of neuroUp from
[GitHub](https://github.com/) with:

``` r
install.packages("devtools")
devtools::install_github("eduardklap/neuroUp")
```

Then run the following to get started:

``` r
library(neuroUp)
```

## Citation

To cite package neuroUp in publications use:

Klapwijk, E., Hoijtink, H., & Jongerling, J. (2024). neuroUp: Plan
sample size for fMRI regions of interest research using Bayesian
updating. <https://doi.org/10.5281/zenodo.11526169>
