/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.core.x13.extractors;

import jdplus.toolkit.base.api.information.InformationMapping;
import jdplus.toolkit.base.api.math.matrices.Matrix;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.x13.base.api.x11.MsrTable;
import jdplus.x13.base.api.x11.SeasonalFilterOption;
import jdplus.x13.base.core.x11.X11Results;

public class X11Extractor
extends InformationMapping<X11Results> {
    public X11Extractor() {
        this.set("mode", String.class, source -> source.getMode().name());
        this.set("b1", TsData.class, source -> source.getB1());
        this.set("b2", TsData.class, source -> source.getB2());
        this.set("b3", TsData.class, source -> source.getB3());
        this.set("b4", TsData.class, source -> source.getB4());
        this.set("b5", TsData.class, source -> source.getB5());
        this.set("b6", TsData.class, source -> source.getB6());
        this.set("b7", TsData.class, source -> source.getB7());
        this.set("b8", TsData.class, source -> source.getB8());
        this.set("b9", TsData.class, source -> source.getB9());
        this.set("b10", TsData.class, source -> source.getB10());
        this.set("b11", TsData.class, source -> source.getB11());
        this.set("b13", TsData.class, source -> source.getB13());
        this.set("b17", TsData.class, source -> source.getB17());
        this.set("b20", TsData.class, source -> source.getB20());
        this.set("c1", TsData.class, source -> source.getC1());
        this.set("c2", TsData.class, source -> source.getC2());
        this.set("c4", TsData.class, source -> source.getC4());
        this.set("c5", TsData.class, source -> source.getC5());
        this.set("c6", TsData.class, source -> source.getC6());
        this.set("c7", TsData.class, source -> source.getC7());
        this.set("c9", TsData.class, source -> source.getC9());
        this.set("c10", TsData.class, source -> source.getC10());
        this.set("c11", TsData.class, source -> source.getC11());
        this.set("c13", TsData.class, source -> source.getC13());
        this.set("c17", TsData.class, source -> source.getC17());
        this.set("c20", TsData.class, source -> source.getC20());
        this.set("d1", TsData.class, source -> source.getD1());
        this.set("d2", TsData.class, source -> source.getD2());
        this.set("d4", TsData.class, source -> source.getD4());
        this.set("d5", TsData.class, source -> source.getD5());
        this.set("d6", TsData.class, source -> source.getD6());
        this.set("d7", TsData.class, source -> source.getD7());
        this.set("d8", TsData.class, source -> source.getD8());
        this.set("d9", TsData.class, source -> source.getD9());
        this.set("d10", TsData.class, source -> source.getD10());
        this.set("d11", TsData.class, source -> source.getD11());
        this.set("d12", TsData.class, source -> source.getD12());
        this.set("d13", TsData.class, source -> source.getD13());
        this.set("icratio", Double.class, source -> source.getICRatio());
        this.set("trend-filter", Integer.class, source -> source.getFinalHendersonFilterLength());
        this.set("seasonal-filters", String[].class, source -> {
            int n;
            SeasonalFilterOption[] filters = source.getFinalSeasonalFilter();
            if (filters == null || filters.length == 0) {
                return null;
            }
            SeasonalFilterOption f0 = filters[0];
            for (n = 1; n < filters.length && filters[n] == f0; ++n) {
            }
            if (n == filters.length) {
                return new String[]{f0.name()};
            }
            String[] f = new String[filters.length];
            for (int i = 0; i < f.length; ++i) {
                f[i] = filters[i].name();
            }
            return f;
        });
        this.set("d9-global-msr", Double.class, source -> {
            MsrTable msr = source.getD9Msr();
            return msr == null ? null : Double.valueOf(msr.getGlobalMsr());
        });
        this.set("d9-msr", double[].class, source -> {
            MsrTable msr = source.getD9Msr();
            if (msr == null) {
                return null;
            }
            double[] m = new double[msr.getCount()];
            for (int i = 0; i < m.length; ++i) {
                m[i] = msr.getMsr(i);
            }
            return m;
        });
        this.set("d9-msr-table", Matrix.class, source -> {
            MsrTable msr = source.getD9Msr();
            if (msr == null) {
                return null;
            }
            int n = msr.getCount();
            FastMatrix M = FastMatrix.make((int)3, (int)n);
            double[] irr = msr.getMeanIrregularEvolutions();
            double[] seas = msr.getMeanSeasonalEvolutions();
            for (int i = 0; i < n; ++i) {
                M.set(0, i, irr[i]);
                M.set(1, i, seas[i]);
                M.set(2, i, msr.getMsr(i));
            }
            return M;
        });
        this.set("x11-all", Matrix.class, source -> {
            TsData b1 = source.getB1();
            TsPeriod start = b1.getStart();
            int nr = b1.length();
            int nc = 38;
            FastMatrix m = FastMatrix.make((int)nr, (int)nc);
            m.set(Double.NaN);
            int c = 0;
            m.column(c++).copy(b1.getValues());
            TsData s = source.getB2();
            int n0 = start.until(s.getStart());
            int n1 = s.length();
            m.column(c++).range(n0, n0 + n1).copy(s.getValues());
            s = source.getB3();
            n0 = start.until(s.getStart());
            n1 = s.length();
            m.column(c++).range(n0, n0 + n1).copy(s.getValues());
            s = source.getB4();
            n0 = start.until(s.getStart());
            n1 = s.length();
            m.column(c++).range(n0, n0 + n1).copy(s.getValues());
            s = source.getB5();
            n0 = start.until(s.getStart());
            n1 = s.length();
            m.column(c++).range(n0, n0 + n1).copy(s.getValues());
            s = source.getB6();
            n0 = start.until(s.getStart());
            n1 = s.length();
            m.column(c++).range(n0, n0 + n1).copy(s.getValues());
            s = source.getB7();
            n0 = start.until(s.getStart());
            n1 = s.length();
            m.column(c++).range(n0, n0 + n1).copy(s.getValues());
            s = source.getB8();
            n0 = start.until(s.getStart());
            n1 = s.length();
            m.column(c++).range(n0, n0 + n1).copy(s.getValues());
            s = source.getB9();
            n0 = start.until(s.getStart());
            n1 = s.length();
            m.column(c++).range(n0, n0 + n1).copy(s.getValues());
            s = source.getB10();
            n0 = start.until(s.getStart());
            n1 = s.length();
            m.column(c++).range(n0, n0 + n1).copy(s.getValues());
            s = source.getB11();
            n0 = start.until(s.getStart());
            n1 = s.length();
            m.column(c++).range(n0, n0 + n1).copy(s.getValues());
            s = source.getB13();
            n0 = start.until(s.getStart());
            n1 = s.length();
            m.column(c++).range(n0, n0 + n1).copy(s.getValues());
            s = source.getB17();
            n0 = start.until(s.getStart());
            n1 = s.length();
            m.column(c++).range(n0, n0 + n1).copy(s.getValues());
            s = source.getB20();
            n0 = start.until(s.getStart());
            n1 = s.length();
            m.column(c++).range(n0, n0 + n1).copy(s.getValues());
            s = source.getC1();
            n0 = start.until(s.getStart());
            n1 = s.length();
            m.column(c++).range(n0, n0 + n1).copy(s.getValues());
            s = source.getC2();
            n0 = start.until(s.getStart());
            n1 = s.length();
            m.column(c++).range(n0, n0 + n1).copy(s.getValues());
            s = source.getC4();
            n0 = start.until(s.getStart());
            n1 = s.length();
            m.column(c++).range(n0, n0 + n1).copy(s.getValues());
            s = source.getC5();
            n0 = start.until(s.getStart());
            n1 = s.length();
            m.column(c++).range(n0, n0 + n1).copy(s.getValues());
            s = source.getC6();
            n0 = start.until(s.getStart());
            n1 = s.length();
            m.column(c++).range(n0, n0 + n1).copy(s.getValues());
            s = source.getC7();
            n0 = start.until(s.getStart());
            n1 = s.length();
            m.column(c++).range(n0, n0 + n1).copy(s.getValues());
            s = source.getC9();
            n0 = start.until(s.getStart());
            n1 = s.length();
            m.column(c++).range(n0, n0 + n1).copy(s.getValues());
            s = source.getC10();
            n0 = start.until(s.getStart());
            n1 = s.length();
            m.column(c++).range(n0, n0 + n1).copy(s.getValues());
            s = source.getC11();
            n0 = start.until(s.getStart());
            n1 = s.length();
            m.column(c++).range(n0, n0 + n1).copy(s.getValues());
            s = source.getC13();
            n0 = start.until(s.getStart());
            n1 = s.length();
            m.column(c++).range(n0, n0 + n1).copy(s.getValues());
            s = source.getC17();
            n0 = start.until(s.getStart());
            n1 = s.length();
            m.column(c++).range(n0, n0 + n1).copy(s.getValues());
            s = source.getC20();
            n0 = start.until(s.getStart());
            n1 = s.length();
            m.column(c++).range(n0, n0 + n1).copy(s.getValues());
            s = source.getD1();
            n0 = start.until(s.getStart());
            n1 = s.length();
            m.column(c++).range(n0, n0 + n1).copy(s.getValues());
            s = source.getD2();
            n0 = start.until(s.getStart());
            n1 = s.length();
            m.column(c++).range(n0, n0 + n1).copy(s.getValues());
            s = source.getD4();
            n0 = start.until(s.getStart());
            n1 = s.length();
            m.column(c++).range(n0, n0 + n1).copy(s.getValues());
            s = source.getD5();
            n0 = start.until(s.getStart());
            n1 = s.length();
            m.column(c++).range(n0, n0 + n1).copy(s.getValues());
            s = source.getD6();
            n0 = start.until(s.getStart());
            n1 = s.length();
            m.column(c++).range(n0, n0 + n1).copy(s.getValues());
            s = source.getD7();
            n0 = start.until(s.getStart());
            n1 = s.length();
            m.column(c++).range(n0, n0 + n1).copy(s.getValues());
            s = source.getD8();
            n0 = start.until(s.getStart());
            n1 = s.length();
            m.column(c++).range(n0, n0 + n1).copy(s.getValues());
            s = source.getD9();
            n0 = start.until(s.getStart());
            n1 = s.length();
            m.column(c++).range(n0, n0 + n1).copy(s.getValues());
            s = source.getD10();
            n0 = start.until(s.getStart());
            n1 = s.length();
            m.column(c++).range(n0, n0 + n1).copy(s.getValues());
            s = source.getD11();
            n0 = start.until(s.getStart());
            n1 = s.length();
            m.column(c++).range(n0, n0 + n1).copy(s.getValues());
            s = source.getD12();
            n0 = start.until(s.getStart());
            n1 = s.length();
            m.column(c++).range(n0, n0 + n1).copy(s.getValues());
            s = source.getD13();
            n0 = start.until(s.getStart());
            n1 = s.length();
            m.column(c++).range(n0, n0 + n1).copy(s.getValues());
            return m;
        });
    }

    public Class<X11Results> getSourceClass() {
        return X11Results.class;
    }
}

