/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators.factorAnalysis;

import dr.inference.distribution.DistributionLikelihood;
import dr.inference.model.LatentFactorModel;
import dr.inference.model.MatrixParameterInterface;
import dr.inference.model.Parameter;
import dr.inference.operators.AbstractAdaptableOperator;
import dr.inference.operators.AdaptationMode;
import dr.math.MathUtils;
import dr.math.distributions.MultivariateNormalDistribution;
import dr.math.distributions.NormalDistribution;
import dr.math.matrixAlgebra.CholeskyDecomposition;
import dr.math.matrixAlgebra.IllegalDimension;
import dr.math.matrixAlgebra.SymmetricMatrix;
import java.util.ArrayList;
import java.util.ListIterator;

public class LoadingsIndependenceOperator
extends AbstractAdaptableOperator {
    NormalDistribution prior;
    LatentFactorModel LFM;
    ArrayList<double[][]> precisionArray;
    ArrayList<double[]> meanMidArray;
    ArrayList<double[]> meanArray;
    boolean randomScan;
    double scaleFactor;
    double priorPrecision;
    double priorMeanPrecision;

    public LoadingsIndependenceOperator(LatentFactorModel latentFactorModel, DistributionLikelihood distributionLikelihood, double d, boolean bl, double d2, AdaptationMode adaptationMode) {
        super(adaptationMode);
        this.setWeight(d);
        this.scaleFactor = d2;
        this.prior = (NormalDistribution)distributionLikelihood.getDistribution();
        this.LFM = latentFactorModel;
        this.precisionArray = new ArrayList();
        this.randomScan = bl;
        this.meanArray = new ArrayList();
        this.meanMidArray = new ArrayList();
        if (!bl) {
            double[] dArray;
            int n;
            for (n = 0; n < latentFactorModel.getFactorDimension(); ++n) {
                double[][] dArray2 = new double[n + 1][n + 1];
                this.precisionArray.add(dArray2);
            }
            for (n = 0; n < latentFactorModel.getFactorDimension(); ++n) {
                dArray = new double[n + 1];
                this.meanArray.add(dArray);
            }
            for (n = 0; n < latentFactorModel.getFactorDimension(); ++n) {
                dArray = new double[n + 1];
                this.meanMidArray.add(dArray);
            }
        } else {
            double[] dArray;
            int n;
            for (n = 0; n < latentFactorModel.getFactorDimension(); ++n) {
                double[][] dArray3 = new double[latentFactorModel.getFactorDimension() - n][latentFactorModel.getFactorDimension() - n];
                this.precisionArray.add(dArray3);
            }
            for (n = 0; n < latentFactorModel.getFactorDimension(); ++n) {
                dArray = new double[latentFactorModel.getFactorDimension() - n];
                this.meanArray.add(dArray);
            }
            for (n = 0; n < latentFactorModel.getFactorDimension(); ++n) {
                dArray = new double[latentFactorModel.getFactorDimension() - n];
                this.meanMidArray.add(dArray);
            }
        }
        this.priorPrecision = 1.0 / (this.prior.getSD() * this.prior.getSD());
        this.priorMeanPrecision = this.prior.getMean() * this.priorPrecision;
    }

    private void getPrecisionOfTruncated(MatrixParameterInterface matrixParameterInterface, int n, int n2, double[][] dArray) {
        int n3 = matrixParameterInterface.getColumnDimension();
        for (int i = 0; i < n; ++i) {
            for (int j = i; j < n; ++j) {
                double d = 0.0;
                for (int k = 0; k < n3; ++k) {
                    d += matrixParameterInterface.getParameterValue(i, k) * matrixParameterInterface.getParameterValue(j, k);
                }
                dArray[i][j] = d * this.LFM.getColumnPrecision().getParameterValue(n2, n2);
                if (i == j) {
                    double[] dArray2 = dArray[i];
                    int n4 = j;
                    dArray2[n4] = dArray2[n4] + this.priorPrecision;
                    continue;
                }
                dArray[j][i] = dArray[i][j];
            }
        }
    }

    private void getTruncatedMean(int n, int n2, double[][] dArray, double[] dArray2, double[] dArray3) {
        int n3;
        double d;
        int n4;
        MatrixParameterInterface matrixParameterInterface = this.LFM.getScaledData();
        MatrixParameterInterface matrixParameterInterface2 = this.LFM.getFactors();
        int n5 = matrixParameterInterface.getColumnDimension();
        for (n4 = 0; n4 < n; ++n4) {
            d = 0.0;
            for (n3 = 0; n3 < n5; ++n3) {
                d += matrixParameterInterface2.getParameterValue(n4, n3) * matrixParameterInterface.getParameterValue(n2, n3);
            }
            d *= this.LFM.getColumnPrecision().getParameterValue(n2, n2);
            dArray2[n4] = d += this.priorMeanPrecision;
        }
        for (n4 = 0; n4 < n; ++n4) {
            d = 0.0;
            for (n3 = 0; n3 < n; ++n3) {
                d += dArray[n4][n3] * dArray2[n3];
            }
            dArray3[n4] = d;
        }
    }

    private void getPrecision(int n, double[][] dArray) {
        int n2 = this.LFM.getFactorDimension();
        if (n < n2) {
            this.getPrecisionOfTruncated(this.LFM.getFactors(), n + 1, n, dArray);
        } else {
            this.getPrecisionOfTruncated(this.LFM.getFactors(), n2, n, dArray);
        }
    }

    private void getMean(int n, double[][] dArray, double[] dArray2, double[] dArray3) {
        int n2 = this.LFM.getFactorDimension();
        if (n < n2) {
            this.getTruncatedMean(n + 1, n, dArray, dArray2, dArray3);
        } else {
            this.getTruncatedMean(n2, n, dArray, dArray2, dArray3);
        }
    }

    private void copy(int n, double[] dArray) {
        Parameter parameter = this.LFM.getLoadings().getParameter(n);
        for (int i = 0; i < dArray.length; ++i) {
            parameter.setParameterValueQuietly(i, dArray[i]);
        }
    }

    private void drawI(int n, ListIterator<double[][]> listIterator, ListIterator<double[]> listIterator2, ListIterator<double[]> listIterator3) {
        double[] dArray = null;
        double[][] dArray2 = null;
        double[] dArray3 = null;
        double[] dArray4 = null;
        double[][] dArray5 = null;
        if (listIterator.hasNext()) {
            dArray2 = listIterator.next();
        }
        if (listIterator2.hasNext()) {
            dArray3 = listIterator2.next();
        }
        if (listIterator3.hasNext()) {
            dArray4 = listIterator3.next();
        }
        this.getPrecision(n, dArray2);
        double[][] dArray6 = new SymmetricMatrix(dArray2).inverse().toComponents();
        try {
            dArray5 = new CholeskyDecomposition(dArray6).getL();
        }
        catch (IllegalDimension illegalDimension) {
            illegalDimension.printStackTrace();
        }
        this.getMean(n, dArray6, dArray3, dArray4);
        dArray = MultivariateNormalDistribution.nextMultivariateNormalCholesky(dArray4, dArray5, this.scaleFactor);
        if (n < dArray.length) {
            if (dArray[n] > 0.0) {
                this.copy(n, dArray);
            }
        } else {
            this.copy(n, dArray);
        }
    }

    @Override
    public String getOperatorName() {
        return "loadingsGibbsOperator";
    }

    @Override
    public double doOperation() {
        int n = this.LFM.getLoadings().getColumnDimension();
        if (!this.randomScan) {
            ListIterator<double[][]> listIterator = this.precisionArray.listIterator();
            ListIterator<double[]> listIterator2 = this.meanMidArray.listIterator();
            ListIterator<double[]> listIterator3 = this.meanArray.listIterator();
            for (int i = 0; i < n; ++i) {
                this.drawI(i, listIterator, listIterator2, listIterator3);
            }
            this.LFM.getLoadings().fireParameterChangedEvent();
        } else {
            ListIterator<double[]> listIterator;
            ListIterator<double[]> listIterator4;
            ListIterator<double[][]> listIterator5;
            int n2 = MathUtils.nextInt(this.LFM.getLoadings().getColumnDimension());
            if (n2 < this.LFM.getFactorDimension()) {
                listIterator5 = this.precisionArray.listIterator(this.LFM.getFactorDimension() - n2 - 1);
                listIterator4 = this.meanMidArray.listIterator(this.LFM.getFactorDimension() - n2 - 1);
                listIterator = this.meanArray.listIterator(this.LFM.getFactorDimension() - n2 - 1);
            } else {
                listIterator5 = this.precisionArray.listIterator();
                listIterator4 = this.meanMidArray.listIterator();
                listIterator = this.meanArray.listIterator();
            }
            this.drawI(n2, listIterator5, listIterator4, listIterator);
            this.LFM.getLoadings().fireParameterChangedEvent();
        }
        return 0.0;
    }

    @Override
    protected double getAdaptableParameterValue() {
        return Math.log(this.scaleFactor);
    }

    @Override
    public void setAdaptableParameterValue(double d) {
        this.scaleFactor = Math.exp(d);
    }

    @Override
    public double getRawParameter() {
        return this.scaleFactor;
    }

    @Override
    public String getAdaptableParameterName() {
        return "scaleFactor";
    }
}

