/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.jayes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.recommenders.internal.jayes.util.BidirectionalMap;
import org.eclipse.recommenders.jayes.factor.AbstractFactor;
import org.eclipse.recommenders.jayes.factor.DenseFactor;
import org.eclipse.recommenders.jayes.factor.arraywrapper.DoubleArrayWrapper;
import org.eclipse.recommenders.jayes.util.MathUtils;

public class BayesNode {
    private final String name;
    private final List<BayesNode> children = new ArrayList<BayesNode>();
    private final List<BayesNode> parents = new ArrayList<BayesNode>();
    private int outcomes = 0;
    private final BidirectionalMap<String, Integer> outcomeIndices = new BidirectionalMap();
    private final AbstractFactor factor = new DenseFactor();
    private int id = -1;
    private final List<String> outcomesList = new ArrayList<String>();

    @Deprecated
    public BayesNode(String name) {
        if (name == null) {
            throw new NullPointerException("A BayesNode's name may not be null");
        }
        this.name = name;
    }

    public void setProbabilities(double ... probabilities) {
        this.adjustFactordimensions();
        if (probabilities.length != MathUtils.product(this.factor.getDimensions())) {
            throw new IllegalArgumentException("Probability table does not have expected size. Expected: " + MathUtils.product(this.factor.getDimensions()) + "but got: " + probabilities.length);
        }
        this.factor.setValues(new DoubleArrayWrapper(probabilities));
    }

    public double[] getProbabilities() {
        return this.factor.getValues().toDoubleArray();
    }

    public List<BayesNode> getChildren() {
        return this.children;
    }

    public List<BayesNode> getParents() {
        return Collections.unmodifiableList(this.parents);
    }

    public void setParents(List<BayesNode> parents) {
        if (parents.contains(null)) {
            throw new NullPointerException("found null in parents - null is not a valid BayesNode");
        }
        for (BayesNode oldParent : this.parents) {
            oldParent.children.remove(this);
        }
        this.parents.clear();
        this.parents.addAll(parents);
        for (BayesNode p : parents) {
            p.children.add(this);
        }
        this.adjustFactordimensions();
    }

    private void adjustFactordimensions() {
        int[] dimensions = new int[this.parents.size() + 1];
        int[] dimensionIds = new int[this.parents.size() + 1];
        this.fillWithParentDimensions(dimensions, dimensionIds);
        this.insertSelf(dimensions, dimensionIds);
        this.factor.setDimensions(dimensions);
        this.factor.setDimensionIDs(dimensionIds);
    }

    private void insertSelf(int[] dimensions, int[] dimensionIds) {
        dimensions[dimensions.length - 1] = this.getOutcomeCount();
        dimensionIds[dimensionIds.length - 1] = this.getId();
    }

    private void fillWithParentDimensions(int[] dimensions, int[] dimensionIds) {
        ListIterator<BayesNode> it = this.parents.listIterator();
        while (it.hasNext()) {
            BayesNode p = it.next();
            dimensions[it.nextIndex() - 1] = p.getOutcomeCount();
            dimensionIds[it.nextIndex() - 1] = p.getId();
        }
    }

    @Deprecated
    public double[] marginalize(Map<BayesNode, String> evidence) {
        for (BayesNode p : this.parents) {
            if (evidence.containsKey(p)) {
                this.getFactor().select(p.getId(), p.getOutcomeIndex(evidence.get(p)));
                continue;
            }
            this.getFactor().select(p.getId(), -1);
        }
        double[] result = MathUtils.normalize(this.factor.marginalizeAllBut(-1));
        this.factor.resetSelections();
        return result;
    }

    public int getId() {
        return this.id;
    }

    @Deprecated
    public void setId(int id) {
        if (this.id != -1) {
            throw new IllegalStateException("Impossible to reset Id!");
        }
        if (id < 0) {
            throw new IllegalArgumentException("id has to be greater or equal to 0");
        }
        this.id = id;
    }

    public void addOutcomes(String ... names) {
        if (!Collections.disjoint(this.outcomesList, Arrays.asList(names))) {
            throw new IllegalArgumentException("Outcome already exists");
        }
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            this.outcomeIndices.put(name, this.outcomes);
            ++this.outcomes;
            this.outcomesList.add(name);
            ++n2;
        }
        this.adjustFactordimensions();
    }

    public int addOutcome(String name) {
        this.addOutcomes(name);
        return this.outcomes - 1;
    }

    public int getOutcomeIndex(String name) {
        try {
            return this.outcomeIndices.get(name);
        }
        catch (NullPointerException ex) {
            throw new IllegalArgumentException(name, ex);
        }
    }

    public String getOutcomeName(int index) {
        return this.outcomeIndices.getKey(index);
    }

    public int getOutcomeCount() {
        return this.outcomes;
    }

    public AbstractFactor getFactor() {
        return this.factor;
    }

    public List<String> getOutcomes() {
        return Collections.unmodifiableList(this.outcomesList);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }
}

