
<!-- README.md is generated from README.Rmd. Please edit that file -->

# ExactCIone

<!-- badges: start -->

An R package to construct the admissible exact intervals for the
binomial proportion, the poisson mean and the total number of subjects
with a certain attribute or the total number of the subjects for the
hypergeometric distribution. Both one-sided and two-sided intervals are
of interest. This package can be used to calculate the intervals
constructed methods developed by Wang (2014) and Wang (2015).
<!-- badges: end -->

## Installation

You can install the development version of ExactCIone like so:

``` r
library("devtools")
install_github("befrthunder/ExactCIone",dependencies =TRUE, build_vignettes = TRUE)
```

## Example

This is a basic example which shows you how to solve a common problem:

``` r
library(ExactCIone)
# For bin(n,p), construct 95% admissible CI for p on the observed sample x=2 when n=5.
WbinoCI(x=2,n=5,conf.level=0.95,details=TRUE)
#> $CI
#>      x     lower     upper
#> [1,] 2 0.0764403 0.8107447
#> 
#> $CIM
#>      x      lower     upper
#> [1,] 0 0.00000000 0.5000000
#> [2,] 1 0.01020614 0.6574084
#> [3,] 2 0.07644030 0.8107447
#> [4,] 3 0.18925530 0.9235597
#> [5,] 4 0.34259163 0.9897939
#> [6,] 5 0.49999997 1.0000000
#> 
#> $icp
#> [1] 0.95
WbinoCI(x=2,n=5,conf.level=0.95)
#> $CI
#>      x     lower     upper
#> [1,] 2 0.0764403 0.8107447
WbinoCI_lower(x=2,n=5,conf.level=0.95,details=TRUE)
#> $CI
#>      sample       lower upper
#> [1,]      0 0.000000000     1
#> [2,]      1 0.005050763     1
#> [3,]      2 0.052744951     1
#> [4,]      3 0.146632800     1
#> [5,]      4 0.283582064     1
#> [6,]      5 0.478176250     1
WbinoCI_lower(x=2,n=5,conf.level=0.95)
#> $CI
#>      sample      lower upper
#> [1,]      2 0.05274495     1
########################################################################
# For pois(lambda), construct 95% admissible CI for lambda on the observed sample x=3.
WpoisCI(x=3,details = TRUE)
#> $CI
#>      x     lower    upper
#> [1,] 3 0.8176914 8.395386
#> 
#> $CIM
#>      x      lower    upper
#> [1,] 0 0.00000000 3.453832
#> [2,] 1 0.05129329 5.491160
#> [3,] 2 0.35536150 6.921952
#> [4,] 3 0.81769144 8.395386
#> 
#> $icp
#> [1] 0.95
WpoisCI(x=1)
#> $CI
#>      x      lower   upper
#> [1,] 1 0.05129329 5.49116
WpoisCI_lower(x=1)
#> $CI
#>      sample               
#> [1,]      1 0.05129329 Inf
WpoisCI_lower(x=3,details = TRUE)
#> $CI
#>      x     lower upper
#> [1,] 3 0.8176914   Inf
#> 
#> $CIM
#>      sample      lower upper
#> [1,]      0 0.00000000   Inf
#> [2,]      1 0.05129329   Inf
#> [3,]      2 0.35536151   Inf
#> [4,]      3 0.81769145   Inf
WpoisCI_upper(x=1)
#> $CI
#>      sample           
#> [1,]      1 0 4.743865
WpoisCI_upper(x=3,details = TRUE)
#> $CI
#>      x lower    upper
#> [1,] 3     0 7.753657
#> 
#> $CIM
#>      sample lower    upper
#> [1,]      0     0 2.995732
#> [2,]      1     0 4.743865
#> [3,]      2     0 6.295794
#> [4,]      3     0 7.753657
#######################################################################
# For hyper(n,x,M,N-M), construct 95% admissible CI for N on the observed sample x=10 when n=50,M=800.
WhyperCI_N(10,50,800,0.95,details=TRUE)
#> $CI
#>       x lower upper
#> [1,] 10  2445  7955
#> 
#> $CIM
#>        x lower  upper
#>  [1,]  0 12572    Inf
#>  [2,]  1  7956 780253
#>  [3,]  2  6108 111784
#>  [4,]  3  4914  48296
#>  [5,]  4  4425  28760
#>  [6,]  5  3760  19857
#>  [7,]  6  3472  14911
#>  [8,]  7  3018  12571
#>  [9,]  8  2828  10875
#> [10,]  9  2657   8435
#> [11,] 10  2445   7955
#> [12,] 11  2243   6450
#> [13,] 12  2130   6107
#> [14,] 13  2026   5118
#> [15,] 14  1931   4913
#> [16,] 15  1844   4424
#> [17,] 16  1764   3938
#> [18,] 17  1689   3759
#> [19,] 18  1620   3471
#> [20,] 19  1555   3121
#> [21,] 20  1495   3017
#> [22,] 21  1439   2827
#> [23,] 22  1386   2656
#> [24,] 23  1336   2444
#> [25,] 24  1289   2321
#> [26,] 25  1255   2242
#> [27,] 26  1229   2129
#> [28,] 27  1200   2025
#> [29,] 28  1163   1930
#> [30,] 29  1125   1843
#> [31,] 30  1101   1763
#> [32,] 31  1082   1688
#> [33,] 32  1053   1619
#> [34,] 33  1020   1554
#> [35,] 34  1010   1494
#> [36,] 35   988   1438
#> [37,] 36   964   1385
#> [38,] 37   952   1335
#> [39,] 38   925   1288
#> [40,] 39   917   1231
#> [41,] 40   893   1199
#> [42,] 41   887   1162
#> [43,] 42   869   1124
#> [44,] 43   860   1081
#> [45,] 44   847   1052
#> [46,] 45   835   1019
#> [47,] 46   824    987
#> [48,] 47   815    951
#> [49,] 48   807    924
#> [50,] 49   801    892
#> [51,] 50   800    859
#> 
#> $icp
#> [1] 0.95
WhyperCI_N(50,50,800,0.95)
#> $CI
#>       x lower upper
#> [1,] 50   800   859
WhyperCI_N_lower(0,50,800,0.95,details=TRUE)
#> $CI
#>      sample lower upper
#> [1,]      0 13781   Inf
#> 
#> $CIM
#>       sample lower upper
#>  [1,]      0 13781   Inf
#>  [2,]      1  8772   Inf
#>  [3,]      2  6649   Inf
#>  [4,]      3  5426   Inf
#>  [5,]      4  4617   Inf
#>  [6,]      5  4036   Inf
#>  [7,]      6  3596   Inf
#>  [8,]      7  3251   Inf
#>  [9,]      8  2971   Inf
#> [10,]      9  2739   Inf
#> [11,]     10  2544   Inf
#> [12,]     11  2377   Inf
#> [13,]     12  2233   Inf
#> [14,]     13  2106   Inf
#> [15,]     14  1995   Inf
#> [16,]     15  1895   Inf
#> [17,]     16  1806   Inf
#> [18,]     17  1726   Inf
#> [19,]     18  1653   Inf
#> [20,]     19  1587   Inf
#> [21,]     20  1527   Inf
#> [22,]     21  1471   Inf
#> [23,]     22  1420   Inf
#> [24,]     23  1372   Inf
#> [25,]     24  1328   Inf
#> [26,]     25  1288   Inf
#> [27,]     26  1249   Inf
#> [28,]     27  1214   Inf
#> [29,]     28  1181   Inf
#> [30,]     29  1149   Inf
#> [31,]     30  1120   Inf
#> [32,]     31  1092   Inf
#> [33,]     32  1066   Inf
#> [34,]     33  1042   Inf
#> [35,]     34  1019   Inf
#> [36,]     35   997   Inf
#> [37,]     36   976   Inf
#> [38,]     37   957   Inf
#> [39,]     38   938   Inf
#> [40,]     39   921   Inf
#> [41,]     40   904   Inf
#> [42,]     41   889   Inf
#> [43,]     42   874   Inf
#> [44,]     43   860   Inf
#> [45,]     44   847   Inf
#> [46,]     45   835   Inf
#> [47,]     46   824   Inf
#> [48,]     47   815   Inf
#> [49,]     48   807   Inf
#> [50,]     49   801   Inf
#> [51,]     50   800   Inf
WhyperCI_N_lower(0,50,800,0.95)
#> $CI
#>      x          
#> [1,] 0 13781 Inf
WhyperCI_N_upper(0,50,800,0.95,details=TRUE)
#> $CI
#>      sample lower upper
#> [1,]      0     0   Inf
#> 
#> $CIM
#>       sample lower  upper
#>  [1,]      0     0    Inf
#>  [2,]      1     0 780253
#>  [3,]      2     0 111784
#>  [4,]      3     0  48296
#>  [5,]      4     0  28760
#>  [6,]      5     0  19857
#>  [7,]      6     0  14911
#>  [8,]      7     0  11814
#>  [9,]      8     0   9716
#> [10,]      9     0   8209
#> [11,]     10     0   7081
#> [12,]     11     0   6208
#> [13,]     12     0   5514
#> [14,]     13     0   4950
#> [15,]     14     0   4484
#> [16,]     15     0   4093
#> [17,]     16     0   3760
#> [18,]     17     0   3474
#> [19,]     18     0   3226
#> [20,]     19     0   3008
#> [21,]     20     0   2816
#> [22,]     21     0   2645
#> [23,]     22     0   2492
#> [24,]     23     0   2355
#> [25,]     24     0   2231
#> [26,]     25     0   2118
#> [27,]     26     0   2016
#> [28,]     27     0   1921
#> [29,]     28     0   1835
#> [30,]     29     0   1755
#> [31,]     30     0   1682
#> [32,]     31     0   1613
#> [33,]     32     0   1550
#> [34,]     33     0   1490
#> [35,]     34     0   1435
#> [36,]     35     0   1383
#> [37,]     36     0   1334
#> [38,]     37     0   1288
#> [39,]     38     0   1244
#> [40,]     39     0   1203
#> [41,]     40     0   1164
#> [42,]     41     0   1127
#> [43,]     42     0   1092
#> [44,]     43     0   1058
#> [45,]     44     0   1026
#> [46,]     45     0    995
#> [47,]     46     0    965
#> [48,]     47     0    936
#> [49,]     48     0    907
#> [50,]     49     0    878
#> [51,]     50     0    847
WhyperCI_N_upper(0,50,800,0.95)
#> $CI
#>      x      
#> [1,] 0 0 Inf
#######################################################################
# For hyper(n,x,M,N-M), construct 95% admissible CI for M on the observed sample x=0 when n=50, N=2000.
WhyperCI_M(0,50,2000,0.95,details = TRUE)
#> $CI
#>      X lower upper
#> [1,] 0     0   136
#> 
#> $CIM
#>        x lower upper
#>  [1,]  0     0   136
#>  [2,]  1     3   210
#>  [3,]  2    15   271
#>  [4,]  3    34   328
#>  [5,]  4    57   381
#>  [6,]  5    82   433
#>  [7,]  6   109   483
#>  [8,]  7   137   531
#>  [9,]  8   152   579
#> [10,]  9   192   625
#> [11,] 10   211   661
#> [12,] 11   251   715
#> [13,] 12   272   760
#> [14,] 13   315   803
#> [15,] 14   329   846
#> [16,] 15   382   888
#> [17,] 16   410   930
#> [18,] 17   434   971
#> [19,] 18   484  1000
#> [20,] 19   516  1028
#> [21,] 20   532  1069
#> [22,] 21   580  1111
#> [23,] 22   626  1153
#> [24,] 23   662  1196
#> [25,] 24   691  1239
#> [26,] 25   716  1284
#> [27,] 26   761  1309
#> [28,] 27   804  1338
#> [29,] 28   847  1374
#> [30,] 29   889  1420
#> [31,] 30   931  1468
#> [32,] 31   972  1484
#> [33,] 32  1000  1516
#> [34,] 33  1029  1566
#> [35,] 34  1070  1590
#> [36,] 35  1112  1618
#> [37,] 36  1154  1671
#> [38,] 37  1197  1685
#> [39,] 38  1240  1728
#> [40,] 39  1285  1749
#> [41,] 40  1339  1789
#> [42,] 41  1375  1808
#> [43,] 42  1421  1848
#> [44,] 43  1469  1863
#> [45,] 44  1517  1891
#> [46,] 45  1567  1918
#> [47,] 46  1619  1943
#> [48,] 47  1672  1966
#> [49,] 48  1729  1985
#> [50,] 49  1790  1997
#> [51,] 50  1864  2000
#> 
#> $CIM_p
#>          p lower_p upper_p
#>  [1,] 0.00  0.0000  0.0680
#>  [2,] 0.02  0.0015  0.1050
#>  [3,] 0.04  0.0075  0.1355
#>  [4,] 0.06  0.0170  0.1640
#>  [5,] 0.08  0.0285  0.1905
#>  [6,] 0.10  0.0410  0.2165
#>  [7,] 0.12  0.0545  0.2415
#>  [8,] 0.14  0.0685  0.2655
#>  [9,] 0.16  0.0760  0.2895
#> [10,] 0.18  0.0960  0.3125
#> [11,] 0.20  0.1055  0.3305
#> [12,] 0.22  0.1255  0.3575
#> [13,] 0.24  0.1360  0.3800
#> [14,] 0.26  0.1575  0.4015
#> [15,] 0.28  0.1645  0.4230
#> [16,] 0.30  0.1910  0.4440
#> [17,] 0.32  0.2050  0.4650
#> [18,] 0.34  0.2170  0.4855
#> [19,] 0.36  0.2420  0.5000
#> [20,] 0.38  0.2580  0.5140
#> [21,] 0.40  0.2660  0.5345
#> [22,] 0.42  0.2900  0.5555
#> [23,] 0.44  0.3130  0.5765
#> [24,] 0.46  0.3310  0.5980
#> [25,] 0.48  0.3455  0.6195
#> [26,] 0.50  0.3580  0.6420
#> [27,] 0.52  0.3805  0.6545
#> [28,] 0.54  0.4020  0.6690
#> [29,] 0.56  0.4235  0.6870
#> [30,] 0.58  0.4445  0.7100
#> [31,] 0.60  0.4655  0.7340
#> [32,] 0.62  0.4860  0.7420
#> [33,] 0.64  0.5000  0.7580
#> [34,] 0.66  0.5145  0.7830
#> [35,] 0.68  0.5350  0.7950
#> [36,] 0.70  0.5560  0.8090
#> [37,] 0.72  0.5770  0.8355
#> [38,] 0.74  0.5985  0.8425
#> [39,] 0.76  0.6200  0.8640
#> [40,] 0.78  0.6425  0.8745
#> [41,] 0.80  0.6695  0.8945
#> [42,] 0.82  0.6875  0.9040
#> [43,] 0.84  0.7105  0.9240
#> [44,] 0.86  0.7345  0.9315
#> [45,] 0.88  0.7585  0.9455
#> [46,] 0.90  0.7835  0.9590
#> [47,] 0.92  0.8095  0.9715
#> [48,] 0.94  0.8360  0.9830
#> [49,] 0.96  0.8645  0.9925
#> [50,] 0.98  0.8950  0.9985
#> [51,] 1.00  0.9320  1.0000
#> 
#> $icp
#> [1] 0.9500198
WhyperCI_M(0,50,2000,0.95)
#> $CI
#>      x lower upper
#> [1,] 0     0   136
#> 
#> $CI_p
#>      p lower upper
#> [1,] 0     0 0.068
WhyperCI_M_lower(0,50,2000,0.95,details = TRUE)
#> $CI
#>      X      N
#> [1,] 0 0 2000
#> 
#> $CIM
#>       sample lower upper
#>  [1,]      0     0  2000
#>  [2,]      1     3  2000
#>  [3,]      2    15  2000
#>  [4,]      3    34  2000
#>  [5,]      4    57  2000
#>  [6,]      5    82  2000
#>  [7,]      6   109  2000
#>  [8,]      7   137  2000
#>  [9,]      8   166  2000
#> [10,]      9   197  2000
#> [11,]     10   228  2000
#> [12,]     11   259  2000
#> [13,]     12   292  2000
#> [14,]     13   325  2000
#> [15,]     14   358  2000
#> [16,]     15   393  2000
#> [17,]     16   427  2000
#> [18,]     17   462  2000
#> [19,]     18   497  2000
#> [20,]     19   533  2000
#> [21,]     20   569  2000
#> [22,]     21   606  2000
#> [23,]     22   643  2000
#> [24,]     23   680  2000
#> [25,]     24   718  2000
#> [26,]     25   756  2000
#> [27,]     26   794  2000
#> [28,]     27   833  2000
#> [29,]     28   872  2000
#> [30,]     29   911  2000
#> [31,]     30   951  2000
#> [32,]     31   991  2000
#> [33,]     32  1032  2000
#> [34,]     33  1073  2000
#> [35,]     34  1114  2000
#> [36,]     35  1156  2000
#> [37,]     36  1198  2000
#> [38,]     37  1241  2000
#> [39,]     38  1284  2000
#> [40,]     39  1328  2000
#> [41,]     40  1372  2000
#> [42,]     41  1417  2000
#> [43,]     42  1463  2000
#> [44,]     43  1509  2000
#> [45,]     44  1557  2000
#> [46,]     45  1605  2000
#> [47,]     46  1655  2000
#> [48,]     47  1707  2000
#> [49,]     48  1761  2000
#> [50,]     49  1819  2000
#> [51,]     50  1886  2000
WhyperCI_M_lower(0,50,2000,0.95)
#> $CI
#>      X      N
#> [1,] 0 0 2000
WhyperCI_M_upper(0,50,2000,0.95,details = TRUE)
#> $CI
#>      X      
#> [1,] 0 0 114
#> 
#> $CIM
#>       sample lower upper
#>  [1,]      0     0   114
#>  [2,]      1     0   181
#>  [3,]      2     0   239
#>  [4,]      3     0   293
#>  [5,]      4     0   345
#>  [6,]      5     0   395
#>  [7,]      6     0   443
#>  [8,]      7     0   491
#>  [9,]      8     0   537
#> [10,]      9     0   583
#> [11,]     10     0   628
#> [12,]     11     0   672
#> [13,]     12     0   716
#> [14,]     13     0   759
#> [15,]     14     0   802
#> [16,]     15     0   844
#> [17,]     16     0   886
#> [18,]     17     0   927
#> [19,]     18     0   968
#> [20,]     19     0  1009
#> [21,]     20     0  1049
#> [22,]     21     0  1089
#> [23,]     22     0  1128
#> [24,]     23     0  1167
#> [25,]     24     0  1206
#> [26,]     25     0  1244
#> [27,]     26     0  1282
#> [28,]     27     0  1320
#> [29,]     28     0  1357
#> [30,]     29     0  1394
#> [31,]     30     0  1431
#> [32,]     31     0  1467
#> [33,]     32     0  1503
#> [34,]     33     0  1538
#> [35,]     34     0  1573
#> [36,]     35     0  1607
#> [37,]     36     0  1642
#> [38,]     37     0  1675
#> [39,]     38     0  1708
#> [40,]     39     0  1741
#> [41,]     40     0  1772
#> [42,]     41     0  1803
#> [43,]     42     0  1834
#> [44,]     43     0  1863
#> [45,]     44     0  1891
#> [46,]     45     0  1918
#> [47,]     46     0  1943
#> [48,]     47     0  1966
#> [49,]     48     0  1985
#> [50,]     49     0  1997
#> [51,]     50     0  2000
WhyperCI_M_upper(0,50,2000,0.95)
#> $CI
#>      X      
#> [1,] 0 0 114
## basic example code
```
