/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint.algo;

import cern.colt.GenericSorting;
import cern.colt.PersistentObject;
import cern.colt.Swapper;
import cern.colt.function.tint.IntComparator;
import cern.colt.list.tobject.ObjectArrayList;
import cern.colt.matrix.AbstractFormatter;
import cern.colt.matrix.tint.IntFactory2D;
import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.IntMatrix3D;
import cern.jet.math.tint.IntFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class IntProperty
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    public static final IntProperty DEFAULT = new IntProperty();

    protected static String blanks(int n) {
        if (n < 0) {
            n = 0;
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public void checkRectangular(IntMatrix2D intMatrix2D) {
        if (intMatrix2D.rows() < intMatrix2D.columns()) {
            throw new IllegalArgumentException("Matrix must be rectangular: " + AbstractFormatter.shape(intMatrix2D));
        }
    }

    public void checkSquare(IntMatrix2D intMatrix2D) {
        if (intMatrix2D.rows() != intMatrix2D.columns()) {
            throw new IllegalArgumentException("Matrix must be square: " + AbstractFormatter.shape(intMatrix2D));
        }
    }

    public int density(IntMatrix2D intMatrix2D) {
        return intMatrix2D.cardinality() / (int)intMatrix2D.size();
    }

    public boolean equals(final IntMatrix1D intMatrix1D, final int n) {
        if (intMatrix1D == null) {
            return false;
        }
        int n2 = (int)intMatrix1D.size();
        boolean bl = false;
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && n2 >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int n4;
            n3 = Math.min(n3, n2);
            Future[] futureArray = new Future[n3];
            Boolean[] booleanArray = new Boolean[n3];
            int n5 = n2 / n3;
            for (n4 = 0; n4 < n3; ++n4) {
                final int n6 = n4 * n5;
                final int n7 = n4 == n3 - 1 ? n2 : n6 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        for (int i = n6; i < n7; ++i) {
                            if (intMatrix1D.getQuick(i) == n) continue;
                            return false;
                        }
                        return true;
                    }
                });
            }
            try {
                for (n4 = 0; n4 < n3; ++n4) {
                    booleanArray[n4] = (Boolean)futureArray[n4].get();
                }
                bl = booleanArray[0];
                for (n4 = 1; n4 < n3; ++n4) {
                    bl = bl && booleanArray[n4] != false;
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            return bl;
        }
        for (int i = 0; i < n2; ++i) {
            if (intMatrix1D.getQuick(i) == n) continue;
            return false;
        }
        return true;
    }

    public boolean equals(final IntMatrix1D intMatrix1D, final IntMatrix1D intMatrix1D2) {
        if (intMatrix1D == intMatrix1D2) {
            return true;
        }
        if (intMatrix1D == null || intMatrix1D2 == null) {
            return false;
        }
        int n = (int)intMatrix1D.size();
        if ((long)n != intMatrix1D2.size()) {
            return false;
        }
        boolean bl = false;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int n3;
            n2 = Math.min(n2, n);
            Future[] futureArray = new Future[n2];
            Boolean[] booleanArray = new Boolean[n2];
            int n4 = n / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = n3 * n4;
                final int n6 = n3 == n2 - 1 ? n : n5 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        for (int i = n5; i < n6; ++i) {
                            if (intMatrix1D.getQuick(i) == intMatrix1D2.getQuick(i)) continue;
                            return false;
                        }
                        return true;
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    booleanArray[n3] = (Boolean)futureArray[n3].get();
                }
                bl = booleanArray[0];
                for (n3 = 1; n3 < n2; ++n3) {
                    bl = bl && booleanArray[n3] != false;
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            return bl;
        }
        for (int i = 0; i < n; ++i) {
            if (intMatrix1D.getQuick(i) == intMatrix1D2.getQuick(i)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(final IntMatrix2D intMatrix2D, final int n) {
        if (intMatrix2D == null) {
            return false;
        }
        int n2 = intMatrix2D.rows();
        final int n3 = intMatrix2D.columns();
        boolean bl = false;
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && intMatrix2D.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n5;
            n4 = Math.min(n4, intMatrix2D.rows());
            Future[] futureArray = new Future[n4];
            Boolean[] booleanArray = new Boolean[n4];
            int n6 = intMatrix2D.rows() / n4;
            for (n5 = 0; n5 < n4; ++n5) {
                final int n7 = n5 * n6;
                final int n8 = n5 == n4 - 1 ? intMatrix2D.rows() : n7 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        for (int i = n7; i < n8; ++i) {
                            for (int j = 0; j < n3; ++j) {
                                if (intMatrix2D.getQuick(i, j) == n) continue;
                                return false;
                            }
                        }
                        return true;
                    }
                });
            }
            try {
                for (n5 = 0; n5 < n4; ++n5) {
                    booleanArray[n5] = (Boolean)futureArray[n5].get();
                }
                bl = booleanArray[0];
                for (n5 = 1; n5 < n4; ++n5) {
                    bl = bl && booleanArray[n5] != false;
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            return bl;
        }
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                if (intMatrix2D.getQuick(i, j) == n) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(final IntMatrix2D intMatrix2D, final IntMatrix2D intMatrix2D2) {
        if (intMatrix2D == intMatrix2D2) {
            return true;
        }
        if (intMatrix2D == null || intMatrix2D2 == null) {
            return false;
        }
        int n = intMatrix2D.rows();
        final int n2 = intMatrix2D.columns();
        if (n2 != intMatrix2D2.columns() || n != intMatrix2D2.rows()) {
            return false;
        }
        boolean bl = false;
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && intMatrix2D.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n4;
            n3 = Math.min(n3, intMatrix2D.rows());
            Future[] futureArray = new Future[n3];
            Boolean[] booleanArray = new Boolean[n3];
            int n5 = intMatrix2D.rows() / n3;
            for (n4 = 0; n4 < n3; ++n4) {
                final int n6 = n4 * n5;
                final int n7 = n4 == n3 - 1 ? intMatrix2D.rows() : n6 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        for (int i = n6; i < n7; ++i) {
                            for (int j = 0; j < n2; ++j) {
                                if (intMatrix2D.getQuick(i, j) == intMatrix2D2.getQuick(i, j)) continue;
                                return false;
                            }
                        }
                        return true;
                    }
                });
            }
            try {
                for (n4 = 0; n4 < n3; ++n4) {
                    booleanArray[n4] = (Boolean)futureArray[n4].get();
                }
                bl = booleanArray[0];
                for (n4 = 1; n4 < n3; ++n4) {
                    bl = bl && booleanArray[n4] != false;
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            return bl;
        }
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (intMatrix2D.getQuick(i, j) == intMatrix2D2.getQuick(i, j)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(final IntMatrix3D intMatrix3D, final int n) {
        if (intMatrix3D == null) {
            return false;
        }
        int n2 = intMatrix3D.slices();
        final int n3 = intMatrix3D.rows();
        final int n4 = intMatrix3D.columns();
        boolean bl = false;
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && intMatrix3D.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            int n6;
            n5 = Math.min(n5, n2);
            Future[] futureArray = new Future[n5];
            Boolean[] booleanArray = new Boolean[n5];
            int n7 = n2 / n5;
            for (n6 = 0; n6 < n5; ++n6) {
                final int n8 = n6 * n7;
                final int n9 = n6 == n5 - 1 ? n2 : n8 + n7;
                futureArray[n6] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        for (int i = n8; i < n9; ++i) {
                            for (int j = 0; j < n3; ++j) {
                                for (int k = 0; k < n4; ++k) {
                                    if (intMatrix3D.getQuick(i, j, k) == n) continue;
                                    return false;
                                }
                            }
                        }
                        return true;
                    }
                });
            }
            try {
                for (n6 = 0; n6 < n5; ++n6) {
                    booleanArray[n6] = (Boolean)futureArray[n6].get();
                }
                bl = booleanArray[0];
                for (n6 = 1; n6 < n5; ++n6) {
                    bl = bl && booleanArray[n6] != false;
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            return bl;
        }
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                for (int k = 0; k < n4; ++k) {
                    if (intMatrix3D.getQuick(i, j, k) == n) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean equals(final IntMatrix3D intMatrix3D, final IntMatrix3D intMatrix3D2) {
        if (intMatrix3D == intMatrix3D2) {
            return true;
        }
        if (intMatrix3D == null || intMatrix3D2 == null) {
            return false;
        }
        int n = intMatrix3D.slices();
        final int n2 = intMatrix3D.rows();
        final int n3 = intMatrix3D.columns();
        if (n3 != intMatrix3D2.columns() || n2 != intMatrix3D2.rows() || n != intMatrix3D2.slices()) {
            return false;
        }
        boolean bl = false;
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && intMatrix3D.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            int n5;
            n4 = Math.min(n4, n);
            Future[] futureArray = new Future[n4];
            Boolean[] booleanArray = new Boolean[n4];
            int n6 = n / n4;
            for (n5 = 0; n5 < n4; ++n5) {
                final int n7 = n5 * n6;
                final int n8 = n5 == n4 - 1 ? n : n7 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        for (int i = n7; i < n8; ++i) {
                            for (int j = 0; j < n2; ++j) {
                                for (int k = 0; k < n3; ++k) {
                                    if (intMatrix3D.getQuick(i, j, k) == intMatrix3D2.getQuick(i, j, k)) continue;
                                    return false;
                                }
                            }
                        }
                        return true;
                    }
                });
            }
            try {
                for (n5 = 0; n5 < n4; ++n5) {
                    booleanArray[n5] = (Boolean)futureArray[n5].get();
                }
                bl = booleanArray[0];
                for (n5 = 1; n5 < n4; ++n5) {
                    bl = bl && booleanArray[n5] != false;
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            return bl;
        }
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    if (intMatrix3D.getQuick(i, j, k) == intMatrix3D2.getQuick(i, j, k)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void generateNonSingular(IntMatrix2D intMatrix2D) {
        int n;
        this.checkSquare(intMatrix2D);
        IntFunctions intFunctions = IntFunctions.intFunctions;
        int n2 = n = Math.min(intMatrix2D.rows(), intMatrix2D.columns());
        while (--n2 >= 0) {
            intMatrix2D.setQuick(n2, n2, 0);
        }
        n2 = n;
        while (--n2 >= 0) {
            int n3 = intMatrix2D.viewRow(n2).aggregate(IntFunctions.plus, IntFunctions.abs);
            int n4 = intMatrix2D.viewColumn(n2).aggregate(IntFunctions.plus, IntFunctions.abs);
            intMatrix2D.setQuick(n2, n2, Math.max(n3, n4) + n2 + 1);
        }
    }

    protected static String get(ObjectArrayList objectArrayList, int n) {
        return (String)objectArrayList.get(n);
    }

    public boolean isDiagonal(IntMatrix2D intMatrix2D) {
        int n = intMatrix2D.rows();
        int n2 = intMatrix2D.columns();
        int n3 = n;
        while (--n3 >= 0) {
            int n4 = n2;
            while (--n4 >= 0) {
                if (n3 == n4 || intMatrix2D.getQuick(n3, n4) == 0) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isDiagonallyDominantByColumn(IntMatrix2D intMatrix2D) {
        int n;
        IntFunctions intFunctions = IntFunctions.intFunctions;
        int n2 = n = Math.min(intMatrix2D.rows(), intMatrix2D.columns());
        while (--n2 >= 0) {
            int n3 = Math.abs(intMatrix2D.getQuick(n2, n2));
            if ((n3 += n3) > intMatrix2D.viewColumn(n2).aggregate(IntFunctions.plus, IntFunctions.abs)) continue;
            return false;
        }
        return true;
    }

    public boolean isDiagonallyDominantByRow(IntMatrix2D intMatrix2D) {
        int n;
        IntFunctions intFunctions = IntFunctions.intFunctions;
        int n2 = n = Math.min(intMatrix2D.rows(), intMatrix2D.columns());
        while (--n2 >= 0) {
            int n3 = Math.abs(intMatrix2D.getQuick(n2, n2));
            if ((n3 += n3) > intMatrix2D.viewRow(n2).aggregate(IntFunctions.plus, IntFunctions.abs)) continue;
            return false;
        }
        return true;
    }

    public boolean isIdentity(IntMatrix2D intMatrix2D) {
        int n = intMatrix2D.rows();
        int n2 = intMatrix2D.columns();
        int n3 = n;
        while (--n3 >= 0) {
            int n4 = n2;
            while (--n4 >= 0) {
                int n5 = intMatrix2D.getQuick(n3, n4);
                if (!(n3 == n4 ? n5 != 1 : n5 != 0)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isLowerBidiagonal(IntMatrix2D intMatrix2D) {
        int n = intMatrix2D.rows();
        int n2 = intMatrix2D.columns();
        int n3 = n;
        while (--n3 >= 0) {
            int n4 = n2;
            while (--n4 >= 0) {
                if (n3 == n4 || n3 == n4 + 1 || intMatrix2D.getQuick(n3, n4) == 0) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isLowerTriangular(IntMatrix2D intMatrix2D) {
        int n;
        int n2 = intMatrix2D.rows();
        int n3 = n = intMatrix2D.columns();
        while (--n3 >= 0) {
            int n4 = Math.min(n3, n2);
            while (--n4 >= 0) {
                if (intMatrix2D.getQuick(n4, n3) == 0) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isNonNegative(IntMatrix2D intMatrix2D) {
        int n = intMatrix2D.rows();
        int n2 = intMatrix2D.columns();
        int n3 = n;
        while (--n3 >= 0) {
            int n4 = n2;
            while (--n4 >= 0) {
                if (intMatrix2D.getQuick(n3, n4) >= 0) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isOrthogonal(IntMatrix2D intMatrix2D) {
        this.checkSquare(intMatrix2D);
        return this.equals(intMatrix2D.zMult(intMatrix2D, null, 1, 0, false, true), IntFactory2D.dense.identity(intMatrix2D.rows()));
    }

    public boolean isPositive(IntMatrix2D intMatrix2D) {
        int n = intMatrix2D.rows();
        int n2 = intMatrix2D.columns();
        int n3 = n;
        while (--n3 >= 0) {
            int n4 = n2;
            while (--n4 >= 0) {
                if (intMatrix2D.getQuick(n3, n4) > 0) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isSkewSymmetric(IntMatrix2D intMatrix2D) {
        this.checkSquare(intMatrix2D);
        int n = intMatrix2D.rows();
        int n2 = intMatrix2D.columns();
        int n3 = n;
        while (--n3 >= 0) {
            int n4 = n;
            while (--n4 >= 0) {
                if (intMatrix2D.getQuick(n3, n4) == -intMatrix2D.getQuick(n4, n3)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isSquare(IntMatrix2D intMatrix2D) {
        return intMatrix2D.rows() == intMatrix2D.columns();
    }

    public boolean isStrictlyLowerTriangular(IntMatrix2D intMatrix2D) {
        int n;
        int n2 = intMatrix2D.rows();
        int n3 = n = intMatrix2D.columns();
        while (--n3 >= 0) {
            int n4 = Math.min(n2, n3 + 1);
            while (--n4 >= 0) {
                if (intMatrix2D.getQuick(n4, n3) == 0) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isStrictlyTriangular(IntMatrix2D intMatrix2D) {
        if (!this.isTriangular(intMatrix2D)) {
            return false;
        }
        int n = Math.min(intMatrix2D.rows(), intMatrix2D.columns());
        while (--n >= 0) {
            if (intMatrix2D.getQuick(n, n) == 0) continue;
            return false;
        }
        return true;
    }

    public boolean isStrictlyUpperTriangular(IntMatrix2D intMatrix2D) {
        int n;
        int n2 = intMatrix2D.rows();
        int n3 = n = intMatrix2D.columns();
        while (--n3 >= 0) {
            int n4 = n2;
            while (--n4 >= n3) {
                if (intMatrix2D.getQuick(n4, n3) == 0) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isSymmetric(IntMatrix2D intMatrix2D) {
        this.checkSquare(intMatrix2D);
        return this.equals(intMatrix2D, intMatrix2D.viewDice());
    }

    public boolean isTriangular(IntMatrix2D intMatrix2D) {
        return this.isLowerTriangular(intMatrix2D) || this.isUpperTriangular(intMatrix2D);
    }

    public boolean isTridiagonal(IntMatrix2D intMatrix2D) {
        int n = intMatrix2D.rows();
        int n2 = intMatrix2D.columns();
        int n3 = n;
        while (--n3 >= 0) {
            int n4 = n2;
            while (--n4 >= 0) {
                if (Math.abs(n3 - n4) <= 1 || intMatrix2D.getQuick(n3, n4) == 0) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isUnitTriangular(IntMatrix2D intMatrix2D) {
        if (!this.isTriangular(intMatrix2D)) {
            return false;
        }
        int n = Math.min(intMatrix2D.rows(), intMatrix2D.columns());
        while (--n >= 0) {
            if (intMatrix2D.getQuick(n, n) == 1) continue;
            return false;
        }
        return true;
    }

    public boolean isUpperBidiagonal(IntMatrix2D intMatrix2D) {
        int n = intMatrix2D.rows();
        int n2 = intMatrix2D.columns();
        int n3 = n;
        while (--n3 >= 0) {
            int n4 = n2;
            while (--n4 >= 0) {
                if (n3 == n4 || n3 == n4 - 1 || intMatrix2D.getQuick(n3, n4) == 0) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isUpperTriangular(IntMatrix2D intMatrix2D) {
        int n;
        int n2 = intMatrix2D.rows();
        int n3 = n = intMatrix2D.columns();
        while (--n3 >= 0) {
            int n4 = n2;
            while (--n4 > n3) {
                if (intMatrix2D.getQuick(n4, n3) == 0) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isZero(IntMatrix2D intMatrix2D) {
        return this.equals(intMatrix2D, 0);
    }

    public int lowerBandwidth(IntMatrix2D intMatrix2D) {
        int n;
        this.checkSquare(intMatrix2D);
        int n2 = n = intMatrix2D.rows();
        while (--n2 >= 0) {
            int n3 = n - n2;
            while (--n3 >= 0) {
                int n4 = n3 + n2;
                if (intMatrix2D.getQuick(n4, n3) == 0) continue;
                return n2;
            }
        }
        return 0;
    }

    public int semiBandwidth(IntMatrix2D intMatrix2D) {
        int n;
        this.checkSquare(intMatrix2D);
        int n2 = n = intMatrix2D.rows();
        while (--n2 >= 0) {
            int n3 = n - n2;
            while (--n3 >= 0) {
                int n4 = n3 + n2;
                if (intMatrix2D.getQuick(n4, n3) != 0) {
                    return n2 + 1;
                }
                if (intMatrix2D.getQuick(n3, n4) == 0) continue;
                return n2 + 1;
            }
        }
        return 1;
    }

    public String toString(IntMatrix2D intMatrix2D) {
        int n;
        final ObjectArrayList objectArrayList = new ObjectArrayList();
        final ObjectArrayList objectArrayList2 = new ObjectArrayList();
        String string = "Illegal operation or error: ";
        objectArrayList.add("density");
        try {
            objectArrayList2.add(String.valueOf(this.density(intMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isDiagonal");
        try {
            objectArrayList2.add(String.valueOf(this.isDiagonal(intMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isDiagonallyDominantByRow");
        try {
            objectArrayList2.add(String.valueOf(this.isDiagonallyDominantByRow(intMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isDiagonallyDominantByColumn");
        try {
            objectArrayList2.add(String.valueOf(this.isDiagonallyDominantByColumn(intMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isIdentity");
        try {
            objectArrayList2.add(String.valueOf(this.isIdentity(intMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isLowerBidiagonal");
        try {
            objectArrayList2.add(String.valueOf(this.isLowerBidiagonal(intMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isLowerTriangular");
        try {
            objectArrayList2.add(String.valueOf(this.isLowerTriangular(intMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isNonNegative");
        try {
            objectArrayList2.add(String.valueOf(this.isNonNegative(intMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isOrthogonal");
        try {
            objectArrayList2.add(String.valueOf(this.isOrthogonal(intMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isPositive");
        try {
            objectArrayList2.add(String.valueOf(this.isPositive(intMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isSkewSymmetric");
        try {
            objectArrayList2.add(String.valueOf(this.isSkewSymmetric(intMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isSquare");
        try {
            objectArrayList2.add(String.valueOf(this.isSquare(intMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isStrictlyLowerTriangular");
        try {
            objectArrayList2.add(String.valueOf(this.isStrictlyLowerTriangular(intMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isStrictlyTriangular");
        try {
            objectArrayList2.add(String.valueOf(this.isStrictlyTriangular(intMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isStrictlyUpperTriangular");
        try {
            objectArrayList2.add(String.valueOf(this.isStrictlyUpperTriangular(intMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isSymmetric");
        try {
            objectArrayList2.add(String.valueOf(this.isSymmetric(intMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isTriangular");
        try {
            objectArrayList2.add(String.valueOf(this.isTriangular(intMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isTridiagonal");
        try {
            objectArrayList2.add(String.valueOf(this.isTridiagonal(intMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isUnitTriangular");
        try {
            objectArrayList2.add(String.valueOf(this.isUnitTriangular(intMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isUpperBidiagonal");
        try {
            objectArrayList2.add(String.valueOf(this.isUpperBidiagonal(intMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isUpperTriangular");
        try {
            objectArrayList2.add(String.valueOf(this.isUpperTriangular(intMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isZero");
        try {
            objectArrayList2.add(String.valueOf(this.isZero(intMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("lowerBandwidth");
        try {
            objectArrayList2.add(String.valueOf(this.lowerBandwidth(intMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("semiBandwidth");
        try {
            objectArrayList2.add(String.valueOf(this.semiBandwidth(intMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("upperBandwidth");
        try {
            objectArrayList2.add(String.valueOf(this.upperBandwidth(intMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        IntComparator intComparator = new IntComparator(){

            public int compare(int n, int n2) {
                return IntProperty.get(objectArrayList, n).compareTo(IntProperty.get(objectArrayList, n2));
            }
        };
        Swapper swapper = new Swapper(){

            public void swap(int n, int n2) {
                Object object = objectArrayList.get(n);
                objectArrayList.set(n, objectArrayList.get(n2));
                objectArrayList.set(n2, object);
                object = objectArrayList2.get(n);
                objectArrayList2.set(n, objectArrayList2.get(n2));
                objectArrayList2.set(n2, object);
            }
        };
        GenericSorting.quickSort(0, objectArrayList.size(), intComparator, swapper);
        int n2 = 0;
        for (int i = 0; i < objectArrayList.size(); ++i) {
            n = ((String)objectArrayList.get(i)).length();
            n2 = Math.max(n, n2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < objectArrayList.size(); ++n) {
            String string2 = (String)objectArrayList.get(n);
            stringBuffer.append(string2);
            stringBuffer.append(IntProperty.blanks(n2 - string2.length()));
            stringBuffer.append(" : ");
            stringBuffer.append(objectArrayList2.get(n));
            if (n >= objectArrayList.size() - 1) continue;
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public int upperBandwidth(IntMatrix2D intMatrix2D) {
        int n;
        this.checkSquare(intMatrix2D);
        int n2 = n = intMatrix2D.rows();
        while (--n2 >= 0) {
            int n3 = n - n2;
            while (--n3 >= 0) {
                int n4 = n3 + n2;
                if (intMatrix2D.getQuick(n3, n4) == 0) continue;
                return n2;
            }
        }
        return 0;
    }
}

