## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  eval = identical(Sys.getenv("NOT_CRAN"), "true")
)

## ----setup--------------------------------------------------------------------
# library(fwtraits)

## ----data---------------------------------------------------------------------
# 
# data("speciesdata")
# 
# set.seed(1135)
# speciesdata$abund <- rnorm(n = nrow(speciesdata), 4.3, 1.2)
# 
# #species with geographical coordinates
# 
# geospdata <- speciesdata |>
#   sf::st_as_sf(coords = c('decimalLongitude', 'decimalLatitude'),
#                crs = sf::st_crs(4326))
# 

## ----dataretrieval------------------------------------------------------------
# 
# fishtraits <- fw_fetchdata(data = speciesdata,
#                          ecoparams = c('rheophily habitat', 'spawning habitat',
#                                        'feeding diet adult'),
#                          taxonomic_column = 'scientificName',
#                          organismgroup = 'fi')
# 

## ----visualisation, fig.width = 7, fig.height= 5.5, fig.align='center', warning=FALSE----
# 
# 
# fdendoclust <- fw_fdendro(fwdata = fishtraits, plot = TRUE)
# 
# head(fdendoclust, 3)
# 
# table(fdendoclust$cluster)
# 

