# polarzonoid

This is the git repository for the package **polarzonoid** on
[CRAN](https://cran.r-project.org/package=polarzonoid).

<br>

### Overview

In each odd dimension is a convex body - the _polar zonoid_ - whose generating functions
are trigonometric polynomials.
The polar zonoid is a straightforward generalization of the polar zonohedron in dimension 3,
as defined by [Chilton and Coxeter (1963)](<https://doi.org/10.2307/2313051>).
The package has some applications of the polar zonoid,
including the properties of configuration spaces of arcs on the circle and 3x3 rotation matrices.
There is also a root solver for trigonometric polynomials.

In other contexts, i.e. the theory of convex bodies,
the term "polar zonoid" is short for "polar of a zonoid",
which is an entirely different concept.

<br>

### Installation

``` r
install.packages("polarzonoid")
```


<br>

### Getting help

If you encounter a bug, please file an issue with a minimal reproducible example on
[GitHub](https://github.com/glenndavis52/polarzonoid/issues).
Or, write me using my email address
on the [CRAN page](https://cran.r-project.org/package=polarzonoid) for the package.

