/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.group;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.openscience.cdk.group.Invariant;
import org.openscience.cdk.group.Partition;
import org.openscience.cdk.group.Refinable;

class EquitablePartitionRefiner {
    private final Refinable refinable;
    private SplitOrder splitOrder = SplitOrder.FORWARD;
    private int currentBlockIndex;
    private Queue<Set<Integer>> blocksToRefine;

    public EquitablePartitionRefiner(Refinable refinable) {
        this.refinable = refinable;
    }

    public void setSplitOrder(SplitOrder splitOrder) {
        this.splitOrder = splitOrder;
    }

    public Partition refine(Partition coarser) {
        Partition finer = new Partition(coarser);
        this.blocksToRefine = new LinkedList<Set<Integer>>();
        for (int i = 0; i < finer.size(); ++i) {
            this.blocksToRefine.add(finer.copyBlock(i));
        }
        int numberOfVertices = this.refinable.getVertexCount();
        while (!this.blocksToRefine.isEmpty()) {
            Set<Integer> t = this.blocksToRefine.remove();
            this.currentBlockIndex = 0;
            while (this.currentBlockIndex < finer.size() && finer.size() < numberOfVertices) {
                if (!finer.isDiscreteCell(this.currentBlockIndex)) {
                    Map<Invariant, SortedSet<Integer>> invariants = this.getInvariants(finer, t);
                    this.split(invariants, finer);
                }
                ++this.currentBlockIndex;
            }
            if (finer.size() != numberOfVertices) continue;
            return finer;
        }
        return finer;
    }

    private Map<Invariant, SortedSet<Integer>> getInvariants(Partition partition, Set<Integer> targetBlock) {
        HashMap<Invariant, SortedSet<Integer>> setList = new HashMap<Invariant, SortedSet<Integer>>();
        Iterator iterator = partition.getCell(this.currentBlockIndex).iterator();
        while (iterator.hasNext()) {
            int u = (Integer)iterator.next();
            Invariant h = this.refinable.neighboursInBlock(targetBlock, u);
            if (setList.containsKey(h)) {
                ((SortedSet)setList.get(h)).add(u);
                continue;
            }
            TreeSet<Integer> set = new TreeSet<Integer>();
            set.add(u);
            setList.put(h, set);
        }
        return setList;
    }

    private void split(Map<Invariant, SortedSet<Integer>> invariants, Partition partition) {
        int nonEmptyInvariants = invariants.keySet().size();
        if (nonEmptyInvariants > 1) {
            ArrayList<Invariant> invariantKeys = new ArrayList<Invariant>(invariants.keySet());
            partition.removeCell(this.currentBlockIndex);
            int k = this.currentBlockIndex;
            if (this.splitOrder == SplitOrder.REVERSE) {
                Collections.sort(invariantKeys);
            } else {
                invariantKeys.sort(Collections.reverseOrder());
            }
            for (Invariant h : invariantKeys) {
                SortedSet<Integer> setH = invariants.get(h);
                partition.insertCell(k, setH);
                this.blocksToRefine.add(setH);
                ++k;
            }
            this.currentBlockIndex += nonEmptyInvariants - 1;
        }
    }

    public static enum SplitOrder {
        FORWARD,
        REVERSE;

    }
}

