/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries;

import java.time.LocalDate;
import jdplus.toolkit.base.api.timeseries.Day;
import jdplus.toolkit.base.api.timeseries.TimeSeriesObs;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class DayObs
implements TimeSeriesObs<Day> {
    @NonNull
    private final LocalDate date;
    private final double value;

    @Override
    @NonNull
    public Day getPeriod() {
        return Day.of(this.date);
    }

    @NonNull
    public static DayObs parse(@NonNull CharSequence text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        int index = text.toString().indexOf("=");
        if (index < 0) {
            throw new IllegalArgumentException("Invalid DayObs text: " + String.valueOf(text));
        }
        return DayObs.of(Day.parse(text.subSequence(0, index)).getDay(), Double.parseDouble(text.subSequence(index + 1, text.length()).toString()));
    }

    public String toString() {
        return String.valueOf(this.getPeriod()) + "=" + this.value;
    }

    @Generated
    private DayObs(@NonNull LocalDate date, double value) {
        if (date == null) {
            throw new NullPointerException("date is marked non-null but is null");
        }
        this.date = date;
        this.value = value;
    }

    @Generated
    public static @org.jspecify.annotations.NonNull DayObs of(@NonNull LocalDate date, double value) {
        if (date == null) {
            throw new NullPointerException("date is marked non-null but is null");
        }
        return new DayObs(date, value);
    }

    @NonNull
    @Generated
    public LocalDate getDate() {
        return this.date;
    }

    @Override
    @Generated
    public double getValue() {
        return this.value;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DayObs)) {
            return false;
        }
        DayObs other = (DayObs)o;
        if (Double.compare(this.getValue(), other.getValue()) != 0) {
            return false;
        }
        LocalDate this$date = this.getDate();
        LocalDate other$date = other.getDate();
        return !(this$date == null ? other$date != null : !((Object)this$date).equals(other$date));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $value = Double.doubleToLongBits(this.getValue());
        result = result * 59 + (int)($value >>> 32 ^ $value);
        LocalDate $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        return result;
    }
}

