/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries.regression;

import java.util.Arrays;
import jdplus.toolkit.base.api.timeseries.TimeSeriesDomain;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsDataSupplier;
import jdplus.toolkit.base.api.timeseries.regression.ITsVariable;
import jdplus.toolkit.base.api.timeseries.regression.ModellingContext;

public class TsVariables
implements ITsVariable {
    private final String gdesc;
    private final String[] id;
    private final TsData[] data;
    private final String[] desc;

    protected static TsData[] data(String[] id, ModellingContext context) {
        TsData[] data = new TsData[id.length];
        for (int i = 0; i < id.length; ++i) {
            TsDataSupplier supplier = context.getTsVariable(id[i]);
            if (supplier == null) {
                return null;
            }
            TsData cur = supplier.get();
            if (cur == null) {
                return null;
            }
            data[i] = cur;
        }
        return data;
    }

    protected TsVariables(String gdesc, String[] id, TsData[] data, String[] desc) {
        this.gdesc = gdesc;
        this.id = (String[])id.clone();
        this.data = data;
        this.desc = desc;
    }

    @Override
    public int dim() {
        return this.id.length;
    }

    @Override
    public <D extends TimeSeriesDomain<?>> String description(D context) {
        return this.gdesc;
    }

    @Override
    public <D extends TimeSeriesDomain<?>> String description(int idx, D context) {
        return this.desc == null ? this.gdesc + (idx + 1) : this.desc[idx];
    }

    public String getId(int i) {
        return this.id[i];
    }

    public TsData getData(int i) {
        return this.data[i];
    }

    protected boolean equals(TsVariables var) {
        return Arrays.deepEquals(this.id, var.id);
    }

    protected int hash() {
        return Arrays.hashCode(this.id);
    }
}

