/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.etree.bool;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.sqlengine.executor.etree.ETBoolean;
import com.amazon.sqlengine.executor.etree.IETNodeVisitor;
import com.amazon.sqlengine.executor.etree.bool.ETComplexBooleanExpr;
import com.amazon.sqlengine.executor.etree.bool.functor.comp.IBooleanCompFunctor;
import com.amazon.sqlengine.executor.etree.relation.ETRelationalExpr;
import com.amazon.sqlengine.executor.etree.value.ETValueExpr;
import com.amazon.support.exceptions.ErrorException;

public class ETInSQPredicate
extends ETComplexBooleanExpr {
    private IBooleanCompFunctor m_functor;

    public ETInSQPredicate(IColumn iColumn, ETValueExpr eTValueExpr, ETRelationalExpr eTRelationalExpr, IBooleanCompFunctor iBooleanCompFunctor) {
        super(iColumn, eTValueExpr, eTRelationalExpr);
        if (iBooleanCompFunctor == null) {
            throw new NullPointerException("ETInSQPredicate does not take null functor.");
        }
        this.m_functor = iBooleanCompFunctor;
    }

    @Override
    public <T> T acceptVisitor(IETNodeVisitor<T> iETNodeVisitor) throws ErrorException {
        return iETNodeVisitor.visit(this);
    }

    @Override
    public ETBoolean evaluate() throws ErrorException {
        this.fillLeftData();
        this.getRightOperand().reset();
        boolean bl = false;
        while (this.getRightOperand().move()) {
            this.fillRightData();
            ETBoolean eTBoolean = this.m_functor.evaluate(this.getLeftData().getData(), this.getRightData().getData());
            if (ETBoolean.SQL_BOOLEAN_TRUE == eTBoolean) {
                return eTBoolean;
            }
            if (ETBoolean.SQL_BOOLEAN_UNKNOWN != eTBoolean) continue;
            bl = true;
        }
        return bl ? ETBoolean.SQL_BOOLEAN_UNKNOWN : ETBoolean.SQL_BOOLEAN_FALSE;
    }
}

