/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex.impl;

import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix1DProcedure;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2DTest;
import cern.colt.matrix.tfcomplex.impl.DiagonalFComplexMatrix2D;
import cern.colt.matrix.tfloat.FloatFactory2D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.jet.math.tfcomplex.FComplex;
import cern.jet.math.tfcomplex.FComplexFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.ArrayList;

public class DiagonalFComplexMatrix2DTest
extends FComplexMatrix2DTest {
    protected int DLENGTH;
    protected int DINDEX;

    public DiagonalFComplexMatrix2DTest(String string) {
        super(string);
    }

    protected void createMatrices() throws Exception {
        this.DINDEX = 3;
        this.A = new DiagonalFComplexMatrix2D(this.NROWS, this.NCOLUMNS, this.DINDEX);
        this.B = new DiagonalFComplexMatrix2D(this.NROWS, this.NCOLUMNS, this.DINDEX);
        this.Bt = new DiagonalFComplexMatrix2D(this.NCOLUMNS, this.NROWS, -this.DINDEX);
        this.DLENGTH = ((DiagonalFComplexMatrix2D)this.A).diagonalLength();
    }

    protected void populateMatrices() {
        ConcurrencyUtils.setThreadsBeginN_2D(1);
        if (this.DINDEX >= 0) {
            int n;
            for (n = 0; n < this.DLENGTH; ++n) {
                this.A.setQuick(n, n + this.DINDEX, (float)Math.random(), (float)Math.random());
            }
            for (n = 0; n < this.DLENGTH; ++n) {
                this.B.setQuick(n, n + this.DINDEX, (float)Math.random(), (float)Math.random());
            }
            for (n = 0; n < this.DLENGTH; ++n) {
                this.Bt.setQuick(n - this.DINDEX, n, (float)Math.random(), (float)Math.random());
            }
        } else {
            int n;
            for (n = 0; n < this.DLENGTH; ++n) {
                this.A.setQuick(n - this.DINDEX, n, (float)Math.random(), (float)Math.random());
            }
            for (n = 0; n < this.DLENGTH; ++n) {
                this.B.setQuick(n - this.DINDEX, n, (float)Math.random(), (float)Math.random());
            }
            for (n = 0; n < this.DLENGTH; ++n) {
                this.Bt.setQuick(n, n + this.DINDEX, (float)Math.random(), (float)Math.random());
            }
        }
    }

    public void testAssignFloatFloat() {
        float[] fArray = new float[]{(float)Math.random(), (float)Math.random()};
        this.A.assign(fArray[0], fArray[1]);
        if (this.DINDEX >= 0) {
            for (int i = 0; i < this.DLENGTH; ++i) {
                this.assertEquals(fArray, this.A.getQuick(i, i + this.DINDEX), this.TOL);
            }
        } else {
            for (int i = 0; i < this.DLENGTH; ++i) {
                this.assertEquals(fArray, this.A.getQuick(i - this.DINDEX, i), this.TOL);
            }
        }
    }

    public void testAssignFloatArray() {
        int n;
        float[] fArray = new float[2 * this.DLENGTH];
        for (n = 0; n < 2 * this.DLENGTH; ++n) {
            fArray[n] = (float)Math.random();
        }
        this.A.assign(fArray);
        if (this.DINDEX >= 0) {
            for (n = 0; n < this.DLENGTH; ++n) {
                DiagonalFComplexMatrix2DTest.assertEquals((float)fArray[2 * n], (float)this.A.getQuick(n, n + this.DINDEX)[0], (float)this.TOL);
                DiagonalFComplexMatrix2DTest.assertEquals((float)fArray[2 * n + 1], (float)this.A.getQuick(n, n + this.DINDEX)[1], (float)this.TOL);
            }
        } else {
            for (n = 0; n < this.DLENGTH; ++n) {
                DiagonalFComplexMatrix2DTest.assertEquals((float)fArray[2 * n], (float)this.A.getQuick(n - this.DINDEX, n)[0], (float)this.TOL);
                DiagonalFComplexMatrix2DTest.assertEquals((float)fArray[2 * n + 1], (float)this.A.getQuick(n - this.DINDEX, n)[1], (float)this.TOL);
            }
        }
    }

    public void testAssignImaginary() {
        FloatMatrix2D floatMatrix2D = FloatFactory2D.dense.random(this.A.rows(), this.A.columns());
        FComplexMatrix2D fComplexMatrix2D = this.A.copy();
        this.A.assignImaginary(floatMatrix2D);
        if (this.DINDEX >= 0) {
            for (int i = 0; i < this.DLENGTH; ++i) {
                DiagonalFComplexMatrix2DTest.assertEquals((float)fComplexMatrix2D.getQuick(i, i + this.DINDEX)[0], (float)this.A.getQuick(i, i + this.DINDEX)[0], (float)this.TOL);
                DiagonalFComplexMatrix2DTest.assertEquals((float)floatMatrix2D.getQuick(i, i + this.DINDEX), (float)this.A.getQuick(i, i + this.DINDEX)[1], (float)this.TOL);
            }
        } else {
            for (int i = 0; i < this.DLENGTH; ++i) {
                DiagonalFComplexMatrix2DTest.assertEquals((float)fComplexMatrix2D.getQuick(i - this.DINDEX, i)[0], (float)this.A.getQuick(i - this.DINDEX, i)[0], (float)this.TOL);
                DiagonalFComplexMatrix2DTest.assertEquals((float)floatMatrix2D.getQuick(i - this.DINDEX, i), (float)this.A.getQuick(i - this.DINDEX, i)[1], (float)this.TOL);
            }
        }
    }

    public void testAssignReal() {
        FloatMatrix2D floatMatrix2D = FloatFactory2D.dense.random(this.A.rows(), this.A.columns());
        FComplexMatrix2D fComplexMatrix2D = this.A.copy();
        this.A.assignReal(floatMatrix2D);
        if (this.DINDEX >= 0) {
            for (int i = 0; i < this.DLENGTH; ++i) {
                DiagonalFComplexMatrix2DTest.assertEquals((float)fComplexMatrix2D.getQuick(i, i + this.DINDEX)[1], (float)this.A.getQuick(i, i + this.DINDEX)[1], (float)this.TOL);
                DiagonalFComplexMatrix2DTest.assertEquals((float)floatMatrix2D.getQuick(i, i + this.DINDEX), (float)this.A.getQuick(i, i + this.DINDEX)[0], (float)this.TOL);
            }
        } else {
            for (int i = 0; i < this.DLENGTH; ++i) {
                DiagonalFComplexMatrix2DTest.assertEquals((float)fComplexMatrix2D.getQuick(i - this.DINDEX, i)[1], (float)this.A.getQuick(i - this.DINDEX, i)[1], (float)this.TOL);
                DiagonalFComplexMatrix2DTest.assertEquals((float)floatMatrix2D.getQuick(i - this.DINDEX, i), (float)this.A.getQuick(i - this.DINDEX, i)[0], (float)this.TOL);
            }
        }
    }

    public void testAssignFloatArrayArray() {
        int n;
        float[][] fArray = new float[this.NROWS][2 * this.NCOLUMNS];
        for (n = 0; n < this.NROWS; ++n) {
            for (int i = 0; i < this.NCOLUMNS; ++i) {
                fArray[n][2 * i] = (float)Math.random();
                fArray[n][2 * i + 1] = (float)Math.random();
            }
        }
        this.A.assign(fArray);
        if (this.DINDEX >= 0) {
            for (n = 0; n < this.DLENGTH; ++n) {
                DiagonalFComplexMatrix2DTest.assertEquals((float)fArray[n][2 * (n + this.DINDEX)], (float)this.A.getQuick(n, n + this.DINDEX)[0], (float)this.TOL);
                DiagonalFComplexMatrix2DTest.assertEquals((float)fArray[n][2 * (n + this.DINDEX) + 1], (float)this.A.getQuick(n, n + this.DINDEX)[1], (float)this.TOL);
            }
        } else {
            for (n = 0; n < this.DLENGTH; ++n) {
                DiagonalFComplexMatrix2DTest.assertEquals((float)fArray[n - this.DINDEX][2 * n], (float)this.A.getQuick(n - this.DINDEX, n)[0], (float)this.TOL);
                DiagonalFComplexMatrix2DTest.assertEquals((float)fArray[n - this.DINDEX][2 * n + 1], (float)this.A.getQuick(n - this.DINDEX, n)[1], (float)this.TOL);
            }
        }
    }

    public void testAssignComplexComplexFunction() {
        FComplexMatrix2D fComplexMatrix2D = this.A.copy();
        this.A.assign(FComplexFunctions.acos);
        if (this.DINDEX >= 0) {
            for (int i = 0; i < this.DLENGTH; ++i) {
                float[] fArray = FComplex.acos(fComplexMatrix2D.getQuick(i, i + this.DINDEX));
                DiagonalFComplexMatrix2DTest.assertEquals((float)fArray[0], (float)this.A.getQuick(i, i + this.DINDEX)[0], (float)this.TOL);
                DiagonalFComplexMatrix2DTest.assertEquals((float)fArray[1], (float)this.A.getQuick(i, i + this.DINDEX)[1], (float)this.TOL);
            }
        } else {
            for (int i = 0; i < this.DLENGTH; ++i) {
                float[] fArray = FComplex.acos(fComplexMatrix2D.getQuick(i - this.DINDEX, i));
                DiagonalFComplexMatrix2DTest.assertEquals((float)fArray[0], (float)this.A.getQuick(i - this.DINDEX, i)[0], (float)this.TOL);
                DiagonalFComplexMatrix2DTest.assertEquals((float)fArray[1], (float)this.A.getQuick(i - this.DINDEX, i)[1], (float)this.TOL);
            }
        }
    }

    public void testAssignComplexMatrix2FComplexComplexComplexFunction() {
        FComplexMatrix2D fComplexMatrix2D = this.A.copy();
        this.A.assign(this.B, FComplexFunctions.div);
        if (this.DINDEX >= 0) {
            for (int i = 0; i < this.DLENGTH; ++i) {
                DiagonalFComplexMatrix2DTest.assertEquals((float)FComplex.div(fComplexMatrix2D.getQuick(i, i + this.DINDEX), this.B.getQuick(i, i + this.DINDEX))[0], (float)this.A.getQuick(i, i + this.DINDEX)[0], (float)this.TOL);
                DiagonalFComplexMatrix2DTest.assertEquals((float)FComplex.div(fComplexMatrix2D.getQuick(i, i + this.DINDEX), this.B.getQuick(i, i + this.DINDEX))[1], (float)this.A.getQuick(i, i + this.DINDEX)[1], (float)this.TOL);
            }
        } else {
            for (int i = 0; i < this.DLENGTH; ++i) {
                DiagonalFComplexMatrix2DTest.assertEquals((float)FComplex.div(fComplexMatrix2D.getQuick(i - this.DINDEX, i), this.B.getQuick(i - this.DINDEX, i))[0], (float)this.A.getQuick(i - this.DINDEX, i)[0], (float)this.TOL);
                DiagonalFComplexMatrix2DTest.assertEquals((float)FComplex.div(fComplexMatrix2D.getQuick(i - this.DINDEX, i), this.B.getQuick(i - this.DINDEX, i))[1], (float)this.A.getQuick(i - this.DINDEX, i)[1], (float)this.TOL);
            }
        }
    }

    public void testAssignFComplexMatrix2DFComplexFComplexFunctionIntArrayListIntArrayList() {
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        if (this.DINDEX >= 0) {
            for (int i = 0; i < this.DLENGTH; ++i) {
                intArrayList.add(i);
                intArrayList2.add(i + this.DINDEX);
            }
            FComplexMatrix2D fComplexMatrix2D = this.A.copy();
            this.A.assign(this.B, FComplexFunctions.div, intArrayList, intArrayList2);
            for (int i = 0; i < this.DLENGTH; ++i) {
                DiagonalFComplexMatrix2DTest.assertEquals((float)FComplex.div(fComplexMatrix2D.getQuick(i, i + this.DINDEX), this.B.getQuick(i, i + this.DINDEX))[0], (float)this.A.getQuick(i, i + this.DINDEX)[0], (float)this.TOL);
                DiagonalFComplexMatrix2DTest.assertEquals((float)FComplex.div(fComplexMatrix2D.getQuick(i, i + this.DINDEX), this.B.getQuick(i, i + this.DINDEX))[1], (float)this.A.getQuick(i, i + this.DINDEX)[1], (float)this.TOL);
            }
        } else {
            for (int i = 0; i < this.DLENGTH; ++i) {
                intArrayList.add(i - this.DINDEX);
                intArrayList2.add(i);
            }
            FComplexMatrix2D fComplexMatrix2D = this.A.copy();
            this.A.assign(this.B, FComplexFunctions.div, intArrayList, intArrayList2);
            for (int i = 0; i < this.DLENGTH; ++i) {
                DiagonalFComplexMatrix2DTest.assertEquals((float)FComplex.div(fComplexMatrix2D.getQuick(i - this.DINDEX, i), this.B.getQuick(i - this.DINDEX, i))[0], (float)this.A.getQuick(i - this.DINDEX, i)[0], (float)this.TOL);
                DiagonalFComplexMatrix2DTest.assertEquals((float)FComplex.div(fComplexMatrix2D.getQuick(i - this.DINDEX, i), this.B.getQuick(i - this.DINDEX, i))[1], (float)this.A.getQuick(i - this.DINDEX, i)[1], (float)this.TOL);
            }
        }
    }

    public void testCardinality() {
        int n = this.A.cardinality();
        DiagonalFComplexMatrix2DTest.assertEquals((int)this.DLENGTH, (int)n);
    }

    public void testGetNonZeros() {
        this.A.assign(0.0f, 0.0f);
        float[] fArray = new float[]{0.7f, 0.8f};
        float[] fArray2 = new float[]{0.1f, 0.2f};
        if (this.DINDEX >= 0) {
            this.A.setQuick(this.NROWS / 3, this.NROWS / 3 + this.DINDEX, fArray);
            this.A.setQuick(this.NROWS / 2, this.NROWS / 2 + this.DINDEX, fArray2);
            IntArrayList intArrayList = new IntArrayList();
            IntArrayList intArrayList2 = new IntArrayList();
            ArrayList<float[]> arrayList = new ArrayList<float[]>();
            this.A.getNonZeros(intArrayList, intArrayList2, arrayList);
            DiagonalFComplexMatrix2DTest.assertEquals((int)2, (int)intArrayList.size());
            DiagonalFComplexMatrix2DTest.assertEquals((int)2, (int)intArrayList2.size());
            DiagonalFComplexMatrix2DTest.assertEquals((int)2, (int)arrayList.size());
            DiagonalFComplexMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.NROWS / 3));
            DiagonalFComplexMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.NROWS / 2));
            DiagonalFComplexMatrix2DTest.assertTrue((boolean)intArrayList2.contains(this.NROWS / 3 + this.DINDEX));
            DiagonalFComplexMatrix2DTest.assertTrue((boolean)intArrayList2.contains(this.NROWS / 2 + this.DINDEX));
            this.assertEquals(this.A.getQuick(intArrayList.get(0), intArrayList2.get(0)), arrayList.get(0), this.TOL);
            this.assertEquals(this.A.getQuick(intArrayList.get(1), intArrayList2.get(1)), arrayList.get(1), this.TOL);
        } else {
            this.A.setQuick(this.NROWS / 3 - this.DINDEX, this.NROWS / 3, fArray);
            this.A.setQuick(this.NROWS / 2 - this.DINDEX, this.NROWS / 2, fArray2);
            IntArrayList intArrayList = new IntArrayList();
            IntArrayList intArrayList3 = new IntArrayList();
            ArrayList<float[]> arrayList = new ArrayList<float[]>();
            this.A.getNonZeros(intArrayList, intArrayList3, arrayList);
            DiagonalFComplexMatrix2DTest.assertEquals((int)2, (int)intArrayList.size());
            DiagonalFComplexMatrix2DTest.assertEquals((int)2, (int)intArrayList3.size());
            DiagonalFComplexMatrix2DTest.assertEquals((int)2, (int)arrayList.size());
            DiagonalFComplexMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.NROWS / 3 - this.DINDEX));
            DiagonalFComplexMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.NROWS / 2 - this.DINDEX));
            DiagonalFComplexMatrix2DTest.assertTrue((boolean)intArrayList3.contains(this.NROWS / 3));
            DiagonalFComplexMatrix2DTest.assertTrue((boolean)intArrayList3.contains(this.NROWS / 2));
            this.assertEquals(this.A.getQuick(intArrayList.get(0), intArrayList3.get(0)), arrayList.get(0), this.TOL);
            this.assertEquals(this.A.getQuick(intArrayList.get(1), intArrayList3.get(1)), arrayList.get(1), this.TOL);
        }
    }

    public void testToArray() {
        float[][] fArray = this.A.toArray();
        DiagonalFComplexMatrix2DTest.assertTrue((this.NROWS == fArray.length ? 1 : 0) != 0);
        for (int i = 0; i < this.NROWS; ++i) {
            DiagonalFComplexMatrix2DTest.assertTrue((2 * this.NCOLUMNS == fArray[i].length ? 1 : 0) != 0);
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                DiagonalFComplexMatrix2DTest.assertEquals((float)fArray[i][2 * j], (float)this.A.getQuick(i, j)[0], (float)this.TOL);
                DiagonalFComplexMatrix2DTest.assertEquals((float)fArray[i][2 * j + 1], (float)this.A.getQuick(i, j)[1], (float)this.TOL);
            }
        }
    }

    public void testVectorize() {
        FComplexMatrix1D fComplexMatrix1D = this.A.vectorize();
        int n = 0;
        for (int i = 0; i < this.NCOLUMNS; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                this.assertEquals(this.A.getQuick(j, i), fComplexMatrix1D.getQuick(n++), this.TOL);
            }
        }
    }

    public void testViewColumn() {
        FComplexMatrix1D fComplexMatrix1D = this.A.viewColumn(this.NCOLUMNS / 2);
        DiagonalFComplexMatrix2DTest.assertEquals((long)this.NROWS, (long)fComplexMatrix1D.size());
        for (int i = 0; i < this.NROWS; ++i) {
            this.assertEquals(this.A.getQuick(i, this.NCOLUMNS / 2), fComplexMatrix1D.getQuick(i), this.TOL);
        }
    }

    public void testViewColumnFlip() {
        FComplexMatrix2D fComplexMatrix2D = this.A.viewColumnFlip();
        DiagonalFComplexMatrix2DTest.assertEquals((long)this.A.size(), (long)fComplexMatrix2D.size());
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                this.assertEquals(this.A.getQuick(i, this.NCOLUMNS - 1 - j), fComplexMatrix2D.getQuick(i, j), this.TOL);
            }
        }
    }

    public void testViewDice() {
        FComplexMatrix2D fComplexMatrix2D = this.A.viewDice();
        DiagonalFComplexMatrix2DTest.assertEquals((int)this.NROWS, (int)fComplexMatrix2D.columns());
        DiagonalFComplexMatrix2DTest.assertEquals((int)this.NCOLUMNS, (int)fComplexMatrix2D.rows());
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                this.assertEquals(this.A.getQuick(i, j), fComplexMatrix2D.getQuick(j, i), this.TOL);
            }
        }
    }

    public void testViewPart() {
        FComplexMatrix2D fComplexMatrix2D = this.A.viewPart(this.NROWS / 2, this.NCOLUMNS / 2, this.NROWS / 3, this.NCOLUMNS / 3);
        DiagonalFComplexMatrix2DTest.assertEquals((int)(this.NROWS / 3), (int)fComplexMatrix2D.rows());
        DiagonalFComplexMatrix2DTest.assertEquals((int)(this.NCOLUMNS / 3), (int)fComplexMatrix2D.columns());
        for (int i = 0; i < this.NROWS / 3; ++i) {
            for (int j = 0; j < this.NCOLUMNS / 3; ++j) {
                this.assertEquals(this.A.getQuick(this.NROWS / 2 + i, this.NCOLUMNS / 2 + j), fComplexMatrix2D.getQuick(i, j), this.TOL);
            }
        }
    }

    public void testViewRow() {
        FComplexMatrix1D fComplexMatrix1D = this.A.viewRow(this.NROWS / 2);
        DiagonalFComplexMatrix2DTest.assertEquals((long)this.NCOLUMNS, (long)fComplexMatrix1D.size());
        for (int i = 0; i < this.NCOLUMNS; ++i) {
            this.assertEquals(this.A.getQuick(this.NROWS / 2, i), fComplexMatrix1D.getQuick(i), this.TOL);
        }
    }

    public void testViewRowFlip() {
        FComplexMatrix2D fComplexMatrix2D = this.A.viewRowFlip();
        DiagonalFComplexMatrix2DTest.assertEquals((long)this.A.size(), (long)fComplexMatrix2D.size());
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                this.assertEquals(this.A.getQuick(this.NROWS - 1 - i, j), fComplexMatrix2D.getQuick(i, j), this.TOL);
            }
        }
    }

    public void testViewSelectionComplexMatrix1DProcedure() {
        final float[] fArray = new float[]{2.0f, 3.0f};
        this.A.assign(0.0f, 0.0f);
        if (this.DINDEX >= 0) {
            this.A.setQuick(this.NROWS / 4, this.NROWS / 4 + this.DINDEX, fArray);
            this.A.setQuick(this.NROWS / 2, this.NROWS / 2 + this.DINDEX, fArray);
            FComplexMatrix2D fComplexMatrix2D = this.A.viewSelection(new FComplexMatrix1DProcedure(){

                public boolean apply(FComplexMatrix1D fComplexMatrix1D) {
                    return FComplex.abs(FComplex.minus(fComplexMatrix1D.getQuick(DiagonalFComplexMatrix2DTest.this.NROWS / 4 + DiagonalFComplexMatrix2DTest.this.DINDEX), fArray)) < DiagonalFComplexMatrix2DTest.this.TOL;
                }
            });
            DiagonalFComplexMatrix2DTest.assertEquals((int)1, (int)fComplexMatrix2D.rows());
            DiagonalFComplexMatrix2DTest.assertEquals((int)this.NCOLUMNS, (int)fComplexMatrix2D.columns());
            this.assertEquals(this.A.getQuick(this.NROWS / 4, this.NROWS / 4 + this.DINDEX), fComplexMatrix2D.getQuick(0, this.NROWS / 4 + this.DINDEX), this.TOL);
        } else {
            this.A.setQuick(this.NROWS / 4 - this.DINDEX, this.NROWS / 4, fArray);
            this.A.setQuick(this.NROWS / 2 - this.DINDEX, this.NROWS / 2, fArray);
            FComplexMatrix2D fComplexMatrix2D = this.A.viewSelection(new FComplexMatrix1DProcedure(){

                public boolean apply(FComplexMatrix1D fComplexMatrix1D) {
                    return FComplex.abs(FComplex.minus(fComplexMatrix1D.getQuick(DiagonalFComplexMatrix2DTest.this.NROWS / 4), fArray)) < DiagonalFComplexMatrix2DTest.this.TOL;
                }
            });
            DiagonalFComplexMatrix2DTest.assertEquals((int)1, (int)fComplexMatrix2D.rows());
            DiagonalFComplexMatrix2DTest.assertEquals((int)this.NCOLUMNS, (int)fComplexMatrix2D.columns());
            this.assertEquals(this.A.getQuick(this.NROWS / 4 - this.DINDEX, this.NROWS / 4), fComplexMatrix2D.getQuick(0, this.NROWS / 4), this.TOL);
        }
    }

    public void testViewSelectionIntArrayIntArray() {
        int[] nArray = new int[]{this.NROWS / 6, this.NROWS / 5, this.NROWS / 4, this.NROWS / 3, this.NROWS / 2};
        int[] nArray2 = new int[]{this.NROWS / 6, this.NROWS / 5, this.NROWS / 4, this.NROWS / 3, this.NROWS / 2, this.NROWS - 1};
        FComplexMatrix2D fComplexMatrix2D = this.A.viewSelection(nArray, nArray2);
        DiagonalFComplexMatrix2DTest.assertEquals((int)nArray.length, (int)fComplexMatrix2D.rows());
        DiagonalFComplexMatrix2DTest.assertEquals((int)nArray2.length, (int)fComplexMatrix2D.columns());
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray2.length; ++j) {
                this.assertEquals(this.A.getQuick(nArray[i], nArray2[j]), fComplexMatrix2D.getQuick(i, j), this.TOL);
            }
        }
    }

    public void testViewStrides() {
        int n = 3;
        int n2 = 5;
        FComplexMatrix2D fComplexMatrix2D = this.A.viewStrides(n, n2);
        for (int i = 0; i < fComplexMatrix2D.rows(); ++i) {
            for (int j = 0; j < fComplexMatrix2D.columns(); ++j) {
                this.assertEquals(this.A.getQuick(i * n, j * n2), fComplexMatrix2D.getQuick(i, j), this.TOL);
            }
        }
    }

    public void testZMultFComplexMatrix2DFComplexMatrix2DFComplexFComplexBooleanBoolean() {
        int n;
        float[] fArray;
        int n2;
        int n3;
        float[] fArray2 = new float[]{3.0f, 4.0f};
        float[] fArray3 = new float[]{5.0f, 6.0f};
        FComplexMatrix2D fComplexMatrix2D = new DiagonalFComplexMatrix2D(this.NROWS, this.NROWS, 0);
        for (int i = 0; i < this.DLENGTH; ++i) {
            fComplexMatrix2D.setQuick(i, i, (float)Math.random(), (float)Math.random());
        }
        float[][] fArray4 = fComplexMatrix2D.toArray();
        fComplexMatrix2D = this.A.zMult(this.Bt, fComplexMatrix2D, fArray2, fArray3, false, false);
        float[] fArray5 = new float[2];
        for (n3 = 0; n3 < this.NROWS; ++n3) {
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                fArray = new float[2];
                for (n = 0; n < this.NCOLUMNS; ++n) {
                    fArray = FComplex.plus(fArray, FComplex.mult(this.A.getQuick(n2, n), this.Bt.getQuick(n, n3)));
                }
                fArray5[0] = fArray4[n2][2 * n3];
                fArray5[1] = fArray4[n2][2 * n3 + 1];
                fArray5 = FComplex.mult(fArray3, fArray5);
                fArray = FComplex.mult(fArray2, fArray);
                fArray4[n2][2 * n3] = fArray[0] + fArray5[0];
                fArray4[n2][2 * n3 + 1] = fArray[1] + fArray5[1];
            }
        }
        for (n3 = 0; n3 < this.NROWS; ++n3) {
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                DiagonalFComplexMatrix2DTest.assertEquals((float)fArray4[n3][2 * n2], (float)fComplexMatrix2D.getQuick(n3, n2)[0], (float)this.TOL);
                DiagonalFComplexMatrix2DTest.assertEquals((float)fArray4[n3][2 * n2 + 1], (float)fComplexMatrix2D.getQuick(n3, n2)[1], (float)this.TOL);
            }
        }
        fComplexMatrix2D = null;
        fComplexMatrix2D = this.A.zMult(this.Bt, fComplexMatrix2D, fArray2, fArray3, false, false);
        fArray4 = new float[this.NROWS][2 * this.NROWS];
        for (n3 = 0; n3 < this.NROWS; ++n3) {
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                fArray = new float[2];
                for (n = 0; n < this.NCOLUMNS; ++n) {
                    fArray = FComplex.plus(fArray, FComplex.mult(this.A.getQuick(n2, n), this.Bt.getQuick(n, n3)));
                }
                fArray = FComplex.mult(fArray2, fArray);
                fArray4[n2][2 * n3] = fArray[0];
                fArray4[n2][2 * n3 + 1] = fArray[1];
            }
        }
        for (n3 = 0; n3 < this.NROWS; ++n3) {
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                DiagonalFComplexMatrix2DTest.assertEquals((float)fArray4[n3][2 * n2], (float)fComplexMatrix2D.getQuick(n3, n2)[0], (float)this.TOL);
                DiagonalFComplexMatrix2DTest.assertEquals((float)fArray4[n3][2 * n2 + 1], (float)fComplexMatrix2D.getQuick(n3, n2)[1], (float)this.TOL);
            }
        }
        fComplexMatrix2D = new DiagonalFComplexMatrix2D(this.NCOLUMNS, this.NCOLUMNS, 0);
        for (n3 = 0; n3 < this.DLENGTH; ++n3) {
            fComplexMatrix2D.setQuick(n3, n3, (float)Math.random(), (float)Math.random());
        }
        fArray4 = fComplexMatrix2D.toArray();
        fComplexMatrix2D = this.A.zMult(this.B, fComplexMatrix2D, fArray2, fArray3, true, false);
        for (n3 = 0; n3 < this.NCOLUMNS; ++n3) {
            for (n2 = 0; n2 < this.NCOLUMNS; ++n2) {
                fArray = new float[2];
                for (n = 0; n < this.NROWS; ++n) {
                    fArray = FComplex.plus(fArray, FComplex.mult(FComplex.conj(this.A.getQuick(n, n2)), this.B.getQuick(n, n3)));
                }
                fArray5[0] = fArray4[n2][2 * n3];
                fArray5[1] = fArray4[n2][2 * n3 + 1];
                fArray5 = FComplex.mult(fArray3, fArray5);
                fArray = FComplex.mult(fArray2, fArray);
                fArray4[n2][2 * n3] = fArray[0] + fArray5[0];
                fArray4[n2][2 * n3 + 1] = fArray[1] + fArray5[1];
            }
        }
        for (n3 = 0; n3 < this.NCOLUMNS; ++n3) {
            for (n2 = 0; n2 < this.NCOLUMNS; ++n2) {
                DiagonalFComplexMatrix2DTest.assertEquals((float)fArray4[n3][2 * n2], (float)fComplexMatrix2D.getQuick(n3, n2)[0], (float)this.TOL);
                DiagonalFComplexMatrix2DTest.assertEquals((float)fArray4[n3][2 * n2 + 1], (float)fComplexMatrix2D.getQuick(n3, n2)[1], (float)this.TOL);
            }
        }
        fComplexMatrix2D = null;
        fComplexMatrix2D = this.A.zMult(this.B, fComplexMatrix2D, fArray2, fArray3, true, false);
        fArray4 = new float[this.NCOLUMNS][2 * this.NCOLUMNS];
        for (n3 = 0; n3 < this.NCOLUMNS; ++n3) {
            for (n2 = 0; n2 < this.NCOLUMNS; ++n2) {
                fArray = new float[2];
                for (n = 0; n < this.NROWS; ++n) {
                    fArray = FComplex.plus(fArray, FComplex.mult(FComplex.conj(this.A.getQuick(n, n2)), this.B.getQuick(n, n3)));
                }
                fArray = FComplex.mult(fArray2, fArray);
                fArray4[n2][2 * n3] = fArray[0];
                fArray4[n2][2 * n3 + 1] = fArray[1];
            }
        }
        for (n3 = 0; n3 < this.NCOLUMNS; ++n3) {
            for (n2 = 0; n2 < this.NCOLUMNS; ++n2) {
                DiagonalFComplexMatrix2DTest.assertEquals((float)fArray4[n3][2 * n2], (float)fComplexMatrix2D.getQuick(n3, n2)[0], (float)this.TOL);
                DiagonalFComplexMatrix2DTest.assertEquals((float)fArray4[n3][2 * n2 + 1], (float)fComplexMatrix2D.getQuick(n3, n2)[1], (float)this.TOL);
            }
        }
        fComplexMatrix2D = new DiagonalFComplexMatrix2D(this.NROWS, this.NROWS, 0);
        for (n3 = 0; n3 < this.DLENGTH; ++n3) {
            fComplexMatrix2D.setQuick(n3, n3, (float)Math.random(), (float)Math.random());
        }
        fArray4 = fComplexMatrix2D.toArray();
        fComplexMatrix2D = this.A.zMult(this.B, fComplexMatrix2D, fArray2, fArray3, false, true);
        for (n3 = 0; n3 < this.NROWS; ++n3) {
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                fArray = new float[2];
                for (n = 0; n < this.NCOLUMNS; ++n) {
                    fArray = FComplex.plus(fArray, FComplex.mult(this.A.getQuick(n2, n), FComplex.conj(this.B.getQuick(n3, n))));
                }
                fArray5[0] = fArray4[n2][2 * n3];
                fArray5[1] = fArray4[n2][2 * n3 + 1];
                fArray5 = FComplex.mult(fArray3, fArray5);
                fArray = FComplex.mult(fArray2, fArray);
                fArray4[n2][2 * n3] = fArray[0] + fArray5[0];
                fArray4[n2][2 * n3 + 1] = fArray[1] + fArray5[1];
            }
        }
        for (n3 = 0; n3 < this.NROWS; ++n3) {
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                DiagonalFComplexMatrix2DTest.assertEquals((float)fArray4[n3][2 * n2], (float)fComplexMatrix2D.getQuick(n3, n2)[0], (float)this.TOL);
                DiagonalFComplexMatrix2DTest.assertEquals((float)fArray4[n3][2 * n2 + 1], (float)fComplexMatrix2D.getQuick(n3, n2)[1], (float)this.TOL);
            }
        }
        fComplexMatrix2D = null;
        fComplexMatrix2D = this.A.zMult(this.B, fComplexMatrix2D, fArray2, fArray3, false, true);
        fArray4 = new float[this.NROWS][2 * this.NROWS];
        for (n3 = 0; n3 < this.NROWS; ++n3) {
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                fArray = new float[2];
                for (n = 0; n < this.NCOLUMNS; ++n) {
                    fArray = FComplex.plus(fArray, FComplex.mult(this.A.getQuick(n2, n), FComplex.conj(this.B.getQuick(n3, n))));
                }
                fArray = FComplex.mult(fArray2, fArray);
                fArray4[n2][2 * n3] = fArray[0];
                fArray4[n2][2 * n3 + 1] = fArray[1];
            }
        }
        for (n3 = 0; n3 < this.NROWS; ++n3) {
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                DiagonalFComplexMatrix2DTest.assertEquals((float)fArray4[n3][2 * n2], (float)fComplexMatrix2D.getQuick(n3, n2)[0], (float)this.TOL);
                DiagonalFComplexMatrix2DTest.assertEquals((float)fArray4[n3][2 * n2 + 1], (float)fComplexMatrix2D.getQuick(n3, n2)[1], (float)this.TOL);
            }
        }
        fComplexMatrix2D = new DiagonalFComplexMatrix2D(this.NCOLUMNS, this.NCOLUMNS, 0);
        for (n3 = 0; n3 < this.DLENGTH; ++n3) {
            fComplexMatrix2D.setQuick(n3, n3, (float)Math.random(), (float)Math.random());
        }
        fArray4 = fComplexMatrix2D.toArray();
        fComplexMatrix2D = this.A.zMult(this.Bt, fComplexMatrix2D, fArray2, fArray3, true, true);
        for (n3 = 0; n3 < this.NCOLUMNS; ++n3) {
            for (n2 = 0; n2 < this.NCOLUMNS; ++n2) {
                fArray = new float[2];
                for (n = 0; n < this.NROWS; ++n) {
                    fArray = FComplex.plus(fArray, FComplex.mult(FComplex.conj(this.A.getQuick(n, n2)), FComplex.conj(this.Bt.getQuick(n3, n))));
                }
                fArray5[0] = fArray4[n2][2 * n3];
                fArray5[1] = fArray4[n2][2 * n3 + 1];
                fArray5 = FComplex.mult(fArray3, fArray5);
                fArray = FComplex.mult(fArray2, fArray);
                fArray4[n2][2 * n3] = fArray[0] + fArray5[0];
                fArray4[n2][2 * n3 + 1] = fArray[1] + fArray5[1];
            }
        }
        for (n3 = 0; n3 < this.NCOLUMNS; ++n3) {
            for (n2 = 0; n2 < this.NCOLUMNS; ++n2) {
                DiagonalFComplexMatrix2DTest.assertEquals((float)fArray4[n3][2 * n2], (float)fComplexMatrix2D.getQuick(n3, n2)[0], (float)this.TOL);
                DiagonalFComplexMatrix2DTest.assertEquals((float)fArray4[n3][2 * n2 + 1], (float)fComplexMatrix2D.getQuick(n3, n2)[1], (float)this.TOL);
            }
        }
        fComplexMatrix2D = null;
        fComplexMatrix2D = this.A.zMult(this.Bt, fComplexMatrix2D, fArray2, fArray3, true, true);
        fArray4 = new float[this.NCOLUMNS][2 * this.NCOLUMNS];
        for (n3 = 0; n3 < this.NCOLUMNS; ++n3) {
            for (n2 = 0; n2 < this.NCOLUMNS; ++n2) {
                fArray = new float[2];
                for (n = 0; n < this.NROWS; ++n) {
                    fArray = FComplex.plus(fArray, FComplex.mult(this.A.getQuick(n, n2), this.Bt.getQuick(n3, n)));
                }
                fArray = FComplex.mult(fArray2, fArray);
                fArray4[n2][2 * n3] = fArray[0];
                fArray4[n2][2 * n3 + 1] = fArray[1];
            }
        }
        for (n3 = 0; n3 < this.NCOLUMNS; ++n3) {
            for (n2 = 0; n2 < this.NCOLUMNS; ++n2) {
                DiagonalFComplexMatrix2DTest.assertEquals((float)fArray4[n3][2 * n2], (float)fComplexMatrix2D.getQuick(n3, n2)[0], (float)this.TOL);
                DiagonalFComplexMatrix2DTest.assertEquals((float)fArray4[n3][2 * n2 + 1], (float)fComplexMatrix2D.getQuick(n3, n2)[1], (float)this.TOL);
            }
        }
    }
}

