/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit;

import ec.satoolkit.ISaSpecification;
import ec.satoolkit.tramoseats.TramoSeatsSpecification;
import ec.satoolkit.x13.X13Specification;
import ec.tstoolkit.information.InformationSet;
import java.util.Map;
import java.util.Objects;

public class SaSpecification
implements ISaSpecification,
Cloneable {
    private Method method = Method.None;
    private Spec specification = Spec.RSA0;
    public static final String METHOD = "method";
    public static final String SPEC = "spec";

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public Spec getSpecification() {
        return this.specification;
    }

    public void setSpecification(Spec specification) {
        this.specification = specification;
    }

    @Override
    public String toLongString() {
        return this.method.name();
    }

    public boolean isDefault() {
        return this.method == Method.None;
    }

    public boolean equals(SaSpecification other) {
        return Objects.equals((Object)this.method, (Object)other.method) && Objects.equals((Object)this.specification, (Object)other.specification);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof SaSpecification && this.equals((SaSpecification)obj);
    }

    @Override
    public SaSpecification clone() {
        try {
            return (SaSpecification)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    @Override
    public InformationSet write(boolean verbose) {
        InformationSet info = new InformationSet();
        info.add(METHOD, this.method.name());
        if (this.specification != Spec.RSA0 || verbose) {
            info.add(SPEC, this.specification.name());
        }
        return info;
    }

    @Override
    public boolean read(InformationSet info) {
        try {
            String s;
            String m = info.get(METHOD, String.class);
            if (m != null) {
                this.method = Method.valueOf(m);
            }
            if ((s = info.get(SPEC, String.class)) != null) {
                this.specification = Spec.valueOf(s);
            }
            return true;
        }
        catch (Exception err) {
            return false;
        }
    }

    public ISaSpecification getFullSpecification() {
        if (this.method == Method.X13) {
            switch (this.specification.ordinal()) {
                case 0: {
                    return X13Specification.RSA0;
                }
                case 1: {
                    return X13Specification.RSA1;
                }
                case 2: {
                    return X13Specification.RSA2;
                }
                case 3: {
                    return X13Specification.RSA3;
                }
                case 4: {
                    return X13Specification.RSA4;
                }
                case 5: {
                    return X13Specification.RSA5;
                }
            }
        } else if (this.method == Method.TramoSeats) {
            switch (this.specification.ordinal()) {
                case 0: {
                    return TramoSeatsSpecification.RSA0;
                }
                case 1: {
                    return TramoSeatsSpecification.RSA1;
                }
                case 2: {
                    return TramoSeatsSpecification.RSA2;
                }
                case 3: {
                    return TramoSeatsSpecification.RSA3;
                }
                case 4: {
                    return TramoSeatsSpecification.RSA4;
                }
                case 5: {
                    return TramoSeatsSpecification.RSA5;
                }
            }
        }
        return null;
    }

    public static void fillDictionary(String prefix, Map<String, Class> dic) {
        dic.put(InformationSet.item(prefix, METHOD), String.class);
        dic.put(InformationSet.item(prefix, SPEC), String.class);
    }

    public static enum Method {
        None,
        TramoSeats,
        X13;

    }

    public static enum Spec {
        RSA0,
        RSA1,
        RSA2,
        RSA3,
        RSA4,
        RSA5;

    }
}

