/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.matrices;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.maths.matrices.AbstractLinearSystemSolver;
import ec.tstoolkit.maths.matrices.ILuDecomposition;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.MatrixException;

public abstract class LuDecomposition
extends AbstractLinearSystemSolver
implements ILuDecomposition {
    protected double[] lu_ = null;
    protected int n_;
    protected int pivsign_;
    protected int[] piv_;

    protected double get(int r, int c) {
        return this.lu_[c * this.n_ + r];
    }

    protected void set(int r, int c, double value) {
        this.lu_[c * this.n_ + r] = value;
    }

    void init(Matrix m, boolean clone) {
        if (m.getRowsCount() != m.getColumnsCount()) {
            throw new MatrixException("LU Decomposition: not squared matrix");
        }
        this.lu_ = clone ? (double[])m.data_.clone() : m.data_;
        this.n_ = m.getRowsCount();
        this.piv_ = new int[this.n_];
        for (int i = 0; i < this.n_; ++i) {
            this.piv_[i] = i;
        }
        this.pivsign_ = 1;
    }

    @Override
    public boolean isFullRank() {
        for (int j = 0; j < this.n_; ++j) {
            if (!(Math.abs(this.get(j, j)) < this.getEpsilon())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getEquationsCount() {
        return this.n_;
    }

    @Override
    public int getUnknownsCount() {
        return this.n_;
    }

    @Override
    public Matrix getL() {
        Matrix l = new Matrix(this.n_, this.n_);
        int idx = 0;
        for (int c = 0; c < this.n_; ++c) {
            l.data_[idx] = 1.0;
            idx += c + 1;
            int r = c + 1;
            while (r < this.n_) {
                l.data_[idx] = this.lu_[idx];
                ++r;
                ++idx;
            }
        }
        return l;
    }

    @Override
    public Matrix getU() {
        Matrix u = new Matrix(this.n_, this.n_);
        int idx = 0;
        for (int c = 0; c < this.n_; ++c) {
            int r = 0;
            while (r <= c) {
                u.data_[idx] = this.lu_[idx];
                ++r;
                ++idx;
            }
            idx += this.n_ - c - 1;
        }
        return u;
    }

    public int[] getPivot() {
        return (int[])this.piv_.clone();
    }

    public int[] getReversePivot() {
        int[] rpiv = new int[this.n_];
        for (int i = 0; i < this.n_; ++i) {
            rpiv[this.piv_[i]] = i;
        }
        return rpiv;
    }

    public double getDeterminant() {
        double d = this.pivsign_;
        for (int j = 0; j < this.n_; ++j) {
            d *= this.get(j, j);
        }
        return d;
    }

    @Override
    public void solve(DataBlock xin, DataBlock xout) {
        int i;
        int i2;
        if (xin.getLength() != this.n_) {
            throw new MatrixException("Incompatible dimensions");
        }
        if (!this.isFullRank()) {
            throw new MatrixException("LU decomposition: singular matrix");
        }
        double[] y = new double[this.n_];
        double[] x = new double[this.n_];
        for (i2 = 0; i2 < this.n_; ++i2) {
            y[i2] = xin.get(this.piv_[i2]);
        }
        x[0] = y[0];
        for (i2 = 1; i2 < this.n_; ++i2) {
            x[i2] = y[i2];
            for (int j = 0; j < i2; ++j) {
                int n = i2;
                x[n] = x[n] - this.lu_[j * this.n_ + i2] * x[j];
            }
        }
        int n = this.n_;
        for (i = n - 1; i >= 0 && x[i] == 0.0; --i) {
            --n;
        }
        if (n == 0) {
            return;
        }
        y[n - 1] = x[n - 1] / this.lu_[(n - 1) * this.n_ + (n - 1)];
        for (i = n - 2; i >= 0; --i) {
            double sum = x[i];
            for (int j = i + 1; j < n; ++j) {
                sum -= this.lu_[j * this.n_ + i] * y[j];
            }
            y[i] = sum / this.lu_[i * this.n_ + i];
        }
        xout.copyFrom(y, 0);
    }
}

