/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf;

import ec.tstoolkit.ssf.ISsfData;

public class ExtendedSsfData
implements ISsfData {
    private int m_nbcasts;
    private int m_nfcasts;
    private final ISsfData m_data;

    public ExtendedSsfData(ISsfData data) {
        this.m_data = data;
    }

    @Override
    public double get(int n) {
        if (n < this.m_nbcasts) {
            return Double.NaN;
        }
        return this.m_data.get(n - this.m_nbcasts);
    }

    public int getBackcastsCount() {
        return this.m_nbcasts;
    }

    @Override
    public int getCount() {
        return this.m_nbcasts + this.m_nfcasts + this.m_data.getCount();
    }

    public int getForecastsCount() {
        return this.m_nfcasts;
    }

    @Override
    public double[] getInitialState() {
        return this.m_data.getInitialState();
    }

    @Override
    public int getObsCount() {
        return this.m_data.getObsCount();
    }

    @Override
    public boolean hasData() {
        return this.m_data.hasData();
    }

    @Override
    public boolean hasMissingValues() {
        return this.m_nbcasts > 0 || this.m_nfcasts > 0 || this.m_data.hasMissingValues();
    }

    @Override
    public boolean isMissing(int pos) {
        if (pos < this.m_nbcasts) {
            return true;
        }
        return this.m_data.isMissing(pos - this.m_nbcasts);
    }

    public void setBackcastsCount(int value) {
        this.m_nbcasts = value;
    }

    public void setForecastsCount(int value) {
        this.m_nfcasts = value;
    }
}

