/*
 * Decompiled with CFR 0.152.
 */
package org.act.rscat.mip;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Constraint {
    private static final String STR_NULL = "Null";
    private static final String DATA_SET_DELIMITER = "#";
    private static final String DATA_ELEMENT_DELIMITER = "\\|";
    private static final String BOUND_FILTER = "Bounds";
    private static final String SET_FILTER = "Set";
    private static final double BIG_NUMBER = 1000000.0;
    public int rowIndex;
    public String id;
    public String description;
    public String type;
    public String level;
    public String calAttr;
    public double calLB;
    public double calUB;
    public Map<String, List<Double>> filterBoundsData;
    public Map<String, Set<String>> filterSetData;
    public double activity;

    public Constraint(List<String> columnNameList, String[] data, int rowIndex) {
        this.rowIndex = rowIndex;
        this.id = data[columnNameList.indexOf(ColumnName.ID.name)];
        this.description = data[columnNameList.indexOf(ColumnName.DESCRIPTION.name)];
        this.type = data[columnNameList.indexOf(ColumnName.TYPE.name)];
        this.level = data[columnNameList.indexOf(ColumnName.LEVEL.name)];
        this.calAttr = data[columnNameList.indexOf(ColumnName.CAL_ATTR.name)];
        this.calLB = !data[columnNameList.indexOf(ColumnName.CAL_LB.name)].equals(STR_NULL) ? Double.parseDouble(data[columnNameList.indexOf(ColumnName.CAL_LB.name)]) : -1000000.0;
        this.calUB = !data[columnNameList.indexOf(ColumnName.CAL_UB.name)].equals(STR_NULL) ? Double.parseDouble(data[columnNameList.indexOf(ColumnName.CAL_UB.name)]) : 1000000.0;
        List<String> filterAttr = Arrays.asList(data[columnNameList.indexOf(ColumnName.FILTER_ATTR.name)].split(DATA_ELEMENT_DELIMITER));
        List<String> filterLogic = Arrays.asList(data[columnNameList.indexOf(ColumnName.FILTER_LOGIC.name)].split(DATA_ELEMENT_DELIMITER));
        List<String> filterDataSet = Arrays.asList(data[columnNameList.indexOf(ColumnName.FILTER_DATA.name)].split(DATA_SET_DELIMITER));
        Iterator<String> attrIt = filterAttr.iterator();
        Iterator<String> logicIt = filterLogic.iterator();
        Iterator<String> dataSetIt = filterDataSet.iterator();
        this.filterBoundsData = new HashMap<String, List<Double>>();
        this.filterSetData = new HashMap<String, Set<String>>();
        while (attrIt.hasNext() && logicIt.hasNext() && dataSetIt.hasNext()) {
            String attrStr = attrIt.next();
            String logicStr = logicIt.next();
            String dataSetStr = dataSetIt.next();
            if (logicStr.equalsIgnoreCase(BOUND_FILTER)) {
                List<String> dataStr = Arrays.asList(dataSetStr.split(DATA_ELEMENT_DELIMITER));
                ArrayList<Double> dataDouble = new ArrayList<Double>();
                for (String str : dataStr) {
                    dataDouble.add(Double.parseDouble(str));
                }
                this.filterBoundsData.put(attrStr, dataDouble);
                continue;
            }
            if (!logicStr.equals(SET_FILTER)) continue;
            HashSet<String> dataSet = new HashSet<String>(Arrays.asList(dataSetStr.split(DATA_ELEMENT_DELIMITER)));
            this.filterSetData.put(attrStr, dataSet);
        }
    }

    public static enum ColumnName {
        ID("Id"),
        DESCRIPTION("Description"),
        TYPE("Type"),
        LEVEL("Level"),
        CAL_ATTR("CalAttr"),
        CAL_LB("CalLB"),
        CAL_UB("CalUB"),
        FILTER_ATTR("FilterAttr"),
        FILTER_LOGIC("FilterLogic"),
        FILTER_DATA("FilterData"),
        IS_LOADED("IsLoaded");

        private String name;

        private ColumnName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

