/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.functions.minpack;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.functions.FunctionException;
import jdplus.toolkit.base.core.math.functions.ParamValidation;
import jdplus.toolkit.base.core.math.functions.minpack.IEstimationProblem;
import jdplus.toolkit.base.core.math.functions.ssq.ISsqFunction;
import jdplus.toolkit.base.core.math.functions.ssq.ISsqFunctionDerivatives;
import jdplus.toolkit.base.core.math.functions.ssq.ISsqFunctionPoint;

public class SsqEstimationProblem
implements IEstimationProblem {
    private final DataBlock parameters;
    private ISsqFunctionPoint ftry;
    private final ISsqFunction fn;
    private ISsqFunctionDerivatives derivatives;

    @Override
    public SsqEstimationProblem save() {
        SsqEstimationProblem copy = new SsqEstimationProblem(this.ftry);
        copy.derivatives = this.derivatives;
        return copy;
    }

    public SsqEstimationProblem(ISsqFunctionPoint start) {
        this.ftry = start;
        this.fn = this.ftry.getSsqFunction();
        this.parameters = DataBlock.of(start.getParameters());
    }

    @Override
    public void bound(int idx, boolean bound) {
        throw new FunctionException("The method or operation is not implemented.");
    }

    @Override
    public boolean compute() {
        ParamValidation validate = this.fn.getDomain().validate(this.parameters);
        if (validate != ParamValidation.Valid) {
            return false;
        }
        try {
            this.ftry = this.fn.ssqEvaluate((DoubleSeq)this.parameters);
            return true;
        }
        catch (Exception err) {
            this.ftry = null;
            return false;
        }
    }

    private void clear() {
        this.derivatives = null;
        this.ftry = null;
    }

    @Override
    public double getMeasurementParialDerivative(int midx, int pidx) {
        if (this.ftry == null) {
            return Math.sqrt(Double.MAX_VALUE);
        }
        if (this.derivatives == null) {
            this.derivatives = this.ftry.ssqDerivatives();
        }
        return -this.derivatives.dEdX(pidx).get(midx);
    }

    @Override
    public int getMeasurementsCount() {
        return this.ftry == null ? 0 : this.ftry.getE().length();
    }

    @Override
    public double getMeasurementValue(int idx) {
        return this.ftry == null ? Math.sqrt(Double.MAX_VALUE) : this.ftry.getE().get(idx);
    }

    @Override
    public double getMeasurementWheight(int idx) {
        return 1.0;
    }

    @Override
    public double getParameterEstimate(int idx) {
        return this.parameters.get(idx);
    }

    @Override
    public int getParametersCount() {
        return this.parameters.length();
    }

    @Override
    public double getResidual(int midx) {
        return this.ftry == null ? Math.sqrt(Double.MAX_VALUE) : this.ftry.getE().get(midx);
    }

    public ISsqFunctionPoint getResult() {
        return this.ftry;
    }

    @Override
    public double getTheoreticalValue(int midx) {
        return 0.0;
    }

    @Override
    public double getUnboundParameterEstimate(int idx) {
        return this.parameters.get(idx);
    }

    @Override
    public int getUnboundParametersCount() {
        return this.parameters.length();
    }

    @Override
    public void ignoreMeasurement(int idx, boolean ignore) {
    }

    @Override
    public boolean isBound(int idx) {
        return false;
    }

    @Override
    public boolean isMeasurementIgnore(int idx) {
        return false;
    }

    @Override
    public void setParameterEstimate(int idx, double val) {
        if (this.parameters.get(idx) != val) {
            this.parameters.set(idx, val);
            this.clear();
        }
    }

    @Override
    public void setUnboundParameterEstimate(int idx, double val) {
        if (this.parameters.get(idx) != val) {
            this.parameters.set(idx, val);
            this.clear();
        }
    }

    public DoubleSeq gradient() {
        if (this.ftry == null) {
            return null;
        }
        return this.ftry.ssqDerivatives().gradient();
    }
}

