## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  message = FALSE,
  warning = FALSE
)

## ----library setup------------------------------------------------------------
library(sstn)

## ----example setup------------------------------------------------------------
set.seed(123)

# Sample from standard normal (null hypothesis true)
x <- rnorm(100)
res <- sstn(x)
res$p_value

# Sample from Gamma distribution (null hypothesis false)
y <- rgamma(100, 1)
res2 <- sstn(y)
res2$p_value


