// Copyright (C) 1997-1999  Adrian Trapletti
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

//
// Set of integers class
//


#include "utils.hh"
#include "intset.hh"
extern "C" {
#include "nrutil.h"
}


intset::intset (int n)  // subset of {1..n}
{
  int i;

#ifdef CHECK
  if (n < 1) RTerror ("intset.cc", "intset::intset (int n)");
#endif
  cursize = 0;
  maxval = n;
  x = ivector (0, maxval-1);
  for (i=0; i<maxval; i++) x[i] = 0;
}

intset::~intset ()
{
  free_ivector (x, 0, maxval-1);
}

void intset::insert (int t)  // add "t" to set
{
#ifdef CHECK
  if ((t < 1) || (maxval < t)) RTerror ("intset.cc", "void intset::insert (int t)");
#endif
  if (!(*this).member(t))
  {
    cursize++;
    x[t-1] = 1;  // insert new element
  }
}

void intset::remove (int t)  // remove "t" from set
{
#ifdef CHECK
  if ((t < 1) || (maxval < t)) RTerror ("intset.cc", "void intset::remove (int t)");
#endif
  if ((*this).member(t))
  {
    cursize--;
    x[t-1] = 0;  // insert new element
  }
}

#ifdef CHECK
int intset::member (int t) const  // is "t" a member? 
{
  if ((t < 1) || (maxval < t)) RTerror ("intset.cc", "int intset::member (int t) const");
  return x[t-1] == 1;
}
#endif 




